/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.workbench.model.editor.ui.views;

import com.isencia.passerelle.actor.Actor;
import com.isencia.passerelle.actor.gui.PasserelleConfigurer;
import com.isencia.passerelle.domain.cap.Director;
import com.isencia.passerelle.workbench.model.editor.ui.Activator;
import com.isencia.passerelle.workbench.model.editor.ui.HelpUtils;
import com.isencia.passerelle.workbench.model.editor.ui.editor.PasserelleModelMultiPageEditor;
import com.isencia.passerelle.workbench.model.editor.ui.editor.actions.DeleteAttributeHandler;
import com.isencia.passerelle.workbench.model.editor.ui.editpart.AbstractBaseEditPart;
import com.isencia.passerelle.workbench.model.editor.ui.palette.PaletteItemFactory;
import com.isencia.passerelle.workbench.model.editor.ui.properties.NamedObjComparator;
import com.isencia.passerelle.workbench.model.editor.ui.views.PropertyLabelProvider;
import com.isencia.passerelle.workbench.model.editor.ui.views.VariableEditingSupport;
import com.isencia.passerelle.workbench.model.editor.ui.views.VariableLabelProvider;
import com.isencia.passerelle.workbench.model.ui.GeneralAttribute;
import com.isencia.passerelle.workbench.model.ui.command.AttributeCommand;
import com.isencia.passerelle.workbench.model.ui.command.RenameCommand;
import com.isencia.passerelle.workbench.model.ui.utils.EclipseUtils;
import com.isencia.passerelle.workbench.model.utils.ModelUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStackEvent;
import org.eclipse.gef.commands.CommandStackEventListener;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.help.WorkbenchHelpSystem;
import org.eclipse.ui.part.ViewPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.data.expr.Parameter;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Settable;
import ptolemy.kernel.util.StringAttribute;
import ptolemy.vergil.kernel.attributes.TextAttribute;

public class ActorAttributesView
extends ViewPart
implements ISelectionListener,
CommandStackEventListener {
    private NamedObj dialogActor;
    private static Logger logger = LoggerFactory.getLogger(ActorAttributesView.class);
    public static final String ID = "com.isencia.passerelle.workbench.model.editor.ui.views.ActorAttributesView";
    private TableViewer viewer;
    private NamedObj actor;
    private boolean addedListener = false;
    private IWorkbenchPart part;
    private VariableEditingSupport valueColumnEditor;

    public void setSite(IWorkbenchPartSite iWorkbenchPartSite) {
        super.setSite(iWorkbenchPartSite);
    }

    public void setActor(NamedObj namedObj) {
        this.dialogActor = namedObj;
    }

    public void selectionChanged(IWorkbenchPart iWorkbenchPart, ISelection iSelection) {
        if (iWorkbenchPart instanceof PasserelleModelMultiPageEditor) {
            this.part = iWorkbenchPart;
            if (this.updateSelection(iSelection)) {
                return;
            }
            this.clear();
        }
    }

    protected boolean updateSelection(ISelection iSelection) {
        if (!(iSelection instanceof StructuredSelection)) {
            return false;
        }
        Object object = ((StructuredSelection)iSelection).getFirstElement();
        if (object instanceof AbstractBaseEditPart) {
            ArrayList<Attribute> arrayList = new ArrayList<Attribute>();
            this.actor = this.dialogActor == null ? (NamedObj)((AbstractBaseEditPart)((Object)object)).getModel() : this.dialogActor;
            if (this.actor instanceof NamedObj) {
                if (!this.addedListener) {
                    boolean cfr_ignored_0 = this.part instanceof PasserelleModelMultiPageEditor;
                }
                Class clazz = null;
                clazz = this.actor instanceof TextAttribute ? StringAttribute.class : Parameter.class;
                for (Attribute attribute : this.actor.attributeList(clazz)) {
                    if (attribute instanceof Parameter && !PasserelleConfigurer.isVisible((NamedObj)this.actor, (Settable)((Parameter)attribute))) continue;
                    arrayList.add(attribute);
                }
            }
            this.createTableModel(arrayList);
            return true;
        }
        return false;
    }

    private void createTableModel(final List<Attribute> list) {
        if (list != null) {
            Collections.sort(list, new NamedObjComparator());
        }
        try {
            this.viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

                public void dispose() {
                }

                public void inputChanged(Viewer viewer, Object object, Object object2) {
                }

                public Object[] getElements(Object object) {
                    Director director;
                    if (list == null) {
                        return new Parameter[0];
                    }
                    ArrayList<GeneralAttribute> arrayList = new ArrayList<GeneralAttribute>(list.size() + 1);
                    Director director2 = director = ActorAttributesView.this.actor instanceof Actor ? (Director)((Actor)ActorAttributesView.this.actor).getDirector() : null;
                    if (ActorAttributesView.this.actor instanceof Actor) {
                        arrayList.add(new GeneralAttribute(GeneralAttribute.ATTRIBUTE_TYPE.TYPE, PaletteItemFactory.getInstance().getType(ActorAttributesView.this.actor.getClass())));
                    }
                    if (ActorAttributesView.this.actor instanceof Actor && director != null && director.isExpertMode()) {
                        arrayList.add(new GeneralAttribute(GeneralAttribute.ATTRIBUTE_TYPE.CLASS, ActorAttributesView.this.actor.getClass().getName()));
                    }
                    arrayList.add(new GeneralAttribute(GeneralAttribute.ATTRIBUTE_TYPE.NAME, PaletteItemFactory.getInstance().getType(ActorAttributesView.this.actor.getName())));
                    arrayList.addAll(list);
                    return arrayList.toArray(new Object[arrayList.size()]);
                }
            });
            this.viewer.setInput(new Object());
            this.viewer.refresh();
        }
        catch (Exception exception) {
            logger.error("Cannot set input", (Throwable)exception);
        }
    }

    public void clear() {
        this.actor = null;
        if (this.part != null && this.part instanceof PasserelleModelMultiPageEditor) {
            ((PasserelleModelMultiPageEditor)this.part).getEditor().getEditDomain().getCommandStack().removeCommandStackEventListener((CommandStackEventListener)this);
        }
        this.part = null;
        this.addedListener = false;
        this.createTableModel(null);
    }

    public void createPartControl(Composite composite) {
        this.viewer = new TableViewer(composite, 68356);
        this.viewer.getTable().setLinesVisible(true);
        this.viewer.getTable().setHeaderVisible(true);
        this.createColumns(this.viewer);
        this.viewer.setUseHashlookup(true);
        this.viewer.setColumnProperties(new String[]{"Property", "Value"});
        this.createActions();
        this.createPopupMenu();
        if (this.getSite() != null) {
            this.getSite().getWorkbenchWindow().getSelectionService().addSelectionListener((ISelectionListener)this);
        }
        this.viewer.getTable().addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent keyEvent) {
            }

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.keyCode == 0x100000A) {
                    try {
                        ActorAttributesView.this.showHelpSelectedParameter();
                    }
                    catch (IllegalActionException illegalActionException) {}
                }
                if (keyEvent.character == '\u007f') {
                    try {
                        ActorAttributesView.this.deleteSelectedParameter();
                    }
                    catch (IllegalActionException illegalActionException) {
                        logger.error("Cannot delete ", (Throwable)illegalActionException);
                    }
                }
            }
        });
        try {
            this.part = EclipseUtils.getActivePage().getActiveEditor();
            this.updateSelection(EclipseUtils.getActivePage().getSelection());
        }
        catch (Throwable throwable) {}
    }

    private void createColumns(TableViewer tableViewer) {
        TableViewerColumn tableViewerColumn = new TableViewerColumn(tableViewer, 16384, 0);
        tableViewerColumn.getColumn().setText("Property");
        tableViewerColumn.getColumn().setWidth(200);
        tableViewerColumn.setLabelProvider((CellLabelProvider)new PropertyLabelProvider());
        TableViewerColumn tableViewerColumn2 = new TableViewerColumn(tableViewer, 16384, 1);
        tableViewerColumn2.getColumn().setText("Value");
        tableViewerColumn2.getColumn().setWidth(700);
        tableViewerColumn2.setLabelProvider((CellLabelProvider)new VariableLabelProvider(this));
        this.valueColumnEditor = new VariableEditingSupport(this, (ColumnViewer)tableViewer);
        tableViewerColumn2.setEditingSupport((EditingSupport)this.valueColumnEditor);
    }

    public boolean canEditAttribute(Object object) {
        return this.valueColumnEditor.canEdit(object);
    }

    private void createActions() {
    }

    private void createPopupMenu() {
        MenuManager menuManager = new MenuManager();
        menuManager.add((IAction)new Action("Delete Attribute", Activator.getImageDescriptor("icons/delete_obj.gif")){

            public void run() {
                new DeleteAttributeHandler().run(null);
            }
        });
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IAction)new Action("Help", Activator.getImageDescriptor("icons/help.gif")){

            public void run() {
                try {
                    ActorAttributesView.this.showHelpSelectedParameter();
                }
                catch (IllegalActionException illegalActionException) {}
            }
        });
        menuManager.add((IAction)new Action("Help Contents", Activator.getImageDescriptor("icons/help.gif")){

            public void run() {
                WorkbenchHelpSystem.getInstance().displayHelp();
            }
        });
        this.viewer.getControl().setMenu(menuManager.createContextMenu(this.viewer.getControl()));
    }

    public void setFocus() {
        if (!this.viewer.getTable().isDisposed()) {
            this.viewer.getTable().setFocus();
        }
    }

    public void dispose() {
        this.getSite().getWorkbenchWindow().getSelectionService().removeSelectionListener((ISelectionListener)this);
        if (this.part != null && this.part instanceof PasserelleModelMultiPageEditor) {
            ((PasserelleModelMultiPageEditor)this.part).getEditor().getEditDomain().getCommandStack().removeCommandStackEventListener((CommandStackEventListener)this);
        }
        super.dispose();
    }

    public void stackChanged(CommandStackEvent commandStackEvent) {
        this.viewer.refresh();
    }

    public void refresh() {
        this.viewer.refresh();
    }

    public String getActorName() {
        return this.actor.getName();
    }

    public Class getActorClass() {
        if (this.actor == null) {
            return null;
        }
        return this.actor.getClass();
    }

    public void setActorName(GeneralAttribute generalAttribute, String string) {
        if (ModelUtils.isNameLegal((String)string)) {
            generalAttribute.setValue(string);
            PasserelleModelMultiPageEditor passerelleModelMultiPageEditor = (PasserelleModelMultiPageEditor)this.part;
            RenameCommand renameCommand = new RenameCommand((ColumnViewer)this.viewer, this.actor, generalAttribute);
            passerelleModelMultiPageEditor.getEditor().getEditDomain().getCommandStack().execute((Command)renameCommand);
            passerelleModelMultiPageEditor.refreshActions();
        } else {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Invalid Name", (String)("The name '" + string + "' is not allowed.\n\n" + "Names should not contain '.'"));
        }
    }

    public void deleteSelectedParameter() throws IllegalActionException {
        ISelection iSelection = this.viewer.getSelection();
        if (iSelection != null && iSelection instanceof StructuredSelection) {
            StructuredSelection structuredSelection = (StructuredSelection)iSelection;
            Object object = structuredSelection.getFirstElement();
            if (object instanceof String) {
                return;
            }
            if (object instanceof Attribute) {
                this.setAttributeValue(object, null);
            }
        }
    }

    public void showHelpSelectedParameter() throws IllegalActionException {
        StructuredSelection structuredSelection;
        Object object;
        String string;
        ISelection iSelection = this.viewer.getSelection();
        if (iSelection != null && iSelection instanceof StructuredSelection && (string = HelpUtils.getContextId(object = (structuredSelection = (StructuredSelection)iSelection).getFirstElement())) != null) {
            WorkbenchHelp.displayHelp((String)string);
        }
    }

    public void setAttributeValue(Object object, Object object2) throws IllegalActionException {
        PasserelleModelMultiPageEditor passerelleModelMultiPageEditor = (PasserelleModelMultiPageEditor)this.part;
        AttributeCommand attributeCommand = new AttributeCommand((ColumnViewer)this.viewer, object, object2);
        passerelleModelMultiPageEditor.getEditor().getEditDomain().getCommandStack().execute((Command)attributeCommand);
        passerelleModelMultiPageEditor.refreshActions();
        passerelleModelMultiPageEditor.getEditor().refresh();
    }
}

