/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.workbench.model.editor.ui.router;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.AbstractRouter;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.Ellipse;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.RoundedRectangle;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Ray;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;

public final class SCAManhattanConnectionRouter
extends AbstractRouter {
    private Map<Integer, Integer> rowsUsed = new HashMap<Integer, Integer>();
    private Map<Integer, Integer> colsUsed = new HashMap<Integer, Integer>();
    private Map<Connection, Object> constraints = new HashMap<Connection, Object>();
    private Map<Connection, ReservedInfo> reservedInfo = new HashMap<Connection, ReservedInfo>();
    private IFigure parent;
    private static Ray UP = new Ray(0, -1);
    private static Ray DOWN = new Ray(0, 1);
    private static Ray LEFT = new Ray(-1, 0);
    private static Ray RIGHT = new Ray(1, 0);

    public SCAManhattanConnectionRouter(IFigure iFigure) {
        this.parent = iFigure;
    }

    public void invalidate(Connection connection) {
        this.removeReservedLines(connection);
    }

    private int getColumnNear(Connection connection, int n, int n2, int n3) {
        int n4 = Math.min(n2, n3);
        int n5 = Math.max(n2, n3);
        if (n4 > n) {
            n5 = n4;
            n4 = n - (n4 - n);
        }
        if (n5 < n) {
            n4 = n5;
            n5 = n + (n - n5);
        }
        int n6 = 0;
        int n7 = -1;
        if (n % 6 != 0) {
            n -= n % 6;
        }
        while (n6 < n) {
            Integer n8 = new Integer(n + n6 * n7);
            if (!this.colsUsed.containsKey(n8)) {
                this.colsUsed.put(n8, n8);
                this.reserveColumn(connection, n8);
                return n8;
            }
            int n9 = n8;
            if (n9 <= n4) {
                return n9 + 6;
            }
            if (n9 >= n5) {
                return n9 - 6;
            }
            if (n7 == 1) {
                n7 = -1;
                continue;
            }
            n7 = 1;
            n6 += 6;
        }
        return n;
    }

    protected Ray getDirection(Rectangle rectangle, Point point) {
        int n = Math.abs(rectangle.x - point.x);
        Ray ray = LEFT;
        int n2 = Math.abs(rectangle.y - point.y);
        if (n2 <= n) {
            n = n2;
            ray = UP;
        }
        if ((n2 = Math.abs(rectangle.right() - point.x)) < n) {
            n = n2;
            ray = RIGHT;
        }
        return ray;
    }

    protected Ray getEndDirection(Connection connection) {
        Rectangle rectangle;
        ConnectionAnchor connectionAnchor = connection.getTargetAnchor();
        Point point = this.getEndPoint(connection);
        if (connectionAnchor.getOwner() == null) {
            rectangle = new Rectangle(point.x, point.y - 1, 2, 2);
        } else {
            rectangle = connection.getTargetAnchor().getOwner().getBounds().getCopy();
            connection.getTargetAnchor().getOwner().translateToAbsolute((Translatable)rectangle);
        }
        return this.getDirection(rectangle, point);
    }

    protected int getRowNear(Connection connection, int n, int n2, int n3) {
        int n4 = Math.min(n2, n3);
        int n5 = Math.max(n2, n3);
        if (n4 > n) {
            n5 = n4;
            n4 = n - (n4 - n);
        }
        if (n5 < n) {
            n4 = n5;
            n5 = n + (n - n5);
        }
        int n6 = 0;
        int n7 = -1;
        if (n % 6 != 0) {
            n -= n % 6;
        }
        while (n6 < n) {
            Integer n8 = new Integer(n + n6 * n7);
            if (!this.rowsUsed.containsKey(n8)) {
                this.rowsUsed.put(n8, n8);
                this.reserveRow(connection, n8);
                return n8;
            }
            int n9 = n8;
            if (n9 <= n4) {
                return n9 + 6;
            }
            if (n9 >= n5) {
                return n9 - 6;
            }
            if (n7 == 1) {
                n7 = -1;
                continue;
            }
            n7 = 1;
            n6 += 6;
        }
        return n;
    }

    protected Ray getStartDirection(Connection connection) {
        Rectangle rectangle;
        ConnectionAnchor connectionAnchor = connection.getSourceAnchor();
        Point point = this.getStartPoint(connection);
        if (connectionAnchor.getOwner() == null) {
            rectangle = new Rectangle(point.x - 1, point.y - 1, 2, 2);
        } else {
            rectangle = connection.getSourceAnchor().getOwner().getBounds().getCopy();
            connection.getSourceAnchor().getOwner().translateToAbsolute((Translatable)rectangle);
        }
        return this.getDirection(rectangle, point);
    }

    protected void processPositions(Ray ray, Ray ray2, List list, boolean bl, Connection connection) {
        this.removeReservedLines(connection);
        int[] nArray = new int[list.size() + 2];
        nArray[0] = bl ? ray.x : ray.y;
        int n = 0;
        while (n < list.size()) {
            nArray[n + 1] = (Integer)list.get(n);
            ++n;
        }
        nArray[++n] = bl == (list.size() % 2 == 1) ? ray2.x : ray2.y;
        PointList pointList = new PointList();
        pointList.addPoint(new Point(ray.x, ray.y));
        n = 2;
        while (n < nArray.length - 1) {
            Point point;
            int n2;
            int n3;
            boolean bl2;
            bl = !bl;
            int n4 = nArray[n - 1];
            int n5 = nArray[n];
            boolean bl3 = bl2 = n != nArray.length - 2;
            if (bl) {
                if (bl2) {
                    n3 = nArray[n - 2];
                    n2 = nArray[n + 2];
                    nArray[n] = n5 = this.getRowNear(connection, n5, n3, n2);
                }
                point = new Point(n4, n5);
            } else {
                if (bl2) {
                    n3 = nArray[n - 2];
                    n2 = nArray[n + 2];
                    nArray[n] = n5 = this.getColumnNear(connection, n5, n3, n2);
                }
                point = new Point(n5, n4);
            }
            pointList.addPoint(point);
            ++n;
        }
        pointList.addPoint(new Point(ray2.x, ray2.y));
        connection.setPoints(pointList);
    }

    public void remove(Connection connection) {
        this.removeReservedLines(connection);
    }

    protected void removeReservedLines(Connection connection) {
        ReservedInfo reservedInfo = this.reservedInfo.get(connection);
        if (reservedInfo == null) {
            return;
        }
        int n = 0;
        while (n < reservedInfo.reservedRows.size()) {
            this.rowsUsed.remove(reservedInfo.reservedRows.get(n));
            ++n;
        }
        n = 0;
        while (n < reservedInfo.reservedCols.size()) {
            this.colsUsed.remove(reservedInfo.reservedCols.get(n));
            ++n;
        }
        this.reservedInfo.remove(connection);
    }

    protected void reserveColumn(Connection connection, Integer n) {
        ReservedInfo reservedInfo = this.reservedInfo.get(connection);
        if (reservedInfo == null) {
            reservedInfo = new ReservedInfo();
            this.reservedInfo.put(connection, reservedInfo);
        }
        reservedInfo.reservedCols.add(n);
    }

    protected void reserveRow(Connection connection, Integer n) {
        ReservedInfo reservedInfo = this.reservedInfo.get(connection);
        if (reservedInfo == null) {
            reservedInfo = new ReservedInfo();
            this.reservedInfo.put(connection, reservedInfo);
        }
        reservedInfo.reservedRows.add(n);
    }

    public void route(Connection connection) {
        if (connection.getSourceAnchor() == null || connection.getTargetAnchor() == null) {
            return;
        }
        Point point = this.getStartPoint(connection);
        connection.translateToRelative((Translatable)point);
        Point point2 = this.getEndPoint(connection);
        connection.translateToRelative((Translatable)point2);
        Ray ray = new Ray(point);
        Ray ray2 = new Ray(point2);
        Ray ray3 = ray.getAveraged(ray2);
        Ray ray4 = new Ray(ray, ray2);
        Ray ray5 = this.getStartDirection(connection);
        Ray ray6 = this.getEndDirection(connection);
        ArrayList<Integer> arrayList = new ArrayList<Integer>(5);
        boolean bl = ray5.isHorizontal();
        if (bl) {
            arrayList.add(new Integer(ray.y));
        } else {
            arrayList.add(new Integer(ray.x));
        }
        boolean bl2 = bl = !bl;
        if (ray5.dotProduct(ray6) == 0) {
            if (ray5.dotProduct(ray4) < 0 || ray6.dotProduct(ray4) > 0) {
                int n = ray5.dotProduct(ray4) < 0 ? ray5.similarity(ray.getAdded(ray5.getScaled(10))) : (bl ? ray3.y : ray3.x);
                arrayList.add(new Integer(n));
                boolean bl3 = bl = !bl;
                n = ray6.dotProduct(ray4) > 0 ? ray6.similarity(ray2.getAdded(ray6.getScaled(10))) : (bl ? ray3.y : ray3.x);
                arrayList.add(new Integer(n));
                bl = !bl;
            }
        } else if (ray5.dotProduct(ray6) > 0) {
            int n = ray5.dotProduct(ray4) >= 0 ? ray5.similarity(ray.getAdded(ray5.getScaled(10))) : ray6.similarity(ray2.getAdded(ray6.getScaled(10)));
            arrayList.add(new Integer(n));
            bl = !bl;
        } else {
            Ray ray7;
            int n;
            int n2;
            if (ray5.dotProduct(ray4) < 0) {
                n2 = ray5.similarity(ray.getAdded(ray5.getScaled(10)));
                arrayList.add(new Integer(n2));
                boolean bl4 = bl = !bl;
            }
            if (this.isCycle(connection)) {
                n2 = bl ? connection.getSourceAnchor().getOwner().getBounds().getTop().y - 10 : connection.getSourceAnchor().getOwner().getBounds().getRight().x + 10;
            } else if (bl) {
                int n3 = ray3.y;
                n = ray6.similarity(ray2.getAdded(ray6.getScaled(10)));
                ray7 = new Ray(((Integer)arrayList.get(arrayList.size() - 1)).intValue(), n3);
                IFigure iFigure = this.findFirstFigureAtStraightLine(ray7, LEFT, Collections.EMPTY_LIST);
                while (iFigure != null && iFigure.getBounds().x + iFigure.getBounds().width > n) {
                    ray7.y = n3 = iFigure.getBounds().y + iFigure.getBounds().height + 5;
                    iFigure = this.findFirstFigureAtStraightLine(ray7, LEFT, Collections.EMPTY_LIST);
                }
                n2 = n3;
            } else {
                IFigure iFigure = this.findFirstFigureAtStraightLine(ray, RIGHT, this.getExcludingFigures(connection));
                if (iFigure == null) {
                    n2 = ray3.x;
                } else {
                    n2 = Math.min(ray3.x, ray.getAdded((Ray)new Ray((int)(3 * (iFigure.getBounds().x - ray.x) / 4), (int)0)).x);
                    n2 = Math.max(ray.x, n2);
                }
                n2 = this.adjust(connection, n2);
            }
            arrayList.add(new Integer(n2));
            boolean bl5 = bl = !bl;
            if (ray5.dotProduct(ray4) < 0) {
                n2 = ray6.similarity(ray2.getAdded(ray6.getScaled(10)));
                arrayList.add(new Integer(n2));
                bl = !bl;
            } else {
                boolean bl6 = false;
                n = ray2.y;
                ray7 = this.findFirstFigureAtStraightLine(new Ray(n2, n), RIGHT, this.getExcludingFigures(connection));
                while (ray7 != null && ray7.getBounds().x < ray2.x) {
                    bl6 = true;
                    n = ray4.dotProduct(DOWN) > 0 ? ray7.getBounds().y - 5 : ray7.getBounds().y + ray7.getBounds().height + 5;
                    ray7 = this.findFirstFigureAtStraightLine(new Ray(n2, n), RIGHT, this.getExcludingFigures(connection));
                }
                if (bl6) {
                    n2 = n;
                    arrayList.add(new Integer(n2));
                    bl = !bl;
                    n2 = ray6.similarity(ray2.getAdded(ray6.getScaled(10)));
                    arrayList.add(new Integer(n2));
                    boolean bl7 = bl = !bl;
                }
            }
        }
        if (bl) {
            arrayList.add(new Integer(ray2.y));
        } else {
            arrayList.add(new Integer(ray2.x));
        }
        this.processPositions(ray, ray2, arrayList, ray5.isHorizontal(), connection);
    }

    public Object getConstraint(Connection connection) {
        return this.constraints.get(connection);
    }

    public void setConstraint(Connection connection, Object object) {
        this.constraints.put(connection, object);
    }

    protected boolean isCycle(Connection connection) {
        IFigure iFigure = connection.getSourceAnchor().getOwner();
        IFigure iFigure2 = connection.getTargetAnchor().getOwner();
        return iFigure != null && iFigure.equals(iFigure2);
    }

    protected List getExcludingFigures(Connection connection) {
        ArrayList<IFigure> arrayList = new ArrayList<IFigure>();
        arrayList.add(connection.getSourceAnchor().getOwner());
        arrayList.add(connection.getTargetAnchor().getOwner());
        return arrayList;
    }

    protected IFigure findFirstFigureAtStraightLine(Ray ray, Ray ray2, List list) {
        IFigure iFigure = null;
        Collection<IFigure> collection = this.getNodeFigures();
        for (IFigure iFigure2 : collection) {
            if (list.contains(iFigure2)) continue;
            Rectangle rectangle = iFigure2.getBounds();
            if (LEFT.equals((Object)ray2)) {
                if (ray.x <= rectangle.x || ray.y < rectangle.y || ray.y > rectangle.y + rectangle.height || iFigure != null && iFigure2.getBounds().x <= iFigure.getBounds().x) continue;
                iFigure = iFigure2;
                continue;
            }
            if (RIGHT.equals((Object)ray2)) {
                if (ray.x >= rectangle.x + rectangle.width || ray.y < rectangle.y || ray.y > rectangle.y + rectangle.height || iFigure != null && iFigure2.getBounds().x >= iFigure.getBounds().x) continue;
                iFigure = iFigure2;
                continue;
            }
            if (UP.equals((Object)ray2)) {
                if (ray.y <= rectangle.y || ray.x < rectangle.x || ray.x > rectangle.x + rectangle.width || iFigure != null && iFigure2.getBounds().y <= iFigure.getBounds().y) continue;
                iFigure = iFigure2;
                continue;
            }
            if (!DOWN.equals((Object)ray2) || ray.y >= rectangle.y + rectangle.height || ray.x < rectangle.x || ray.x > rectangle.x + rectangle.width || iFigure != null && iFigure2.getBounds().y >= iFigure.getBounds().y) continue;
            iFigure = iFigure2;
        }
        return iFigure;
    }

    protected int adjust(Connection connection, int n) {
        int n2 = n;
        Point point = connection.getSourceAnchor().getLocation(null);
        Collection<Connection> collection = this.getConnectionFigures();
        for (Connection connection2 : collection) {
            if (connection2.equals(connection)) continue;
            Point point2 = connection2.getTargetAnchor().getLocation(null);
            if (point.x >= point2.x || point.y != point2.y || connection2.getPoints().getMidpoint().x > n) continue;
            n2 = connection2.getPoints().getMidpoint().x - 5;
        }
        return n2;
    }

    private Collection<IFigure> getNodeFigures() {
        HashSet<IFigure> hashSet = new HashSet<IFigure>(31);
        this.getNodeFigures(hashSet, this.parent);
        return hashSet;
    }

    private void getNodeFigures(Collection<IFigure> collection, IFigure iFigure) {
        List list;
        if (iFigure instanceof RoundedRectangle) {
            collection.add(iFigure);
        }
        if (iFigure instanceof Ellipse) {
            collection.add(iFigure);
        }
        if (iFigure instanceof RectangleFigure) {
            collection.add(iFigure);
        }
        if ((list = iFigure.getChildren()) != null) {
            for (Object e : list) {
                if (!(e instanceof IFigure)) continue;
                this.getNodeFigures(collection, (IFigure)e);
            }
        }
    }

    private Collection<Connection> getConnectionFigures() {
        HashSet<Connection> hashSet = new HashSet<Connection>(31);
        this.getConnectionFigures(hashSet, this.parent);
        return hashSet;
    }

    private void getConnectionFigures(Collection<Connection> collection, IFigure iFigure) {
        List list;
        if (iFigure instanceof Connection) {
            collection.add((Connection)iFigure);
        }
        if ((list = iFigure.getChildren()) != null) {
            for (Object e : list) {
                if (!(e instanceof IFigure)) continue;
                this.getConnectionFigures(collection, (IFigure)e);
            }
        }
    }

    private class ReservedInfo {
        public List<Integer> reservedRows = new ArrayList<Integer>(2);
        public List<Integer> reservedCols = new ArrayList<Integer>(2);

        private ReservedInfo() {
        }
    }
}

