/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.workbench.model.editor.ui.palette;

import com.isencia.passerelle.workbench.model.editor.ui.palette.PaletteBuilder;
import com.isencia.passerelle.workbench.model.editor.ui.palette.PaletteItemFactory;
import java.util.Arrays;
import java.util.List;
import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.ui.palette.customize.DefaultEntryPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PasserelleEntryPage
extends DefaultEntryPage {
    private static Logger logger = LoggerFactory.getLogger(PasserelleEntryPage.class);

    public void createControl(Composite composite, PaletteEntry paletteEntry) {
        super.createControl(composite, paletteEntry);
        Composite composite2 = (Composite)this.getControl();
        Control[] controlArray = new Control[1];
        this.createLabel(composite2, 0, "Group");
        try {
            controlArray[0] = this.createGroupText(composite2, paletteEntry);
        }
        catch (Exception exception) {
            logger.error("Cannot create group text", (Throwable)exception);
        }
        composite2.setTabList(controlArray);
    }

    protected Combo createGroupText(Composite composite, PaletteEntry paletteEntry) throws Exception {
        paletteEntry.getParent();
        Combo combo = new Combo(composite, 4);
        String[] stringArray = PaletteItemFactory.getInstance().getFavoriteGroupNames();
        combo.setItems(stringArray);
        String string = this.getEntry().getParent().getLabel();
        List<String> list = Arrays.asList(stringArray);
        String string2 = paletteEntry.getParent().getLabel();
        if (list.contains(string2)) {
            combo.select(list.indexOf(string));
        }
        combo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                PasserelleEntryPage.this.handleGroupChanged(((Combo)modifyEvent.getSource()).getText());
            }
        });
        return combo;
    }

    protected void handleGroupChanged(String string) {
        PaletteEntry paletteEntry = PaletteBuilder.getFavoriteGroup(string);
        if (paletteEntry instanceof PaletteContainer) {
            PaletteContainer paletteContainer = (PaletteContainer)paletteEntry;
            this.getEntry().setParent(paletteContainer);
            paletteContainer.add(this.getEntry());
        }
    }
}

