/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.workbench.model.editor.ui.palette;

import com.isencia.passerelle.model.Flow;
import com.isencia.passerelle.workbench.model.editor.ui.Activator;
import com.isencia.passerelle.workbench.model.editor.ui.palette.ClassTypeFactory;
import com.isencia.passerelle.workbench.model.editor.ui.palette.PaletteGroup;
import com.isencia.passerelle.workbench.model.editor.ui.palette.PaletteItemDefinition;
import com.isencia.passerelle.workbench.model.editor.ui.palette.SubModelPaletteItemDefinition;
import com.isencia.passerelle.workbench.model.utils.ModelUtils;
import com.isencia.passerelle.workbench.model.utils.SubModelUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.gef.palette.CombinedTemplateCreationEntry;
import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Color;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.actor.Director;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.Locatable;
import ptolemy.kernel.util.Location;
import ptolemy.kernel.util.NamedObj;

public class PaletteItemFactory
implements Serializable {
    private static Logger logger = LoggerFactory.getLogger(PaletteItemFactory.class);
    private static final long serialVersionUID = -4073857678663326334L;
    public static final String FAVORITE_GROUPS = "FavoriteGroups";
    public static final String DEFAULT_FAVORITES_NAME = "Favorites";
    private CreationFactory selectedItem;
    private List<PaletteGroup> paletteGroups;
    private static PaletteItemFactory factory;
    private static Map<String, String> actorBundleMap;
    private Map<String, PaletteGroup> groups;
    private Map<String, PaletteItemDefinition> paletteItemMap;
    public static final String COMPOSITE_ID = "com.isencia.passerelle.workbench.model.editor.ui.palette.composites";
    public static final String COMPOSITE_LABEL = "Composites";
    private PaletteGroup composites;

    static {
        actorBundleMap = new HashMap<String, String>();
    }

    public CreationFactory getSelectedItem() {
        return this.selectedItem;
    }

    public void setSelectedItem(CreationFactory creationFactory) {
        this.selectedItem = creationFactory;
    }

    public String[] getFavoriteGroupNames() throws Exception {
        String string = ModelUtils.getFavouritesStore().getString(FAVORITE_GROUPS);
        if (string == null || string.isEmpty()) {
            return new String[]{DEFAULT_FAVORITES_NAME};
        }
        return string.split(",");
    }

    public static String getBuildId(String string) {
        return actorBundleMap.get(string);
    }

    public void addPaletteGroup(String string) {
        PaletteGroup paletteGroup = new PaletteGroup(string, string);
        this.paletteGroups.add(paletteGroup);
        this.groups.put(string, paletteGroup);
    }

    public List<PaletteGroup> getPaletteGroups() {
        return this.paletteGroups;
    }

    public Collection<PaletteGroup> getAllPaletteGroups() {
        return this.groups.values();
    }

    public String[] getFavorites() throws Exception {
        PreferenceStore preferenceStore = ModelUtils.getFavouritesStore();
        if (preferenceStore == null) {
            return new String[0];
        }
        return preferenceStore.preferenceNames();
    }

    public static PaletteItemFactory getInstance() {
        if (factory == null) {
            try {
                factory = new PaletteItemFactory();
            }
            catch (Exception exception) {
                logger.error("Cannot create the palette loader factory!", (Throwable)exception);
            }
        }
        return factory;
    }

    private PaletteItemFactory() throws Exception {
        this.init();
    }

    private PaletteItemDefinition getPaletteItem(String string) {
        return this.paletteItemMap.get(string);
    }

    public PaletteGroup getPaletteGroup(String string) {
        return this.groups.get(string);
    }

    public Collection<PaletteItemDefinition> getAllPaletteItems() {
        return this.paletteItemMap.values();
    }

    public PaletteItemDefinition getPaletteItem(String string, String string2) {
        Map.Entry<String, PaletteGroup> entry2;
        if (string == null) {
            for (Map.Entry<String, PaletteGroup> entry2 : this.groups.entrySet()) {
                PaletteGroup paletteGroup = (PaletteGroup)entry2.getValue();
                PaletteItemDefinition paletteItemDefinition = paletteGroup.getPaletteItem(string2);
                if (paletteItemDefinition == null) continue;
                return paletteItemDefinition;
            }
        }
        if ((entry2 = this.groups.get(string)) == null) {
            return null;
        }
        return ((PaletteGroup)((Object)entry2)).getPaletteItem(string2);
    }

    public ImageDescriptor getIcon(Class clazz) {
        if (clazz == null) {
            return null;
        }
        return this.getIcon(clazz.getName());
    }

    public ImageDescriptor getIcon(String string) {
        PaletteItemDefinition paletteItemDefinition = this.getPaletteItem(string);
        if (paletteItemDefinition != null) {
            return paletteItemDefinition.getIcon();
        }
        return Activator.getImageDescriptor("icons/folder.gif");
    }

    public CombinedTemplateCreationEntry createPaletteEntryFromPaletteDefinition(PaletteItemDefinition paletteItemDefinition) {
        if (paletteItemDefinition instanceof SubModelPaletteItemDefinition) {
            return new CombinedTemplateCreationEntry(paletteItemDefinition.getName(), paletteItemDefinition.getName(), (CreationFactory)new ClassTypeFactory(paletteItemDefinition.getClazz(), (SubModelPaletteItemDefinition)paletteItemDefinition), paletteItemDefinition.getIcon(), paletteItemDefinition.getIcon());
        }
        return new CombinedTemplateCreationEntry(paletteItemDefinition.getName(), paletteItemDefinition.getName(), (CreationFactory)new ClassTypeFactory(paletteItemDefinition.getClazz(), paletteItemDefinition.getName()), paletteItemDefinition.getIcon(), paletteItemDefinition.getIcon());
    }

    public boolean containsFavorite(PaletteContainer paletteContainer, Object object, Object object2) {
        List list = paletteContainer.getChildren();
        for (Object e : list) {
            CombinedTemplateCreationEntry combinedTemplateCreationEntry;
            ClassTypeFactory classTypeFactory;
            if (!(e instanceof CombinedTemplateCreationEntry) || (!((Class)(classTypeFactory = (ClassTypeFactory)(combinedTemplateCreationEntry = (CombinedTemplateCreationEntry)e).getTemplate()).getObjectType()).getName().equals(object) || !classTypeFactory.getNewObject().equals(object2)) && (!(classTypeFactory.getNewObject() instanceof SubModelPaletteItemDefinition) || !((SubModelPaletteItemDefinition)classTypeFactory.getNewObject()).getName().equals(object2))) continue;
            return true;
        }
        return false;
    }

    public void removeFavorite(String string) throws Exception {
        ModelUtils.getFavouritesStore().putValue(string, "");
    }

    public boolean addFavorite(String string, PaletteContainer paletteContainer) {
        PaletteItemDefinition paletteItemDefinition = PaletteItemFactory.getInstance().getPaletteItem(string);
        if (paletteItemDefinition != null && !this.containsFavorite(paletteContainer, string, paletteItemDefinition.getName())) {
            CombinedTemplateCreationEntry combinedTemplateCreationEntry = this.createPaletteEntryFromPaletteDefinition(paletteItemDefinition);
            paletteContainer.add((PaletteEntry)combinedTemplateCreationEntry);
            return true;
        }
        return false;
    }

    public Color getColor(Class clazz) {
        if (clazz == null) {
            return null;
        }
        return this.getColor(clazz.getName());
    }

    public Color getColor(String string) {
        PaletteItemDefinition paletteItemDefinition = this.getPaletteItem(string);
        if (paletteItemDefinition != null) {
            return paletteItemDefinition.getColor();
        }
        return null;
    }

    public String getType(Class clazz) {
        if (clazz.equals(Flow.class)) {
            return "Subflow";
        }
        return this.getType(clazz.getName());
    }

    public String getType(String string) {
        PaletteItemDefinition paletteItemDefinition;
        try {
            if (Director.class.isAssignableFrom(Class.forName(string))) {
                return "Director";
            }
        }
        catch (ClassNotFoundException classNotFoundException) {}
        if ((paletteItemDefinition = this.getPaletteItem(string)) != null) {
            return paletteItemDefinition.getName();
        }
        return string;
    }

    public PaletteGroup getComposites() {
        return this.composites;
    }

    private void init() throws Exception {
        String string;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        String string2;
        String string3;
        Object object52;
        int n;
        int n2;
        IConfigurationElement[] iConfigurationElementArray;
        this.paletteGroups = new ArrayList<PaletteGroup>();
        this.composites = new PaletteGroup(COMPOSITE_ID, COMPOSITE_LABEL);
        this.composites.setIcon(Activator.getImageDescriptor("icons/Composites.png"));
        this.paletteGroups.add(this.composites);
        this.groups = new HashMap<String, PaletteGroup>();
        this.paletteItemMap = new HashMap<String, PaletteItemDefinition>();
        ImageDescriptor imageDescriptor = null;
        IConfigurationElement[] iConfigurationElementArray2 = Platform.getExtensionRegistry().getConfigurationElementsFor("com.isencia.passerelle.engine.actorGroups");
        if (iConfigurationElementArray2 != null) {
            iConfigurationElementArray = iConfigurationElementArray2;
            n2 = iConfigurationElementArray2.length;
            n = 0;
            while (n < n2) {
                object52 = iConfigurationElementArray[n];
                string3 = object52.getAttribute("name");
                string2 = object52.getAttribute("id");
                object4 = object52.getAttribute("icon");
                object3 = object52.getAttribute("priority");
                object2 = object52.getAttribute("open");
                object = new PaletteGroup(string2, string3);
                if (object3 != null) {
                    ((PaletteGroup)object).setPriority(Integer.parseInt((String)object3));
                }
                if (object2 != null) {
                    ((PaletteGroup)object).setExpanded(new Boolean((String)object2));
                }
                string = object52.getDeclaringExtension().getContributor().getName();
                imageDescriptor = Activator.getImageDescriptor("icons/ide.gif");
                if (object4 != null && !((String)object4).isEmpty()) {
                    imageDescriptor = Activator.getImageDescriptor(string, (String)object4);
                }
                ((PaletteGroup)object).setIcon(imageDescriptor);
                this.groups.put(((PaletteGroup)object).getId(), (PaletteGroup)object);
                ++n;
            }
        }
        iConfigurationElementArray = iConfigurationElementArray2;
        n2 = iConfigurationElementArray2.length;
        n = 0;
        while (n < n2) {
            object52 = iConfigurationElementArray[n];
            string3 = object52.getAttribute("parent");
            string2 = object52.getAttribute("id");
            object4 = this.groups.get(string2);
            object3 = null;
            if (string3 != null) {
                object3 = this.groups.get(string3);
            }
            if (object3 != null) {
                ((PaletteGroup)object3).addPaletteGroup((PaletteGroup)object4);
                ((PaletteGroup)object4).setParent((PaletteGroup)object3);
            } else {
                this.paletteGroups.add((PaletteGroup)object4);
            }
            ++n;
        }
        Collections.sort(this.paletteGroups);
        for (Object object52 : SubModelUtils.getSubModels().keySet()) {
            Flow flow = (Flow)SubModelUtils.getSubModels().get(object52);
            this.addSubModel(flow);
        }
        iConfigurationElementArray2 = Platform.getExtensionRegistry().getConfigurationElementsFor("com.isencia.passerelle.engine.actors");
        if (iConfigurationElementArray2 != null) {
            iConfigurationElementArray = iConfigurationElementArray2;
            int n3 = iConfigurationElementArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                Class<?> clazz;
                object52 = iConfigurationElementArray[n4];
                string3 = object52.getAttribute("name");
                string2 = object52.getAttribute("color");
                object4 = object52.getAttribute("id");
                object3 = object52.getAttribute("group");
                object2 = this.groups.get(object3);
                object = object52.getAttribute("icon");
                string = object52.getDeclaringExtension().getContributor().getName();
                imageDescriptor = Activator.getImageDescriptor("icons/ide.gif");
                if (object != null && !((String)object).isEmpty()) {
                    imageDescriptor = Activator.getImageDescriptor(string, (String)object);
                }
                if ((clazz = PaletteItemFactory.loadClass(object52, string)) != null && object2 != null) {
                    actorBundleMap.put(clazz.getName(), string);
                    PaletteItemDefinition paletteItemDefinition = new PaletteItemDefinition(imageDescriptor, (PaletteGroup)object2, (String)object4, string3, string2, clazz);
                    this.paletteItemMap.put(paletteItemDefinition.getClazz().getName(), paletteItemDefinition);
                }
                ++n4;
            }
        }
    }

    public void addSubModel(Flow flow) throws Exception {
        if (!this.paletteItemMap.containsKey(flow.getName())) {
            SubModelPaletteItemDefinition subModelPaletteItemDefinition = new SubModelPaletteItemDefinition(flow, this.composites, flow.getName(), flow.getName());
            this.paletteItemMap.put(flow.getName(), subModelPaletteItemDefinition);
        } else {
            PaletteItemDefinition paletteItemDefinition = this.paletteItemMap.get(flow.getName());
            if (paletteItemDefinition instanceof SubModelPaletteItemDefinition) {
                ((SubModelPaletteItemDefinition)paletteItemDefinition).setFlow(flow);
            }
        }
    }

    public PaletteItemDefinition removeSubModel(String string) throws Exception {
        PaletteItemDefinition paletteItemDefinition = this.paletteItemMap.remove(string);
        PaletteGroup paletteGroup = paletteItemDefinition.getGroup();
        if (paletteGroup != null) {
            paletteGroup.removePaletteItem(paletteItemDefinition);
        }
        return paletteItemDefinition;
    }

    private static Class<?> loadClass(IConfigurationElement iConfigurationElement, String string) {
        try {
            return Class.forName(iConfigurationElement.getAttribute("class"));
        }
        catch (Exception exception) {
            Bundle bundle = Platform.getBundle((String)string);
            try {
                return bundle.loadClass(iConfigurationElement.getAttribute("class"));
            }
            catch (Exception exception2) {
                Bundle bundle2 = Platform.getBundle((String)"com.isencia.passerelle.actor");
                try {
                    return bundle2.loadClass(iConfigurationElement.getAttribute("class"));
                }
                catch (Exception exception3) {
                    logger.error("Cannot load " + iConfigurationElement.getAttribute("class"), (Throwable)exception3);
                    return null;
                }
            }
        }
    }

    public static void setLocation(NamedObj namedObj, double[] dArray) {
        List list;
        if (namedObj instanceof Locatable) {
            try {
                ((Locatable)namedObj).setLocation(dArray);
                list = namedObj.getContainer();
                list.attributeChanged((Attribute)namedObj);
            }
            catch (IllegalActionException illegalActionException) {
                logger.error("Cannot set location of " + namedObj.getDisplayName(), (Throwable)illegalActionException);
            }
        }
        if ((list = namedObj.attributeList(Locatable.class)) == null) {
            return;
        }
        if (list.size() > 0) {
            Locatable locatable = (Locatable)list.get(0);
            try {
                locatable.setLocation(dArray);
                namedObj.attributeChanged((Attribute)list.get(0));
            }
            catch (IllegalActionException illegalActionException) {
                logger.error("Cannot set location of " + namedObj.getDisplayName(), (Throwable)illegalActionException);
            }
        } else {
            try {
                new Location(namedObj, "_location").setLocation(dArray);
            }
            catch (Exception exception) {
                logger.error("Cannot set location of " + namedObj.getDisplayName(), (Throwable)exception);
            }
        }
    }
}

