/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.workbench.model.editor.ui.palette;

import com.isencia.passerelle.workbench.model.editor.ui.Activator;
import com.isencia.passerelle.workbench.model.editor.ui.WorkbenchUtility;
import com.isencia.passerelle.workbench.model.editor.ui.palette.ClassTypeFactory;
import com.isencia.passerelle.workbench.model.editor.ui.palette.PaletteGroup;
import com.isencia.passerelle.workbench.model.editor.ui.palette.PaletteItemDefinition;
import com.isencia.passerelle.workbench.model.editor.ui.palette.PaletteItemFactory;
import com.isencia.passerelle.workbench.model.editor.ui.palette.SubModelPaletteItemDefinition;
import com.isencia.passerelle.workbench.model.utils.ModelUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.gef.palette.CombinedTemplateCreationEntry;
import org.eclipse.gef.palette.ConnectionCreationToolEntry;
import org.eclipse.gef.palette.MarqueeToolEntry;
import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.PaletteStack;
import org.eclipse.gef.palette.PanningSelectionToolEntry;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gef.tools.MarqueeSelectionTool;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.part.EditorPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaletteBuilder {
    private static final String ACTORGROUP_UTILITIES = "com.isencia.passerelle.actor.actorgroup.utilities";
    private static Logger logger = LoggerFactory.getLogger(PaletteBuilder.class);
    private static PaletteRoot paletteRoot;
    public static HashMap<String, PaletteEntry> favoritesContainers;

    static {
        favoritesContainers = new HashMap();
    }

    public static PaletteRoot createPalette(EditorPart editorPart) throws Exception {
        if (paletteRoot == null) {
            paletteRoot = new PaletteRoot();
            PaletteItemFactory.getInstance().getAllPaletteGroups();
            paletteRoot.addAll(PaletteBuilder.createCategories(paletteRoot, editorPart, PaletteItemFactory.getInstance().getPaletteGroup(ACTORGROUP_UTILITIES)));
        }
        return paletteRoot;
    }

    private static List createCategories(PaletteRoot paletteRoot, EditorPart editorPart, PaletteGroup paletteGroup) throws Exception {
        String[] stringArray;
        ArrayList<PaletteContainer> arrayList = new ArrayList<PaletteContainer>();
        PaletteItemFactory paletteItemFactory = PaletteItemFactory.getInstance();
        arrayList.add(PaletteBuilder.createControlGroup(paletteRoot));
        PaletteContainer paletteContainer = PaletteBuilder.createPaletteContainer(paletteGroup.getName(), paletteGroup.getIcon(), true);
        for (PaletteItemDefinition stringArray2 : paletteGroup.getPaletteItems()) {
            CombinedTemplateCreationEntry n2 = paletteItemFactory.createPaletteEntryFromPaletteDefinition(stringArray2);
            paletteContainer.add((PaletteEntry)n2);
        }
        arrayList.add(paletteContainer);
        String[] stringArray2 = stringArray = paletteItemFactory.getFavoriteGroupNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray2[n2];
            PaletteContainer paletteContainer2 = PaletteBuilder.createFavoriteContainer(string);
            paletteContainer2.setDescription("Click and drag favourite actors from the 'Palette' view.");
            favoritesContainers.put(string, (PaletteEntry)paletteContainer2);
            arrayList.add(paletteContainer2);
            String string2 = ModelUtils.getFavouritesStore().getString(string);
            if (string2 != null && !string2.isEmpty()) {
                String[] stringArray3;
                String[] stringArray4 = stringArray3 = string2.split(",");
                int n3 = stringArray3.length;
                int n4 = 0;
                while (n4 < n3) {
                    String string3 = stringArray4[n4];
                    paletteItemFactory.addFavorite(string3, paletteContainer2);
                    ++n4;
                }
            }
            ++n2;
        }
        return arrayList;
    }

    private static boolean isClass(String string) {
        try {
            Class.forName(string);
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public static PaletteContainer createFavoriteContainer(String string) {
        PaletteContainer paletteContainer = PaletteBuilder.createPaletteContainer(string, Activator.getImageDescriptor("icons/favourites.gif"), true);
        return paletteContainer;
    }

    public static void synchFavorites(PaletteViewer paletteViewer) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        List list = paletteRoot.getChildren();
        for (Object e : list) {
            if (!(e instanceof PaletteDrawer)) continue;
            PaletteDrawer paletteDrawer = (PaletteDrawer)e;
            PaletteGroup paletteGroup = PaletteItemFactory.getInstance().getPaletteGroup(ACTORGROUP_UTILITIES);
            if (paletteGroup == null || paletteDrawer.getLabel().equals(paletteGroup.getName())) continue;
            stringBuffer.append(paletteDrawer.getLabel());
            stringBuffer.append(",");
            StringBuffer stringBuffer2 = new StringBuffer();
            for (Object e2 : paletteDrawer.getChildren()) {
                if (!(e2 instanceof CombinedTemplateCreationEntry)) continue;
                CombinedTemplateCreationEntry combinedTemplateCreationEntry = (CombinedTemplateCreationEntry)e2;
                ClassTypeFactory classTypeFactory = (ClassTypeFactory)combinedTemplateCreationEntry.getTemplate();
                Object object = classTypeFactory.getObjectType();
                if (classTypeFactory.getNewObject() instanceof SubModelPaletteItemDefinition) {
                    stringBuffer2.append(((SubModelPaletteItemDefinition)classTypeFactory.getNewObject()).getName());
                    stringBuffer2.append(",");
                    continue;
                }
                stringBuffer2.append(((Class)object).getName());
                stringBuffer2.append(",");
            }
            PaletteBuilder.addFavoriteGroup(paletteDrawer.getLabel(), (PaletteEntry)paletteDrawer);
            ModelUtils.getFavouritesStore().putValue(paletteDrawer.getLabel(), stringBuffer2.toString());
        }
        ModelUtils.getFavouritesStore().putValue("FavoriteGroups", stringBuffer.toString());
        WorkbenchUtility.addMouseListenerToPaletteViewer(paletteViewer);
        try {
            ModelUtils.getFavouritesStore().save();
        }
        catch (IOException iOException) {}
    }

    public static PaletteContainer getDefaultFavoriteGroup() {
        PaletteEntry paletteEntry = favoritesContainers.get("Favorites");
        if (paletteEntry instanceof PaletteContainer) {
            return (PaletteContainer)paletteEntry;
        }
        return PaletteBuilder.createFavoriteContainer("Favorites");
    }

    public static PaletteEntry getFavoriteGroup(String string) {
        return favoritesContainers.get(string);
    }

    public static void addFavoriteGroup(String string, PaletteEntry paletteEntry) {
        favoritesContainers.put(string, paletteEntry);
    }

    private static PaletteContainer createControlGroup(PaletteRoot paletteRoot) {
        org.eclipse.gef.palette.PaletteGroup paletteGroup = new org.eclipse.gef.palette.PaletteGroup("ControlGroup");
        ArrayList<Object> arrayList = new ArrayList<Object>();
        PanningSelectionToolEntry panningSelectionToolEntry = new PanningSelectionToolEntry();
        arrayList.add(panningSelectionToolEntry);
        paletteRoot.setDefaultEntry((ToolEntry)panningSelectionToolEntry);
        PaletteStack paletteStack = new PaletteStack("Stack", "", null);
        paletteStack.add((PaletteEntry)new MarqueeToolEntry());
        MarqueeToolEntry marqueeToolEntry = new MarqueeToolEntry();
        marqueeToolEntry.setToolProperty(MarqueeSelectionTool.PROPERTY_MARQUEE_BEHAVIOR, (Object)new Integer(MarqueeSelectionTool.BEHAVIOR_CONNECTIONS_TOUCHED));
        paletteStack.add((PaletteEntry)marqueeToolEntry);
        marqueeToolEntry = new MarqueeToolEntry();
        marqueeToolEntry.setToolProperty(MarqueeSelectionTool.PROPERTY_MARQUEE_BEHAVIOR, (Object)new Integer(MarqueeSelectionTool.BEHAVIOR_CONNECTIONS_TOUCHED | MarqueeSelectionTool.BEHAVIOR_NODES_CONTAINED));
        paletteStack.add((PaletteEntry)marqueeToolEntry);
        paletteStack.setUserModificationPermission(1);
        arrayList.add(paletteStack);
        ConnectionCreationToolEntry connectionCreationToolEntry = new ConnectionCreationToolEntry("Connection", "Connection", null, Activator.getImageDescriptor("icons/connection16.gif"), Activator.getImageDescriptor("icons/connection24.gif"));
        arrayList.add(connectionCreationToolEntry);
        paletteGroup.addAll(arrayList);
        return paletteGroup;
    }

    private static PaletteContainer createPaletteContainer(String string, ImageDescriptor imageDescriptor, boolean bl) {
        PaletteDrawer paletteDrawer = new PaletteDrawer(string, imageDescriptor);
        if (bl) {
            paletteDrawer.setInitialState(0);
        } else {
            paletteDrawer.setInitialState(1);
        }
        return paletteDrawer;
    }
}

