/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.workbench.model.editor.ui.figure;

import com.isencia.passerelle.workbench.model.editor.ui.figure.AbstractNodeFigure;
import com.isencia.passerelle.workbench.model.editor.ui.figure.FixedConnectionAnchor;
import com.isencia.passerelle.workbench.model.editor.ui.figure.PortFigure;
import com.isencia.passerelle.workbench.model.editor.ui.figure.VertexPortFigure;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.eclipse.draw2d.AbstractBorder;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.swt.graphics.Image;

public class VertexFigure
extends AbstractNodeFigure {
    public static final String VERTEX_OUTPUT = "vertexOutput";
    public static final String VERTEX_INPUT = "vertexInput";
    private InputPorts inputPorts = null;
    private OutputPorts outputPorts = null;
    public static final int ANCHOR_WIDTH = 9;
    public static final int ANCHOR_HEIGHT = 16;
    private List<ConnectionAnchor> inputAnchors = new ArrayList<ConnectionAnchor>();
    private List<ConnectionAnchor> outputAnchors = new ArrayList<ConnectionAnchor>();

    @Override
    protected int getAnchorWidth() {
        return 9;
    }

    @Override
    protected int getAnchorHeight() {
        return 16;
    }

    public List<ConnectionAnchor> getOutputAnchors() {
        return this.outputAnchors;
    }

    public List<ConnectionAnchor> getInputAnchors() {
        return this.inputAnchors;
    }

    public ConnectionAnchor getInputAnchor(double[] dArray, double[] dArray2) {
        int n = 0;
        double d = 0.0;
        for (ConnectionAnchor connectionAnchor : this.inputAnchors) {
            double d2 = dArray2[0] + (double)connectionAnchor.getReferencePoint().x;
            double d3 = dArray2[1] + (double)connectionAnchor.getReferencePoint().y;
            double d4 = Math.pow(d2 - dArray[0], 2.0) + Math.pow(d3 - dArray[1], 2.0);
            if (d != 0.0 && !(d4 < d)) continue;
            d = d4;
            n = this.inputAnchors.indexOf(connectionAnchor);
        }
        return this.inputAnchors.get(n);
    }

    public ConnectionAnchor getOutputAnchor(double[] dArray, double[] dArray2) {
        int n = 0;
        double d = 0.0;
        for (ConnectionAnchor connectionAnchor : this.outputAnchors) {
            double d2 = (double)connectionAnchor.getReferencePoint().x + dArray2[0];
            double d3 = (double)connectionAnchor.getReferencePoint().y + dArray2[1];
            double d4 = Math.pow(d2 - dArray[0], 2.0) + Math.pow(d3 - dArray[1], 2.0);
            if (d != 0.0 && !(d4 < d)) continue;
            d = d4;
            n = this.outputAnchors.indexOf(connectionAnchor);
        }
        return this.outputAnchors.get(n);
    }

    public VertexFigure(String string, Class clazz, Image image) {
        super(string, false, clazz);
        ToolbarLayout toolbarLayout = new ToolbarLayout();
        toolbarLayout.setVertical(false);
        this.setLayoutManager((LayoutManager)toolbarLayout);
        toolbarLayout.setSpacing(0);
        this.setOpaque(false);
        this.setBackgroundColor(ColorConstants.white);
        this.setForegroundColor(ColorConstants.white);
        this.inputPorts = new InputPorts();
        this.add((IFigure)this.inputPorts);
        this.outputPorts = new OutputPorts();
        this.add((IFigure)this.outputPorts);
        VertexPortFigure vertexPortFigure = new VertexPortFigure(VERTEX_INPUT, this.getAnchorWidth(), this.getAnchorHeight(), ColorConstants.black);
        vertexPortFigure.setToolTip((IFigure)new Label(VERTEX_INPUT));
        vertexPortFigure.setLocation(new Point(0, 0));
        this.addAnchor(this.getSourceConnectionAnchors(), this.inputAnchors, vertexPortFigure, 0, this.getAnchorHeight() / 2);
        this.addAnchor(this.getSourceConnectionAnchors(), this.inputAnchors, vertexPortFigure, this.getAnchorWidth(), 0);
        this.addAnchor(this.getSourceConnectionAnchors(), this.inputAnchors, vertexPortFigure, this.getAnchorWidth(), this.getAnchorHeight());
        this.addAnchor(this.getSourceConnectionAnchors(), this.inputAnchors, vertexPortFigure, 2 * this.getAnchorWidth(), this.getAnchorHeight() / 2);
        this.inputPorts.add((IFigure)vertexPortFigure);
        VertexPortFigure vertexPortFigure2 = new VertexPortFigure(VERTEX_OUTPUT, this.getAnchorWidth(), this.getAnchorHeight(), ColorConstants.black);
        vertexPortFigure.setToolTip((IFigure)new Label(VERTEX_OUTPUT));
        vertexPortFigure.setLocation(new Point(0, 0));
        this.addAnchor(this.getTargetConnectionAnchors(), this.outputAnchors, vertexPortFigure2, this.getAnchorWidth() - 1, this.getAnchorHeight() / 2);
        this.addAnchor(this.getTargetConnectionAnchors(), this.outputAnchors, vertexPortFigure2, 0, this.getAnchorHeight() - 1);
        this.addAnchor(this.getTargetConnectionAnchors(), this.outputAnchors, vertexPortFigure2, 0, 0);
        this.addAnchor(this.getTargetConnectionAnchors(), this.outputAnchors, vertexPortFigure2, -this.getAnchorWidth() + 1, this.getAnchorHeight() / 2);
        this.outputPorts.add((IFigure)vertexPortFigure2);
    }

    private FixedConnectionAnchor addAnchor(Vector<ConnectionAnchor> vector, List<ConnectionAnchor> list, PortFigure portFigure, int n, int n2) {
        FixedConnectionAnchor fixedConnectionAnchor = new FixedConnectionAnchor((IFigure)portFigure);
        fixedConnectionAnchor.offsetV = n2;
        fixedConnectionAnchor.offsetH = n;
        vector.add((ConnectionAnchor)fixedConnectionAnchor);
        list.add((ConnectionAnchor)fixedConnectionAnchor);
        return fixedConnectionAnchor;
    }

    private class InputPorts
    extends Ports {
    }

    private class OutputPorts
    extends Ports {
    }

    private class Ports
    extends Figure {
        public Ports() {
            ToolbarLayout toolbarLayout = new ToolbarLayout();
            toolbarLayout.setVertical(true);
            toolbarLayout.setSpacing(VertexFigure.this.getAnchorSpacing());
            this.setLayoutManager((LayoutManager)toolbarLayout);
            this.setOpaque(false);
            this.setBorder((Border)new PortsBorder());
        }
    }

    private class PortsBorder
    extends AbstractBorder {
        private PortsBorder() {
        }

        public Insets getInsets(IFigure iFigure) {
            return new Insets(VertexFigure.this.getAnchorWidth(), 0, 0, 0);
        }

        public void paint(IFigure iFigure, Graphics graphics, Insets insets) {
        }
    }
}

