/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.workbench.model.editor.ui.figure;

import com.isencia.passerelle.workbench.model.editor.ui.IBody;
import com.isencia.passerelle.workbench.model.editor.ui.figure.ActorFigure;
import org.eclipse.draw2d.BorderLayout;
import org.eclipse.draw2d.Clickable;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ImageFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.RoundedRectangle;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

public class RectangularActorFigure
extends ActorFigure {
    public RectangularActorFigure(String string, Class clazz, Image image, Clickable[] clickableArray) {
        super(string, clazz, image, clickableArray);
    }

    @Override
    protected IFigure generateBody(Image image, Clickable[] clickableArray) {
        Body body = new Body(this.getColor());
        body.initImage(image);
        Clickable[] clickableArray2 = clickableArray;
        int n = clickableArray.length;
        int n2 = 0;
        while (n2 < n) {
            Clickable clickable = clickableArray2[n2];
            body.initClickable(clickable);
            ++n2;
        }
        return body;
    }

    private class Body
    extends RoundedRectangle
    implements IBody {
        public Body(Color color) {
            BorderLayout borderLayout = new BorderLayout();
            this.setLayoutManager((LayoutManager)borderLayout);
            this.setBackgroundColor(RectangularActorFigure.this.getColor());
            this.setOpaque(true);
        }

        @Override
        public void initImage(Image image) {
            if (image != null) {
                ImageFigure imageFigure = new ImageFigure(image);
                imageFigure.setAlignment(2);
                this.add((IFigure)imageFigure, BorderLayout.CENTER);
            }
        }

        @Override
        public void initClickable(Clickable clickable) {
            if (clickable != null) {
                this.add((IFigure)clickable, BorderLayout.BOTTOM);
            }
        }

        protected void fillShape(Graphics graphics) {
            graphics.pushState();
            graphics.setForegroundColor(ColorConstants.white);
            graphics.setBackgroundColor(this.getBackgroundColor());
            Rectangle rectangle = this.getBounds();
            graphics.fillGradient(rectangle.x + 1, rectangle.y + 1, rectangle.width - 2, rectangle.height - 2, false);
            graphics.popState();
        }

        protected void outlineShape(Graphics graphics) {
            graphics.setForegroundColor(ColorConstants.gray);
            super.outlineShape(graphics);
        }

        public Dimension getPreferredSize(int n, int n2) {
            Dimension dimension = this.getParent().getSize().getCopy();
            return dimension;
        }
    }
}

