/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.workbench.model.editor.ui.figure;

import com.isencia.passerelle.workbench.model.editor.ui.figure.AbstractBaseFigure;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ImageFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.RoundedRectangle;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

public class DirectorFigure
extends AbstractBaseFigure {
    public static final int DIRECTOR_WIDTH = 120;
    public static final int DIRECTOR_HEIGHT = 60;
    public static final Dimension DIRECTOR_SIZE = new Dimension(120, 60);
    public static final Color DIRECTOR_BACKGROUND_COLOR = new Color(null, 204, 0, 0);
    private Body body = new Body();

    @Override
    public Color getDefaultColor() {
        return DIRECTOR_BACKGROUND_COLOR;
    }

    public DirectorFigure(String string, Class clazz, Image image) {
        super(string, clazz);
        this.body.initImage(image);
        this.add((IFigure)this.body);
        this.setBackgroundColor(DIRECTOR_BACKGROUND_COLOR);
    }

    public Dimension getPreferredSize(int n, int n2) {
        return DIRECTOR_SIZE;
    }

    public void validate() {
        LayoutManager layoutManager = this.getLayoutManager();
        layoutManager.setConstraint((IFigure)this.body, (Object)new Rectangle(0, 0, -1, -1));
        super.validate();
    }

    public void setBackgroundColor(Color color) {
        if (this.body != null) {
            this.body.setBackgroundColor(color);
        }
    }

    private class Body
    extends RoundedRectangle {
        ImageFigure imageFigure;

        public Body() {
            ToolbarLayout toolbarLayout = new ToolbarLayout();
            toolbarLayout.setVertical(true);
            this.setLayoutManager((LayoutManager)toolbarLayout);
            this.setOpaque(true);
        }

        private void initImage(Image image) {
            if (image != null) {
                this.imageFigure = new ImageFigure(image);
                this.imageFigure.setAlignment(8);
                this.imageFigure.setBorder((Border)new MarginBorder(5, 5, 10, 10));
                this.add((IFigure)this.imageFigure);
            }
        }

        public Dimension getPreferredSize(int n, int n2) {
            return this.getParent().getSize().getCopy();
        }

        protected void fillShape(Graphics graphics) {
            graphics.pushState();
            graphics.setForegroundColor(ColorConstants.white);
            graphics.setBackgroundColor(this.getBackgroundColor());
            Rectangle rectangle = this.getBounds();
            graphics.fillGradient(rectangle.x + 1, rectangle.y + 1, rectangle.width - 2, rectangle.height - 2, false);
            graphics.popState();
        }

        protected void outlineShape(Graphics graphics) {
            graphics.setForegroundColor(ColorConstants.gray);
            super.outlineShape(graphics);
        }
    }
}

