/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.workbench.model.editor.ui.figure;

import com.isencia.passerelle.workbench.model.editor.ui.figure.AbstractNodeFigure;
import com.isencia.passerelle.workbench.model.editor.ui.figure.ActorPortFigure;
import com.isencia.passerelle.workbench.model.editor.ui.figure.FixedConnectionAnchor;
import com.isencia.passerelle.workbench.model.editor.ui.figure.PortFigure;
import java.util.HashMap;
import java.util.Vector;
import org.eclipse.draw2d.AbstractBorder;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.BorderLayout;
import org.eclipse.draw2d.Clickable;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

public abstract class ActorFigure
extends AbstractNodeFigure {
    public static final Color ACTOR_BACKGROUND_COLOR = ColorConstants.lightGray;
    private IFigure body = null;
    private Ports inputPorts = null;
    private Ports outputPorts = null;
    private HashMap<String, PortFigure> inputPortMap = new HashMap();
    private HashMap<String, PortFigure> outputPortMap = new HashMap();

    public HashMap<String, PortFigure> getInputPortMap() {
        return this.inputPortMap;
    }

    public HashMap<String, PortFigure> getOutputPortMap() {
        return this.outputPortMap;
    }

    public ActorFigure(String string, Class clazz, Image image, Clickable[] clickableArray) {
        super(string, clazz);
        this.add((IFigure)new CompositeFigure(image, clickableArray));
    }

    protected abstract IFigure generateBody(Image var1, Clickable[] var2);

    public void setBackgroundColor(Color color) {
        if (this.body != null) {
            this.body.setBackgroundColor(color);
        }
    }

    public PortFigure addInput(String string, String string2) {
        ActorPortFigure actorPortFigure = new ActorPortFigure(string);
        actorPortFigure.setToolTip((IFigure)new Label(string2));
        int n = 0;
        int n2 = 0;
        actorPortFigure.setLocation(new Point(n, n2));
        if (this.inputPorts != null) {
            this.inputPorts.add((IFigure)actorPortFigure);
            this.inputPortMap.put(string, actorPortFigure);
        }
        FixedConnectionAnchor fixedConnectionAnchor = new FixedConnectionAnchor((IFigure)actorPortFigure);
        fixedConnectionAnchor.offsetV = this.getAnchorHeight() / 2;
        this.getTargetConnectionAnchors().add((ConnectionAnchor)fixedConnectionAnchor);
        this.connectionAnchors.put(string, fixedConnectionAnchor);
        return actorPortFigure;
    }

    public void removeInput(String string) {
        PortFigure portFigure = this.inputPortMap.get(string);
        if (portFigure != null) {
            this.inputPorts.remove((IFigure)portFigure);
            this.inputPortMap.remove(string);
            ConnectionAnchor connectionAnchor = this.getConnectionAnchor(string);
            if (connectionAnchor != null) {
                this.getTargetConnectionAnchors().remove(connectionAnchor);
            }
        }
    }

    public void removeOutput(String string) {
        PortFigure portFigure = this.outputPortMap.get(string);
        if (portFigure != null) {
            this.outputPorts.remove((IFigure)portFigure);
            this.outputPortMap.remove(string);
            ConnectionAnchor connectionAnchor = this.getConnectionAnchor(string);
            if (connectionAnchor != null) {
                this.getSourceConnectionAnchors().remove(connectionAnchor);
            }
        }
    }

    public PortFigure addOutput(String string, String string2) {
        ActorPortFigure actorPortFigure = new ActorPortFigure(string);
        actorPortFigure.setToolTip((IFigure)new Label(string2));
        if (this.outputPorts != null) {
            this.outputPorts.add((IFigure)actorPortFigure);
            this.outputPortMap.put(string, actorPortFigure);
        }
        FixedConnectionAnchor fixedConnectionAnchor = new FixedConnectionAnchor((IFigure)actorPortFigure);
        fixedConnectionAnchor.offsetV = this.getAnchorHeight() / 2;
        fixedConnectionAnchor.offsetH = this.getAnchorWidth() - 1;
        this.getSourceConnectionAnchors().add((ConnectionAnchor)fixedConnectionAnchor);
        this.connectionAnchors.put(string, fixedConnectionAnchor);
        return actorPortFigure;
    }

    public PortFigure getInputPort(String string) {
        return this.inputPortMap.get(string);
    }

    public PortFigure getOutputPort(String string) {
        return this.outputPortMap.get(string);
    }

    private class CompositeFigure
    extends Figure {
        public CompositeFigure(Image image, Clickable[] clickableArray) {
            BorderLayout borderLayout = new BorderLayout();
            this.setLayoutManager((LayoutManager)borderLayout);
            this.setOpaque(false);
            ActorFigure.this.inputPorts = new Ports();
            this.add((IFigure)ActorFigure.this.inputPorts, BorderLayout.LEFT);
            ActorFigure.this.body = ActorFigure.this.generateBody(image, clickableArray);
            if (ActorFigure.this.body != null) {
                this.add(ActorFigure.this.body, BorderLayout.CENTER);
            }
            ActorFigure.this.outputPorts = new Ports();
            this.add((IFigure)ActorFigure.this.outputPorts, BorderLayout.RIGHT);
        }

        public Dimension getMaximumSize() {
            return this.getPreferredSize(-1, -1);
        }

        public Dimension getPreferredSize(int n, int n2) {
            Vector<ConnectionAnchor> vector = ActorFigure.this.getTargetConnectionAnchors();
            Vector<ConnectionAnchor> vector2 = ActorFigure.this.getSourceConnectionAnchors();
            int n3 = Math.max(vector.size(), vector2.size());
            if (n3 > 0) {
                int n4 = n3 * ActorFigure.this.getAnchorHeight() + (n3 > 1 ? (n3 - 1) * ActorFigure.this.getAnchorSpacing() : 0) + 2 * ActorFigure.this.getAnchorMargin();
                if (n4 < ActorFigure.this.getMinHeight()) {
                    n4 = ActorFigure.this.getMinHeight();
                }
                return new Dimension(ActorFigure.this.getDefaultWidth(), n4);
            }
            return super.getMinimumSize();
        }
    }

    private class Ports
    extends Figure {
        public Ports() {
            ToolbarLayout toolbarLayout = new ToolbarLayout();
            toolbarLayout.setVertical(true);
            toolbarLayout.setSpacing(ActorFigure.this.getAnchorSpacing());
            this.setLayoutManager((LayoutManager)toolbarLayout);
            this.setOpaque(false);
            this.setBorder((Border)new PortsBorder());
        }
    }

    private class PortsBorder
    extends AbstractBorder {
        private PortsBorder() {
        }

        public Insets getInsets(IFigure iFigure) {
            return new Insets(ActorFigure.this.getAnchorMargin(), 0, 0, 0);
        }

        public void paint(IFigure iFigure, Graphics graphics, Insets insets) {
        }
    }
}

