/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.workbench.model.editor.ui.figure;

import com.isencia.passerelle.workbench.model.editor.ui.INameable;
import com.isencia.passerelle.workbench.model.editor.ui.palette.PaletteItemFactory;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.swt.graphics.Color;

public class AbstractBaseFigure
extends Figure
implements INameable {
    public static final int DEFAULT_WIDTH = 60;
    public static final int MIN_HEIGHT = 60;
    public static final Color DEFAULT_BACKGROUND_COLOR = ColorConstants.lightGray;
    public static final Color DEFAULT_FOREGROUND_COLOR = ColorConstants.gray;
    public static final Color LABEL_BACKGROUND_COLOR = new Color(null, 0, 0, 204);
    protected Class type;
    protected Label nameLabel = new Label();

    public Color getDefaultColor() {
        return DEFAULT_BACKGROUND_COLOR;
    }

    public Color getColor() {
        Color color = PaletteItemFactory.getInstance().getColor(this.type);
        if (color != null) {
            return color;
        }
        return this.getDefaultColor();
    }

    public AbstractBaseFigure(String string) {
        this(string, true, null);
    }

    public AbstractBaseFigure(String string, Class clazz) {
        this(string, true, clazz);
    }

    public AbstractBaseFigure(String string, boolean bl, Class clazz) {
        ToolbarLayout toolbarLayout = new ToolbarLayout();
        toolbarLayout.setVertical(true);
        toolbarLayout.setSpacing(2);
        this.setLayoutManager((LayoutManager)toolbarLayout);
        if (bl) {
            this.nameLabel.setText(this.getNotTooLongName(string));
            this.nameLabel.setOpaque(true);
            this.add((IFigure)this.nameLabel);
        }
        this.setToolTip((IFigure)new Label(string));
        this.type = clazz;
        if (clazz != null && PaletteItemFactory.getInstance().getType(clazz) != null) {
            this.setToolTip((IFigure)new Label(PaletteItemFactory.getInstance().getType(clazz)));
        }
        this.setOpaque(false);
    }

    private String getNotTooLongName(String string) {
        return string;
    }

    @Override
    public String getName() {
        return this.nameLabel.getText();
    }

    @Override
    public void setName(String string) {
        this.nameLabel.setText(string);
    }
}

