/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.workbench.model.editor.ui.editpolicy;

import com.isencia.passerelle.workbench.model.editor.ui.editor.PasserelleModelMultiPageEditor;
import com.isencia.passerelle.workbench.model.editor.ui.editpart.ActorEditPart;
import com.isencia.passerelle.workbench.model.editor.ui.editpart.IActorNodeEditPart;
import com.isencia.passerelle.workbench.model.editor.ui.editpart.RelationEditPart;
import com.isencia.passerelle.workbench.model.editor.ui.editpart.VertexEditPart;
import com.isencia.passerelle.workbench.model.editor.ui.editpart.VertexLinkEditPart;
import com.isencia.passerelle.workbench.model.ui.IPasserelleMultiPageEditor;
import com.isencia.passerelle.workbench.model.ui.VertexLink;
import com.isencia.passerelle.workbench.model.ui.command.CreateConnectionCommand;
import com.isencia.passerelle.workbench.model.ui.command.ReConnectCommand;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.GraphicalNodeEditPolicy;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.ReconnectRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.actor.Actor;
import ptolemy.actor.TypedIORelation;
import ptolemy.kernel.ComponentPort;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.Port;
import ptolemy.kernel.util.NamedObj;

public class ActorEditPolicy
extends GraphicalNodeEditPolicy {
    private Map<ReconnectRequest, ReConnectCommand> reconnectMap = new HashMap<ReconnectRequest, ReConnectCommand>();
    private static final Logger logger = LoggerFactory.getLogger(ActorEditPolicy.class);
    private CreateConnectionCommand CreateConnectionCommand;
    private PasserelleModelMultiPageEditor editor;
    private IActorNodeEditPart node;

    public PasserelleModelMultiPageEditor getEditor() {
        return this.editor;
    }

    private CreateConnectionCommand getCreateConnectionCommand() {
        if (this.CreateConnectionCommand == null) {
            this.CreateConnectionCommand = new CreateConnectionCommand((IPasserelleMultiPageEditor)this.editor);
            return this.CreateConnectionCommand;
        }
        return this.CreateConnectionCommand;
    }

    public ActorEditPolicy(PasserelleModelMultiPageEditor passerelleModelMultiPageEditor, IActorNodeEditPart iActorNodeEditPart) {
        this.editor = passerelleModelMultiPageEditor;
        this.node = iActorNodeEditPart;
    }

    public Logger getLogger() {
        return logger;
    }

    protected Command getConnectionCreateCommand(CreateConnectionRequest createConnectionRequest) {
        ConnectionAnchor connectionAnchor;
        IActorNodeEditPart iActorNodeEditPart = this.getActorEditPart();
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().trace("getConnectionCreateCommand for editPart : " + iActorNodeEditPart);
        }
        NamedObj namedObj = null;
        if (iActorNodeEditPart instanceof VertexEditPart) {
            namedObj = (NamedObj)iActorNodeEditPart.getModel();
        } else {
            connectionAnchor = iActorNodeEditPart.getSourceConnectionAnchor((Request)createConnectionRequest);
            namedObj = (ComponentPort)iActorNodeEditPart.getSourcePort(connectionAnchor);
        }
        if (namedObj != null) {
            connectionAnchor = this.getCreateConnectionCommand();
            connectionAnchor.setSource(namedObj);
            createConnectionRequest.setStartCommand((Command)connectionAnchor);
            return connectionAnchor;
        }
        return null;
    }

    protected Command getConnectionCompleteCommand(CreateConnectionRequest createConnectionRequest) {
        ConnectionAnchor connectionAnchor;
        IActorNodeEditPart iActorNodeEditPart = this.getActorEditPart();
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("getConnectionCompleteCommand for editPart : " + iActorNodeEditPart);
        }
        NamedObj namedObj = null;
        if (iActorNodeEditPart instanceof VertexEditPart) {
            namedObj = (NamedObj)iActorNodeEditPart.getModel();
        } else {
            connectionAnchor = iActorNodeEditPart.getTargetConnectionAnchor((Request)createConnectionRequest);
            namedObj = (ComponentPort)iActorNodeEditPart.getTargetPort(connectionAnchor);
        }
        if (namedObj != null) {
            connectionAnchor = (CreateConnectionCommand)createConnectionRequest.getStartCommand();
            connectionAnchor.setTarget(namedObj);
            return connectionAnchor;
        }
        return null;
    }

    protected Actor getActorModel() {
        return (Actor)this.getHost().getModel();
    }

    protected IActorNodeEditPart getActorEditPart() {
        return (IActorNodeEditPart)this.getHost();
    }

    protected Command getReconnectTargetCommand(ReconnectRequest reconnectRequest) {
        ReConnectCommand reConnectCommand = this.createReconnectCommand(reconnectRequest, true);
        EditPart editPart = reconnectRequest.getTarget();
        if (editPart instanceof ActorEditPart) {
            ActorEditPart actorEditPart = (ActorEditPart)editPart;
            ConnectionAnchor connectionAnchor = actorEditPart.getTargetConnectionAnchor((Request)reconnectRequest);
            Port port = actorEditPart.getTargetPort(connectionAnchor);
            if (!port.equals(reConnectCommand.getTarget())) {
                reConnectCommand.setNewTarget((NamedObj)port);
            }
        } else if (editPart instanceof VertexEditPart && !editPart.getModel().equals(reConnectCommand.getTarget())) {
            reConnectCommand.setNewTarget((NamedObj)editPart.getModel());
        }
        return reConnectCommand;
    }

    private ReConnectCommand createReconnectCommand(ReconnectRequest reconnectRequest, boolean bl) {
        ReConnectCommand reConnectCommand = this.reconnectMap.get(reconnectRequest);
        if (reConnectCommand == null) {
            reConnectCommand = new ReConnectCommand();
            reConnectCommand.setEditor((IPasserelleMultiPageEditor)this.editor);
            this.reconnectMap.put(reconnectRequest, reConnectCommand);
            ConnectionEditPart connectionEditPart = reconnectRequest.getConnectionEditPart();
            if (connectionEditPart instanceof RelationEditPart) {
                TypedIORelation typedIORelation = (TypedIORelation)connectionEditPart.getModel();
                reConnectCommand.setConnection(typedIORelation);
                reConnectCommand.setParent((CompositeEntity)this.getHost().getRoot().getContents().getModel());
                List list = typedIORelation.linkedDestinationPortList();
                reConnectCommand.setTarget((NamedObj)((Port)list.get(0)));
                list = typedIORelation.linkedSourcePortList();
                reConnectCommand.setSource((NamedObj)((Port)list.get(0)));
            } else if (connectionEditPart instanceof VertexLinkEditPart) {
                VertexLinkEditPart vertexLinkEditPart = (VertexLinkEditPart)connectionEditPart;
                reConnectCommand.setVertexLink((VertexLink)vertexLinkEditPart.getModel());
                reConnectCommand.setParent((CompositeEntity)this.getHost().getRoot().getContents().getModel());
            }
        }
        return reConnectCommand;
    }

    protected Command getReconnectSourceCommand(ReconnectRequest reconnectRequest) {
        ReConnectCommand reConnectCommand = this.createReconnectCommand(reconnectRequest, false);
        EditPart editPart = reconnectRequest.getTarget();
        if (editPart instanceof IActorNodeEditPart) {
            IActorNodeEditPart iActorNodeEditPart = (IActorNodeEditPart)editPart;
            ConnectionAnchor connectionAnchor = iActorNodeEditPart.getSourceConnectionAnchor((Request)reconnectRequest);
            Port port = iActorNodeEditPart.getSourcePort(connectionAnchor);
            if (!port.equals(reConnectCommand.getSource())) {
                reConnectCommand.setNewSource((NamedObj)port);
            }
        } else if (editPart instanceof VertexEditPart && !editPart.getModel().equals(reConnectCommand.getSource())) {
            reConnectCommand.setNewSource((NamedObj)editPart.getModel());
        }
        return reConnectCommand;
    }
}

