/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.workbench.model.editor.ui.editpart;

import com.isencia.passerelle.workbench.model.editor.ui.editpart.AbstractNodeEditPart;
import com.isencia.passerelle.workbench.model.editor.ui.editpart.DiagramEditPart;
import com.isencia.passerelle.workbench.model.editor.ui.editpart.IActorNodeEditPart;
import com.isencia.passerelle.workbench.model.editor.ui.editpolicy.ActorEditPolicy;
import com.isencia.passerelle.workbench.model.editor.ui.editpolicy.ComponentNodeDeletePolicy;
import com.isencia.passerelle.workbench.model.editor.ui.figure.VertexFigure;
import com.isencia.passerelle.workbench.model.ui.VertexLink;
import com.isencia.passerelle.workbench.model.utils.ModelUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.AccessibleAnchorProvider;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.requests.DropRequest;
import ptolemy.actor.IOPort;
import ptolemy.actor.TypedIORelation;
import ptolemy.kernel.Port;
import ptolemy.kernel.Relation;
import ptolemy.kernel.util.NamedObj;
import ptolemy.moml.Vertex;

public class VertexEditPart
extends AbstractNodeEditPart
implements IActorNodeEditPart {
    public static Map<Vertex, Map<NamedObj, VertexLink>> vertexRelationMap = new HashMap<Vertex, Map<NamedObj, VertexLink>>();
    public static Set<Vertex> vertexRelationSources = new HashSet<Vertex>();
    public static Set<Vertex> vertexRelationTargets = new HashSet<Vertex>();

    public static boolean isSource(Vertex vertex) {
        if (!vertexRelationSources.contains(vertex) && !vertexRelationTargets.contains(vertex)) {
            vertexRelationSources.add(vertex);
            return true;
        }
        return vertexRelationSources.contains(vertex);
    }

    public static boolean isTarget(Vertex vertex) {
        if (!vertexRelationSources.contains(vertex)) {
            vertexRelationTargets.add(vertex);
            return true;
        }
        return vertexRelationTargets.contains(vertex);
    }

    protected IFigure createFigure() {
        return new VertexFigure(((Vertex)this.getModel()).getName(), Vertex.class, null);
    }

    protected List getModelSourceConnections() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        TypedIORelation typedIORelation = (TypedIORelation)((Vertex)this.getModel()).getContainer();
        List list = typedIORelation.linkedObjectsList();
        for (Object e : typedIORelation.linkedDestinationPortList()) {
            if (!list.contains(e)) continue;
            arrayList.add(VertexEditPart.getRelation(typedIORelation, e, (Vertex)this.getModel(), true));
        }
        for (Object e : typedIORelation.linkedObjectsList()) {
            Object object;
            if (!(e instanceof TypedIORelation) || (object = VertexEditPart.getRelation(typedIORelation, ModelUtils.getVertex((Relation)((Relation)e)), (Vertex)this.getModel(), true)) == null) continue;
            arrayList.add(object);
        }
        return arrayList;
    }

    protected List getModelTargetConnections() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        TypedIORelation typedIORelation = (TypedIORelation)((Vertex)this.getModel()).getContainer();
        List list = typedIORelation.linkedObjectsList();
        for (Object e : typedIORelation.linkedSourcePortList()) {
            if (!list.contains(e)) continue;
            arrayList.add(VertexEditPart.getRelation(typedIORelation, e, (Vertex)this.getModel(), false));
        }
        for (Object e : typedIORelation.linkedObjectsList()) {
            Object object;
            if (!(e instanceof TypedIORelation) || (object = VertexEditPart.getRelation(typedIORelation, (Vertex)this.getModel(), ModelUtils.getVertex((Relation)((Relation)e)), false)) == null) continue;
            arrayList.add(object);
        }
        return arrayList;
    }

    public static Object getRelation(TypedIORelation typedIORelation, Object object, Vertex vertex, boolean bl) {
        VertexLink vertexLink = null;
        Map<NamedObj, VertexLink> map = vertexRelationMap.get(vertex);
        if (map == null) {
            map = new HashMap<NamedObj, VertexLink>();
            vertexRelationMap.put(vertex, map);
        }
        if (map.containsKey(object)) {
            vertexLink = map.get(object);
        } else {
            if (object instanceof IOPort) {
                vertexLink = new VertexLink((IOPort)object, vertex, bl);
            } else if (bl && VertexEditPart.isSource((Vertex)object) || !bl && VertexEditPart.isTarget(vertex)) {
                vertexLink = new VertexLink((Vertex)object, vertex, bl);
            }
            map.put((NamedObj)object, vertexLink);
        }
        return vertexLink;
    }

    public VertexFigure getVertexFigure() {
        return (VertexFigure)this.getFigure();
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connectionEditPart) {
        this.getLogger().debug("Get SourceConnectionAnchor based on ConnectionEditPart");
        return this.getVertexFigure().getInputAnchor(this.getLocation(connectionEditPart, true), ModelUtils.getLocation((NamedObj)((Vertex)this.getModel())));
    }

    private double[] getLocation(ConnectionEditPart connectionEditPart, boolean bl) {
        Object object = connectionEditPart.getModel();
        double[] dArray = new double[]{0.0, 0.0};
        if (object instanceof VertexLink) {
            VertexLink vertexLink = (VertexLink)object;
            if (vertexLink.getPort() != null) {
                dArray = ModelUtils.getLocation((NamedObj)((VertexLink)object).getPort().getContainer());
            } else if (!bl && vertexLink.getTargetVertex() != null) {
                dArray = ModelUtils.getLocation((NamedObj)((VertexLink)object).getTargetVertex());
            } else if (bl && vertexLink.getSourceVertex() != null) {
                dArray = ModelUtils.getLocation((NamedObj)((VertexLink)object).getSourceVertex());
            }
        }
        return dArray;
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connectionEditPart) {
        this.getLogger().debug("Get TargetConnectionAnchor based on ConnectionEditPart");
        return this.getVertexFigure().getOutputAnchor(this.getLocation(connectionEditPart, false), ModelUtils.getLocation((NamedObj)((Vertex)this.getModel())));
    }

    protected void createEditPolicies() {
        if (this.getParent() instanceof DiagramEditPart) {
            this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new ActorEditPolicy(((DiagramEditPart)this.getParent()).getMultiPageEditorPart(), this));
        }
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new ComponentNodeDeletePolicy());
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        Point point = new Point(((DropRequest)request).getLocation());
        return this.getVertexFigure().getSourceConnectionAnchorAt(point);
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        Point point = new Point(((DropRequest)request).getLocation());
        return this.getVertexFigure().getTargetConnectionAnchorAt(point);
    }

    @Override
    public Object getAdapter(Class clazz) {
        if (clazz == AccessibleAnchorProvider.class) {
            return new AbstractGraphicalEditPart.DefaultAccessibleAnchorProvider(this){

                public List<Point> getSourceAnchorLocations() {
                    ArrayList<Point> arrayList = new ArrayList<Point>();
                    List<ConnectionAnchor> list = VertexEditPart.this.getVertexFigure().getInputAnchors();
                    for (ConnectionAnchor connectionAnchor : list) {
                        arrayList.add(connectionAnchor.getReferencePoint().getTranslated(0, -3));
                    }
                    return arrayList;
                }

                public List<Point> getTargetAnchorLocations() {
                    ArrayList<Point> arrayList = new ArrayList<Point>();
                    List<ConnectionAnchor> list = VertexEditPart.this.getVertexFigure().getOutputAnchors();
                    for (ConnectionAnchor connectionAnchor : list) {
                        arrayList.add(connectionAnchor.getReferencePoint().getTranslated(0, 3));
                    }
                    return arrayList;
                }
            };
        }
        return super.getAdapter(clazz);
    }

    @Override
    public Port getSourcePort(ConnectionAnchor connectionAnchor) {
        return null;
    }

    @Override
    public Port getTargetPort(ConnectionAnchor connectionAnchor) {
        return null;
    }
}

