/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.workbench.model.editor.ui.editpart;

import com.isencia.passerelle.workbench.model.editor.ui.editor.PasserellRootEditPart;
import com.isencia.passerelle.workbench.model.editor.ui.editor.actions.RouterFactory;
import com.isencia.passerelle.workbench.model.editor.ui.editpolicy.RelationDeletePolicy;
import com.isencia.passerelle.workbench.model.editor.ui.editpolicy.RelationEndpointEditPolicy;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Polyline;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.gef.AccessibleEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartListener;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.kernel.Relation;
import ptolemy.kernel.util.ChangeListener;
import ptolemy.kernel.util.ChangeRequest;
import ptolemy.kernel.util.Changeable;

public class RelationEditPart
extends AbstractConnectionEditPart
implements ChangeListener,
EditPartListener {
    private static Logger logger = LoggerFactory.getLogger(RelationEditPart.class);
    private static final Color alive = new Color((Device)Display.getDefault(), 0, 74, 168);
    private static final Color dead = new Color((Device)Display.getDefault(), 0, 0, 0);
    private AccessibleEditPart acc;

    public Logger getLogger() {
        return logger;
    }

    public void activate() {
        super.activate();
        if (this.getSource() != null) {
            this.getSource().addEditPartListener((EditPartListener)this);
        }
    }

    public void deactivate() {
        super.deactivate();
        if (this.getSource() != null) {
            this.getSource().removeEditPartListener((EditPartListener)this);
        }
    }

    public void activateFigure() {
        super.activateFigure();
        if (this.getRelation() instanceof Changeable) {
            Relation relation = this.getRelation();
            relation.addChangeListener((ChangeListener)this);
        }
    }

    public void deactivateFigure() {
        if (this.getRelation() instanceof Changeable) {
            Relation relation = this.getRelation();
            relation.removeChangeListener((ChangeListener)this);
        }
        super.deactivateFigure();
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ConnectionEditPolicy", (EditPolicy)new RelationDeletePolicy());
        this.installEditPolicy("Connection Endpoint Policy", (EditPolicy)new RelationEndpointEditPolicy());
    }

    protected IFigure createFigure() {
        PolylineConnection polylineConnection = RouterFactory.getConnection();
        polylineConnection.setForegroundColor(ColorConstants.gray);
        PasserellRootEditPart passerellRootEditPart = (PasserellRootEditPart)this.getRoot();
        polylineConnection.setConnectionRouter((ConnectionRouter)RouterFactory.getRouter((IFigure)passerellRootEditPart.getScaledLayers()));
        return polylineConnection;
    }

    public AccessibleEditPart getAccessibleEditPart() {
        if (this.acc == null) {
            this.acc = new AbstractGraphicalEditPart.AccessibleGraphicalEditPart((AbstractGraphicalEditPart)this){

                public void getName(AccessibleEvent accessibleEvent) {
                    accessibleEvent.result = "Link";
                }
            };
        }
        return this.acc;
    }

    public Relation getRelation() {
        return (Relation)this.getModel();
    }

    protected void updateSelected() {
        EditPart editPart = this.getSource();
        if (editPart != null) {
            int n = editPart.getSelected();
            Polyline polyline = (Polyline)this.getFigure();
            if (n != 0) {
                polyline.setLineWidth(2);
            } else {
                polyline.setLineWidth(1);
            }
        }
    }

    public void changeExecuted(ChangeRequest changeRequest) {
        this.getLogger().trace("ChangeRequest executed in RelationEditPart");
    }

    public void changeFailed(ChangeRequest changeRequest, Exception exception) {
        this.getLogger().trace("Error executing ChangeRequest", (Throwable)exception);
    }

    public void childAdded(EditPart editPart, int n) {
    }

    public void partActivated(EditPart editPart) {
    }

    public void partDeactivated(EditPart editPart) {
    }

    public void removingChild(EditPart editPart, int n) {
    }

    public void selectedStateChanged(EditPart editPart) {
        this.updateSelected();
    }
}

