/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.workbench.model.editor.ui.editpart;

import com.isencia.passerelle.actor.Sink;
import com.isencia.passerelle.actor.Source;
import com.isencia.passerelle.workbench.model.editor.ui.editor.PasserelleModelMultiPageEditor;
import com.isencia.passerelle.workbench.model.editor.ui.editpart.AbstractBaseEditPart;
import com.isencia.passerelle.workbench.model.editor.ui.editpart.ActorEditPart;
import com.isencia.passerelle.workbench.model.editor.ui.editpart.ActorSinkEditPart;
import com.isencia.passerelle.workbench.model.editor.ui.editpart.ActorSourceEditPart;
import com.isencia.passerelle.workbench.model.editor.ui.editpart.CommentEditPart;
import com.isencia.passerelle.workbench.model.editor.ui.editpart.CompositeActorEditPart;
import com.isencia.passerelle.workbench.model.editor.ui.editpart.CustomFigureEditPart;
import com.isencia.passerelle.workbench.model.editor.ui.editpart.DiagramEditPart;
import com.isencia.passerelle.workbench.model.editor.ui.editpart.DirectorEditPart;
import com.isencia.passerelle.workbench.model.editor.ui.editpart.IActorFigureProvider;
import com.isencia.passerelle.workbench.model.editor.ui.editpart.PortEditPart;
import com.isencia.passerelle.workbench.model.editor.ui.editpart.RelationEditPart;
import com.isencia.passerelle.workbench.model.editor.ui.editpart.SubModelEditPart;
import com.isencia.passerelle.workbench.model.editor.ui.editpart.VertexEditPart;
import com.isencia.passerelle.workbench.model.editor.ui.editpart.VertexLinkEditPart;
import com.isencia.passerelle.workbench.model.ui.VertexLink;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.gef.EditPart;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.actor.CompositeActor;
import ptolemy.actor.Director;
import ptolemy.actor.IOPort;
import ptolemy.actor.TypedAtomicActor;
import ptolemy.actor.TypedCompositeActor;
import ptolemy.kernel.Relation;
import ptolemy.kernel.util.ChangeListener;
import ptolemy.moml.Vertex;
import ptolemy.vergil.kernel.attributes.TextAttribute;

public class EditPartFactory
implements org.eclipse.gef.EditPartFactory {
    private Set<AbstractBaseEditPart> parts = new HashSet<AbstractBaseEditPart>();
    private static Logger logger = LoggerFactory.getLogger(EditPartFactory.class);
    protected PasserelleModelMultiPageEditor parent;
    private CompositeActor actor;
    private Map<String, IConfigurationElement> extensionParts;

    public Set<AbstractBaseEditPart> getParts() {
        return this.parts;
    }

    public MultiPageEditorPart getParent() {
        return this.parent;
    }

    public EditPartFactory(PasserelleModelMultiPageEditor passerelleModelMultiPageEditor) {
        this.parent = passerelleModelMultiPageEditor;
    }

    public EditPartFactory(PasserelleModelMultiPageEditor passerelleModelMultiPageEditor, CompositeActor compositeActor) {
        this.parent = passerelleModelMultiPageEditor;
        this.actor = compositeActor;
    }

    private Logger getLogger() {
        return logger;
    }

    public EditPart createEditPart(EditPart editPart, Object object) {
        ChangeListener changeListener = null;
        if (object instanceof Director) {
            changeListener = new DirectorEditPart();
        } else if (object instanceof TextAttribute) {
            changeListener = new CommentEditPart();
        } else if (object instanceof Vertex) {
            changeListener = new VertexEditPart();
        } else if (object instanceof IOPort) {
            changeListener = ((IOPort)object).isInput() ? new PortEditPart(true) : new PortEditPart(false);
        } else if (object instanceof Relation) {
            changeListener = new RelationEditPart();
        } else if (object instanceof VertexLink) {
            changeListener = new VertexLinkEditPart();
        } else if (object instanceof TypedCompositeActor) {
            TypedCompositeActor typedCompositeActor;
            String string;
            changeListener = ((TypedCompositeActor)object).getContainer() == null ? new DiagramEditPart(this.parent, this.actor) : ((string = (typedCompositeActor = (TypedCompositeActor)object).getClassName()).equals("ptolemy.actor.TypedCompositeActor") ? new CompositeActorEditPart(editPart == null || editPart.getParent() == null, this.parent) : new SubModelEditPart(editPart == null || editPart.getParent() == null, this.parent));
        } else if (object instanceof TypedAtomicActor) {
            try {
                changeListener = this.getEditPartFromExtensionPoint(object);
            }
            catch (Exception exception) {
                logger.error("Cannot load editorClass for " + object.getClass().getName(), (Throwable)exception);
            }
            if (changeListener == null) {
                try {
                    IActorFigureProvider iActorFigureProvider = this.getFigureProviderFromExtensionPoint(object);
                    if (iActorFigureProvider != null) {
                        changeListener = new CustomFigureEditPart(iActorFigureProvider);
                    }
                }
                catch (Exception exception) {
                    logger.error("Cannot load editorClass for " + object.getClass().getName(), (Throwable)exception);
                }
                if (changeListener == null) {
                    changeListener = object instanceof Source ? new ActorSourceEditPart() : (object instanceof Sink ? new ActorSinkEditPart() : new ActorEditPart());
                }
            }
        }
        if (changeListener != null) {
            changeListener.setModel(object);
        } else {
            this.getLogger().error("Unable to create EditPart, requested model not supported");
        }
        if (changeListener instanceof AbstractBaseEditPart) {
            this.parts.add((AbstractBaseEditPart)changeListener);
        }
        return changeListener;
    }

    private void createExtensionParts() {
        if (this.extensionParts == null) {
            this.extensionParts = new HashMap<String, IConfigurationElement>(7);
            IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor("com.isencia.passerelle.engine.actors");
            int n = 0;
            while (n < iConfigurationElementArray.length) {
                String string = iConfigurationElementArray[n].getAttribute("class");
                String string2 = iConfigurationElementArray[n].getAttribute("editorClass");
                String string3 = iConfigurationElementArray[n].getAttribute("figureCustomizer");
                if (string != null && (string2 != null || string3 != null)) {
                    this.extensionParts.put(string, iConfigurationElementArray[n]);
                }
                ++n;
            }
        }
    }

    private EditPart getEditPartFromExtensionPoint(Object object) throws CoreException {
        this.createExtensionParts();
        if (this.extensionParts.containsKey(object.getClass().getName())) {
            if (this.extensionParts.get(object.getClass().getName()).getAttribute("editorClass") == null) {
                return null;
            }
            return (EditPart)this.extensionParts.get(object.getClass().getName()).createExecutableExtension("editorClass");
        }
        return null;
    }

    private IActorFigureProvider getFigureProviderFromExtensionPoint(Object object) throws CoreException {
        this.createExtensionParts();
        if (this.extensionParts.containsKey(object.getClass().getName())) {
            if (this.extensionParts.get(object.getClass().getName()).getAttribute("figureCustomizer") == null) {
                return null;
            }
            return (IActorFigureProvider)this.extensionParts.get(object.getClass().getName()).createExecutableExtension("figureCustomizer");
        }
        return null;
    }

    private Vertex getVertex(Relation relation) {
        Enumeration enumeration = relation.getAttributes();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof Vertex)) continue;
            return (Vertex)e;
        }
        return null;
    }
}

