/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.workbench.model.editor.ui.editpart;

import com.isencia.passerelle.core.ControlPort;
import com.isencia.passerelle.core.ErrorPort;
import com.isencia.passerelle.workbench.model.editor.ui.Activator;
import com.isencia.passerelle.workbench.model.editor.ui.editpart.AbstractNodeEditPart;
import com.isencia.passerelle.workbench.model.editor.ui.editpart.DiagramEditPart;
import com.isencia.passerelle.workbench.model.editor.ui.editpart.IActorNodeEditPart;
import com.isencia.passerelle.workbench.model.editor.ui.editpart.VertexEditPart;
import com.isencia.passerelle.workbench.model.editor.ui.editpart.VertexLinkEditPart;
import com.isencia.passerelle.workbench.model.editor.ui.editpolicy.ActorEditPolicy;
import com.isencia.passerelle.workbench.model.editor.ui.editpolicy.ComponentNodeDeletePolicy;
import com.isencia.passerelle.workbench.model.editor.ui.figure.ActorFigure;
import com.isencia.passerelle.workbench.model.editor.ui.figure.PortFigure;
import com.isencia.passerelle.workbench.model.editor.ui.figure.RectangularActorFigure;
import com.isencia.passerelle.workbench.model.editor.ui.palette.PaletteItemFactory;
import com.isencia.passerelle.workbench.model.utils.ModelUtils;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Clickable;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ImageFigure;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.AccessibleAnchorProvider;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.requests.DropRequest;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.actor.Actor;
import ptolemy.actor.IOPort;
import ptolemy.actor.IORelation;
import ptolemy.actor.TypedIOPort;
import ptolemy.actor.TypedIORelation;
import ptolemy.kernel.Port;
import ptolemy.kernel.Relation;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.moml.Vertex;

public class ActorEditPart
extends AbstractNodeEditPart
implements IActorNodeEditPart {
    private static final Logger logger = LoggerFactory.getLogger(ActorEditPart.class);
    public static final ImageDescriptor IMAGE_DESCRIPTOR_PROPERTIES = Activator.getImageDescriptor("icons/input.gif");
    public static final Color COLOR_ERROR_PORT = new Color(null, 192, 20, 20);
    public static final Color COLOR_CONTROL_PORT = new Color(null, 50, 50, 255);
    public static final ImageDescriptor IMAGE_COMMENT = Activator.getImageDescriptor("icons/comment.png");
    public static final ImageDescriptor IMAGE_DESCRIPTOR_ACTOR = Activator.getImageDescriptor("icons/actor.gif");
    public static final ImageDescriptor IMAGE_DESCRIPTOR_PARAMETER = Activator.getImageDescriptor("icons/parameter.gif");
    public static final ImageDescriptor IMAGE_DESCRIPTOR_INPUTPORT = Activator.getImageDescriptor("icons/input.gif");
    public static final ImageDescriptor IMAGE_DESCRIPTOR_OUTPUTPORT = Activator.getImageDescriptor("icons/output.gif");

    @Override
    public Logger getLogger() {
        return logger;
    }

    protected void createEditPolicies() {
        if (this.getParent() instanceof DiagramEditPart) {
            this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new ActorEditPolicy(((DiagramEditPart)this.getParent()).getMultiPageEditorPart(), this));
        }
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new ComponentNodeDeletePolicy());
    }

    protected IFigure createFigure() {
        List list3;
        Actor actor = this.getActor();
        ImageFigure imageFigure = new ImageFigure(this.createImage(IMAGE_DESCRIPTOR_ACTOR));
        imageFigure.setAlignment(4);
        imageFigure.setBorder((Border)new MarginBorder(0, 0, 5, 0));
        ImageDescriptor imageDescriptor = PaletteItemFactory.getInstance().getIcon(actor.getClass());
        if (imageDescriptor == null) {
            imageDescriptor = IMAGE_DESCRIPTOR_ACTOR;
        }
        ActorFigure actorFigure = this.getActorFigure(actor.getDisplayName(), this.createImage(imageDescriptor), new Clickable[0]);
        List list2 = actor.inputPortList();
        if (list2 != null) {
            for (List list3 : list2) {
                PortFigure portFigure = actorFigure.addInput(list3.getName(), list3.getDisplayName());
                if (list3 instanceof ErrorPort) {
                    portFigure.setFillColor(COLOR_ERROR_PORT);
                    continue;
                }
                if (!(list3 instanceof ControlPort)) continue;
                portFigure.setFillColor(COLOR_CONTROL_PORT);
            }
        }
        if ((list3 = actor.outputPortList()) != null) {
            for (TypedIOPort typedIOPort : list3) {
                PortFigure portFigure = actorFigure.addOutput(typedIOPort.getName(), typedIOPort.getDisplayName());
                if (typedIOPort instanceof ErrorPort) {
                    portFigure.setFillColor(COLOR_ERROR_PORT);
                    continue;
                }
                if (!(typedIOPort instanceof ControlPort)) continue;
                portFigure.setFillColor(COLOR_CONTROL_PORT);
            }
        }
        return actorFigure;
    }

    protected ActorFigure getActorFigure(String string, Image image, Clickable[] clickableArray) {
        return new RectangularActorFigure(string, this.getModel().getClass(), image, clickableArray);
    }

    @Override
    public Object getAdapter(Class clazz) {
        if (clazz == AccessibleAnchorProvider.class) {
            return new AbstractGraphicalEditPart.DefaultAccessibleAnchorProvider(this){

                public List<Point> getSourceAnchorLocations() {
                    ArrayList<Point> arrayList = new ArrayList<Point>();
                    Vector<ConnectionAnchor> vector = ActorEditPart.this.getComponentFigure().getSourceConnectionAnchors();
                    int n = 0;
                    while (n < vector.size()) {
                        ConnectionAnchor connectionAnchor = vector.get(n);
                        arrayList.add(connectionAnchor.getReferencePoint().getTranslated(0, -3));
                        ++n;
                    }
                    return arrayList;
                }

                public List<Point> getTargetAnchorLocations() {
                    ArrayList<Point> arrayList = new ArrayList<Point>();
                    Vector<ConnectionAnchor> vector = ActorEditPart.this.getComponentFigure().getTargetConnectionAnchors();
                    int n = 0;
                    while (n < vector.size()) {
                        ConnectionAnchor connectionAnchor = vector.get(n);
                        arrayList.add(connectionAnchor.getReferencePoint().getTranslated(0, 3));
                        ++n;
                    }
                    return arrayList;
                }
            };
        }
        return super.getAdapter(clazz);
    }

    @Override
    public ActorFigure getComponentFigure() {
        return (ActorFigure)this.getFigure();
    }

    public Actor getActor() {
        Object object = this.getModel();
        if (object instanceof Actor) {
            return (Actor)object;
        }
        return null;
    }

    public void setSelected(int n) {
        super.setSelected(n);
        this.refreshVisuals();
    }

    protected List getModelSourceConnections() {
        Set set = ModelUtils.getConnectedRelations((Nameable)((NamedObj)this.getModel()), (ModelUtils.ConnectionType)ModelUtils.ConnectionType.SOURCE);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Relation relation : set) {
            Vertex vertex = this.getVertex(relation);
            if (vertex != null) {
                List list = ModelUtils.getPorts((Relation)relation, (NamedObj)((NamedObj)this.getModel()));
                for (IOPort iOPort : list) {
                    Object object = VertexEditPart.getRelation((TypedIORelation)relation, iOPort, vertex, false);
                    arrayList.add(object);
                }
                continue;
            }
            arrayList.add(relation);
        }
        return arrayList;
    }

    protected List getModelTargetConnections() {
        Set set = ModelUtils.getConnectedRelations((Nameable)((NamedObj)this.getModel()), (ModelUtils.ConnectionType)ModelUtils.ConnectionType.TARGET);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Relation relation : set) {
            Vertex vertex = this.getVertex(relation);
            if (vertex != null) {
                for (IOPort iOPort : ModelUtils.getPorts((Relation)relation, (NamedObj)((NamedObj)this.getModel()))) {
                    arrayList.add(VertexEditPart.getRelation((TypedIORelation)relation, iOPort, vertex, false));
                }
                continue;
            }
            arrayList.add(relation);
        }
        return arrayList;
    }

    public Vertex getVertex(Relation relation) {
        Enumeration enumeration = relation.getAttributes();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof Vertex)) continue;
            return (Vertex)e;
        }
        return null;
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connectionEditPart) {
        Relation relation;
        this.getLogger().trace("Get SourceConnectionAnchor based on ConnectionEditPart");
        IOPort iOPort = null;
        if (connectionEditPart instanceof VertexLinkEditPart) {
            iOPort = ((VertexLinkEditPart)connectionEditPart).getPort();
        } else {
            relation = (Relation)connectionEditPart.getModel();
            List list = ((IORelation)relation).linkedSourcePortList();
            if (list == null || list.size() == 0) {
                return null;
            }
            iOPort = (Port)list.get(0);
        }
        relation = this.getComponentFigure().getConnectionAnchor(iOPort.getName());
        return relation;
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        Point point = new Point(((DropRequest)request).getLocation());
        return this.getComponentFigure().getSourceConnectionAnchorAt(point);
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connectionEditPart) {
        IORelation iORelation;
        this.getLogger().trace("Get TargetConnectionAnchor based on ConnectionEditPart");
        IOPort iOPort = null;
        if (connectionEditPart instanceof VertexLinkEditPart) {
            iOPort = ((VertexLinkEditPart)connectionEditPart).getPort();
        } else {
            iORelation = (IORelation)connectionEditPart.getModel();
            List list = iORelation.linkedDestinationPortList();
            if (list == null || list.size() == 0) {
                return null;
            }
            iOPort = (Port)list.get(0);
        }
        iORelation = this.getComponentFigure().getConnectionAnchor(iOPort.getName());
        return iORelation;
    }

    @Override
    public Port getSourcePort(ConnectionAnchor connectionAnchor) {
        this.getLogger().trace("Get Source port  based on anchor");
        ActorFigure actorFigure = this.getComponentFigure();
        List list = this.getActor().outputPortList();
        for (Port port : list) {
            String string = actorFigure.getConnectionAnchorName(connectionAnchor);
            String string2 = port.getName();
            if (string2 == null || !string2.equals(string)) continue;
            return port;
        }
        return null;
    }

    @Override
    public Port getTargetPort(ConnectionAnchor connectionAnchor) {
        this.getLogger().trace("Get Target port  based on anchor");
        ActorFigure actorFigure = this.getComponentFigure();
        List list = this.getActor().inputPortList();
        for (Port port : list) {
            if (port.getName() == null || !port.getName().equals(actorFigure.getConnectionAnchorName(connectionAnchor))) continue;
            return port;
        }
        return null;
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        Point point = new Point(((DropRequest)request).getLocation());
        return this.getComponentFigure().getTargetConnectionAnchorAt(point);
    }

    protected final String mapConnectionAnchorToTerminal(ConnectionAnchor connectionAnchor) {
        return this.getComponentFigure().getConnectionAnchorName(connectionAnchor);
    }
}

