/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.workbench.model.editor.ui.editpart;

import com.isencia.passerelle.workbench.model.editor.ui.Activator;
import com.isencia.passerelle.workbench.model.editor.ui.INameable;
import com.isencia.passerelle.workbench.model.editor.ui.properties.EntityPropertySource;
import com.isencia.passerelle.workbench.model.ui.command.AttributeCommand;
import com.isencia.passerelle.workbench.model.ui.command.ChangeActorPropertyCommand;
import com.isencia.passerelle.workbench.model.ui.command.IRefreshConnections;
import com.isencia.passerelle.workbench.model.ui.command.RenameCommand;
import com.isencia.passerelle.workbench.model.ui.command.SetConstraintCommand;
import com.isencia.passerelle.workbench.model.ui.utils.EclipseUtils;
import com.isencia.passerelle.workbench.model.utils.ModelChangeRequest;
import com.isencia.passerelle.workbench.model.utils.ModelUtils;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertySheet;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.kernel.util.ChangeListener;
import ptolemy.kernel.util.ChangeRequest;
import ptolemy.kernel.util.Changeable;
import ptolemy.kernel.util.NamedObj;

public abstract class AbstractBaseEditPart
extends AbstractGraphicalEditPart
implements ChangeListener {
    protected Set<Image> images = new HashSet<Image>();
    private static final Logger logger = LoggerFactory.getLogger(AbstractBaseEditPart.class);
    protected IPropertySource propertySource = null;
    private IPropertyChangeListener expertUpdater;

    public Set<Image> getImages() {
        return this.images;
    }

    protected Image createImage(ImageDescriptor imageDescriptor) {
        Image image = imageDescriptor.createImage();
        this.images.add(image);
        return image;
    }

    public void activate() {
        if (this.isActive()) {
            return;
        }
        super.activate();
        if (this.getEntity() instanceof Changeable) {
            NamedObj namedObj = this.getEntity();
            namedObj.addChangeListener((ChangeListener)this);
        }
        if (this.expertUpdater == null) {
            this.expertUpdater = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    TabbedPropertySheetPage tabbedPropertySheetPage;
                    PropertySheet propertySheet;
                    if (propertyChangeEvent.getProperty().equals("com.isencia.passerelle.workbench.model.editor.EXPERT") && (propertySheet = (PropertySheet)EclipseUtils.getPage().findView("org.eclipse.ui.views.PropertySheet")) != null && (tabbedPropertySheetPage = (TabbedPropertySheetPage)propertySheet.getCurrentPage()) != null) {
                        tabbedPropertySheetPage.refresh();
                    }
                }
            };
        }
        Activator.getDefault().getPreferenceStore().addPropertyChangeListener(this.expertUpdater);
    }

    public void deactivate() {
        Activator.getDefault().getPreferenceStore().removePropertyChangeListener(this.expertUpdater);
        if (!this.isActive()) {
            return;
        }
        if (this.getEntity() instanceof Changeable) {
            NamedObj namedObj = this.getEntity();
            namedObj.removeChangeListener((ChangeListener)this);
        }
        super.deactivate();
    }

    public NamedObj getEntity() {
        return (NamedObj)this.getModel();
    }

    protected Figure getComponentFigure() {
        return (Figure)this.getFigure();
    }

    public void refreshVisuals() {
        double[] dArray = ModelUtils.getLocation((NamedObj)this.getEntity());
        Rectangle rectangle = new Rectangle(new Point(dArray[0], dArray[1]), this.getComponentFigure().getPreferredSize(-1, -1));
        if (this.getParent() instanceof GraphicalEditPart) {
            ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.getFigure(), (Object)rectangle);
        }
    }

    public Object getAdapter(Class clazz) {
        if (IPropertySource.class == clazz) {
            return this.getPropertySource();
        }
        return super.getAdapter(clazz);
    }

    protected IPropertySource getPropertySource() {
        if (this.propertySource == null) {
            this.propertySource = new EntityPropertySource(this.getEntity(), this.getFigure());
        }
        return this.propertySource;
    }

    public void changeExecuted(ChangeRequest changeRequest) {
        this.getLogger().trace("Change Executed");
        Object object = changeRequest.getSource();
        if (changeRequest instanceof ModelChangeRequest) {
            Class clazz = ((ModelChangeRequest)changeRequest).getType();
            if (IPropertySource.class.isAssignableFrom(clazz) || AttributeCommand.class.isAssignableFrom(clazz)) {
                this.onChangePropertyResource(object);
                return;
            }
            if (SetConstraintCommand.class.equals((Object)clazz)) {
                if (object == this.getModel() && object instanceof NamedObj) {
                    this.refresh();
                }
                return;
            }
            if (RenameCommand.class.equals((Object)clazz)) {
                if (object == this.getModel() && object instanceof NamedObj) {
                    String string = this.getText(object);
                    if (this.getComponentFigure() instanceof INameable && string != null && !string.equals(((INameable)this.getComponentFigure()).getName())) {
                        ((INameable)this.getComponentFigure()).setName(string);
                        this.getFigure().repaint();
                    }
                }
                return;
            }
            if (IRefreshConnections.class.isAssignableFrom(clazz)) {
                this.refreshConnections(clazz, object);
                return;
            }
        }
    }

    protected void refreshConnections(Class clazz, Object object) {
        try {
            this.refreshSourceConnections();
            this.refreshTargetConnections();
        }
        catch (Exception exception) {}
    }

    protected void onChangePropertyResource(Object object) {
        if (object == this.getModel()) {
            this.getViewer().getEditDomain().getCommandStack().execute((Command)new ChangeActorPropertyCommand());
        }
    }

    protected String getText(Object object) {
        return ((NamedObj)object).getDisplayName();
    }

    public void changeFailed(ChangeRequest changeRequest, Exception exception) {
        this.getLogger().trace("Change Failed : " + exception.getMessage());
    }

    public Logger getLogger() {
        return logger;
    }
}

