/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.workbench.model.editor.ui.editor.actions;

import com.isencia.passerelle.workbench.model.editor.ui.Activator;
import com.isencia.passerelle.workbench.model.ui.IPasserelleEditor;
import java.io.File;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;

public class ScreenshotAction
extends SelectionAction {
    public static final String ID = ScreenshotAction.class.getName();
    private static String previousDir;

    public ScreenshotAction(IPasserelleEditor iPasserelleEditor) {
        super((IWorkbenchPart)iPasserelleEditor);
        this.setId(ID);
    }

    protected void init() {
        this.setText("Screenshot");
        this.setToolTipText("Screenshot of workflow in png format.");
        this.setEnabled(true);
        this.setImageDescriptor(Activator.getImageDescriptor("icons/camera.gif"));
    }

    public void run() {
        boolean bl;
        String string;
        FileDialog fileDialog = new FileDialog(Display.getDefault().getShells()[0], 8192);
        fileDialog.setFilterNames(new String[]{"PNG Files", "All Files (*.*)"});
        fileDialog.setFilterExtensions(new String[]{"*.png", "*.*"});
        if (previousDir != null) {
            fileDialog.setFilterPath(previousDir);
        }
        if ((string = fileDialog.open()) == null || string.length() <= 0) {
            return;
        }
        File file = new File(string);
        previousDir = file.getParent();
        if (file.exists() && !(bl = MessageDialog.openConfirm((Shell)Display.getDefault().getShells()[0], (String)"Confirm Overwrite", (String)("Would you like to over-write '" + file.getName() + "'?")))) {
            return;
        }
        ImageLoader imageLoader = new ImageLoader();
        IPasserelleEditor iPasserelleEditor = (IPasserelleEditor)this.getWorkbenchPart();
        IFigure iFigure = iPasserelleEditor.getWorkflowFigure();
        Rectangle rectangle = iFigure.getBounds();
        Image image = new Image(null, rectangle.width + 6, rectangle.height + 6);
        GC gC = new GC((Drawable)image);
        SWTGraphics sWTGraphics = new SWTGraphics(gC);
        sWTGraphics.translate(-rectangle.x + 3, -rectangle.y + 3);
        sWTGraphics.setForegroundColor(iFigure.getForegroundColor());
        sWTGraphics.setBackgroundColor(iFigure.getBackgroundColor());
        iFigure.paint((Graphics)sWTGraphics);
        gC.dispose();
        imageLoader.data = new ImageData[]{image.getImageData()};
        image.dispose();
        if (!string.toLowerCase().endsWith(".png")) {
            string = String.valueOf(string) + ".png";
        }
        imageLoader.save(string, 5);
    }

    protected boolean calculateEnabled() {
        return true;
    }
}

