/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.workbench.model.editor.ui.editor.actions;

import com.isencia.passerelle.workbench.model.editor.ui.Activator;
import com.isencia.passerelle.workbench.model.editor.ui.editor.PasserelleModelMultiPageEditor;
import com.isencia.passerelle.workbench.model.editor.ui.editor.actions.ExecutionAction;
import com.isencia.passerelle.workbench.model.editor.ui.editor.actions.ModelChangeEvent;
import com.isencia.passerelle.workbench.model.editor.ui.editor.actions.ModelChangeListener;
import com.isencia.passerelle.workbench.model.editor.ui.editor.actions.WorkflowLaunchConfiguration;
import com.isencia.passerelle.workbench.model.jmx.RemoteManagerAgent;
import com.isencia.passerelle.workbench.model.launch.ModelRunner;
import com.isencia.passerelle.workbench.model.ui.utils.EclipseUtils;
import java.net.URL;
import javax.management.MBeanServerConnection;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.internal.util.BundleUtility;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RunAction
extends ExecutionAction
implements IEditorActionDelegate,
ModelChangeListener {
    private static final Logger logger = LoggerFactory.getLogger(RunAction.class);

    public RunAction() {
        this.setId(this.getClass().getName());
        this.setText("Run the workflow from start to end until finished.");
        this.setImageDescriptor(Activator.getImageDescriptor("/icons/run_workflow.gif"));
        ExecutionAction.addModelChangeListener(this);
    }

    public void run() {
        this.run((IAction)this);
    }

    public void run(IAction iAction) {
        try {
            IFile iFile = this.getModelRunner();
            this.run(iFile);
        }
        catch (Exception exception) {
            logger.error("Cannot read configuration", (Throwable)exception);
        }
    }

    public void run(IFile iFile) {
        try {
            Object object;
            IResource iResource;
            IWorkbenchPage iWorkbenchPage = EclipseUtils.getPage();
            iWorkbenchPage.showView("org.eclipse.ui.console.ConsoleView");
            boolean bl = EclipseUtils.getPage().saveAllEditors(true);
            if (!bl) {
                return;
            }
            IEditorPart iEditorPart = EclipseUtils.getPage().getActiveEditor();
            if (iEditorPart != null) {
                EclipseUtils.getPage().activate((IWorkbenchPart)iEditorPart);
            }
            if ((iResource = this.getSelectedResource()) instanceof IFile) {
                EclipseUtils.openEditor((IFile)((IFile)iResource));
            }
            if (iResource == null && iEditorPart == null) {
                object = EclipseUtils.getPage().getEditorReferences();
                int n = 0;
                while (n < ((IEditorReference[])object).length) {
                    if (object[n].getId().equals("com.isencia.passerelle.workbench.model.editor.ui.editors.modelEditor")) {
                        EclipseUtils.getPage().activate((IWorkbenchPart)object[n].getEditor(true));
                        break;
                    }
                    ++n;
                }
            }
            if (iEditorPart != null && iEditorPart instanceof PasserelleModelMultiPageEditor) {
                ((PasserelleModelMultiPageEditor)iEditorPart).setActorSelected(null, false, -1);
            }
            this.saveWorkSpace();
            this.fireRunListeners();
            if (System.getProperty("eclipse.debug.session") != null) {
                object = new Job("Run workflow debug mode"){

                    protected IStatus run(IProgressMonitor iProgressMonitor) {
                        ModelRunner modelRunner = new ModelRunner();
                        try {
                            modelRunner.runModel(iResource.getLocation().toOSString(), false);
                        }
                        catch (Throwable throwable) {
                            logger.error("Error during workflow execution", throwable);
                        }
                        return Status.OK_STATUS;
                    }
                };
                object.setUser(false);
                object.setPriority(30);
                object.schedule();
                this.updateActionsAvailable(200L);
            } else {
                object = new WorkflowLaunchConfiguration(iFile);
                ((WorkflowLaunchConfiguration)((Object)object)).addSystemProperty("com.isencia.jmx.service.port");
                ((WorkflowLaunchConfiguration)((Object)object)).addSystemProperty("com.isencia.require.file.source");
                DebugUITools.launch((ILaunchConfiguration)object, (String)"run");
            }
        }
        catch (Exception exception) {
            logger.error("Cannot read configuration", (Throwable)exception);
            this.updateActionsAvailable(500L);
        }
    }

    @Override
    public void executionStarted(ModelChangeEvent modelChangeEvent) {
        this.updateActionsAvailable(100L);
    }

    @Override
    public void executionTerminated(ModelChangeEvent modelChangeEvent) {
        this.updateActionsAvailable(500L);
    }

    private void saveWorkSpace() throws CoreException {
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        iWorkspace.save(true, (IProgressMonitor)new NullProgressMonitor());
    }

    public boolean isEnabled() {
        if (System.getProperty("eclipse.debug.session") != null) {
            return ModelRunner.getRunningInstance() == null;
        }
        try {
            MBeanServerConnection mBeanServerConnection = RemoteManagerAgent.getServerConnection((long)100L);
            return mBeanServerConnection.getObjectInstance(RemoteManagerAgent.REMOTE_MANAGER) == null;
        }
        catch (Throwable throwable) {
            return true;
        }
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
    }

    public IFile getModelRunner() throws Exception {
        Bundle bundle = Activator.getDefault().getBundle();
        URL uRL = BundleUtility.find((Bundle)bundle, (String)"ModelRunner.txt");
        IResource iResource = this.getSelectedResource();
        IFile iFile = iResource.getProject().getFile("WorkflowConfiguration.launch");
        if (iFile.exists()) {
            return iFile;
        }
        iFile.create(uRL.openStream(), true, null);
        iFile.getProject().refreshLocal(2, null);
        return iFile;
    }

    private IResource getSelectedResource() {
        IFile iFile;
        IFile iFile2;
        Object object;
        ISelection iSelection = EclipseUtils.getPage().getSelection();
        if (iSelection != null && iSelection instanceof IStructuredSelection && (object = (iFile2 = (IStructuredSelection)iSelection).getFirstElement()) instanceof IFile && (iFile = (IFile)object).getName().toLowerCase().endsWith(".moml")) {
            return iFile;
        }
        iFile2 = EclipseUtils.getIFile((IEditorInput)EclipseUtils.getPage().getActiveEditor().getEditorInput());
        if (iFile2.getName().toLowerCase().endsWith(".moml")) {
            return iFile2;
        }
        return null;
    }

    public void setActiveEditor(IAction iAction, IEditorPart iEditorPart) {
    }
}

