/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.workbench.model.editor.ui.editor.actions;

import com.isencia.passerelle.workbench.model.editor.ui.Activator;
import com.isencia.passerelle.workbench.model.editor.ui.editor.PasserelleModelEditor;
import com.isencia.passerelle.workbench.model.editor.ui.editor.PasserelleModelMultiPageEditor;
import com.isencia.passerelle.workbench.model.editor.ui.editor.actions.CheckableActionGroup;
import com.isencia.passerelle.workbench.model.editor.ui.editor.actions.ConnectionAction;
import com.isencia.passerelle.workbench.model.editor.ui.editor.actions.MenuAction;
import com.isencia.passerelle.workbench.model.editor.ui.editor.actions.RouterAction;
import com.isencia.passerelle.workbench.model.editor.ui.router.SCAManhattanConnectionRouter;
import org.eclipse.draw2d.AbstractRouter;
import org.eclipse.draw2d.BendpointConnectionRouter;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.gmf.runtime.draw2d.ui.figures.PolylineConnectionEx;
import org.eclipse.gmf.runtime.draw2d.ui.internal.routers.RectilinearRouter;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.PlatformUI;

public class RouterFactory {
    public static final String ROUTER_PREF = "com.isencia.passerelle.workbench.model.editor.ui.RouterType";
    private static ROUTER_TYPE type = ROUTER_TYPE.getDefaultType();
    private static CONNECTION_TYPE conn = CONNECTION_TYPE.STRAIGHT;

    public static AbstractRouter getRouter(IFigure iFigure) {
        return type.getRouter(iFigure);
    }

    public static ROUTER_TYPE getRouterType() {
        return type;
    }

    public static void setRouter(ROUTER_TYPE rOUTER_TYPE) {
        type = rOUTER_TYPE;
        RouterFactory.refreshEditors();
    }

    public static void setConnectionType(CONNECTION_TYPE cONNECTION_TYPE) {
        conn = cONNECTION_TYPE;
        RouterFactory.refreshEditors();
    }

    private static void refreshEditors() {
        IEditorReference[] iEditorReferenceArray;
        IEditorReference[] iEditorReferenceArray2 = iEditorReferenceArray = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
        int n = iEditorReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference iEditorReference = iEditorReferenceArray2[n2];
            IEditorPart iEditorPart = iEditorReference.getEditor(false);
            PasserelleModelEditor passerelleModelEditor = null;
            if (iEditorPart instanceof PasserelleModelEditor) {
                passerelleModelEditor = (PasserelleModelEditor)iEditorPart;
            } else if (iEditorPart instanceof PasserelleModelMultiPageEditor) {
                passerelleModelEditor = ((PasserelleModelMultiPageEditor)iEditorPart).getEditor();
            }
            if (passerelleModelEditor != null) {
                passerelleModelEditor.refresh();
            }
            ++n2;
        }
    }

    public static PolylineConnection getConnection() {
        if (conn == CONNECTION_TYPE.STRAIGHT) {
            return new PolylineConnection();
        }
        if (conn == CONNECTION_TYPE.STRAIGHT_JUMPS) {
            PolylineConnectionEx polylineConnectionEx = new PolylineConnectionEx();
            polylineConnectionEx.setSmoothness(0);
            polylineConnectionEx.setJumpLinks(true);
            return polylineConnectionEx;
        }
        if (conn == CONNECTION_TYPE.CURVES) {
            PolylineConnectionEx polylineConnectionEx = new PolylineConnectionEx();
            polylineConnectionEx.setSmoothness(16);
            polylineConnectionEx.setJumpLinks(false);
            return polylineConnectionEx;
        }
        if (conn == CONNECTION_TYPE.CURVES_JUMPS) {
            PolylineConnectionEx polylineConnectionEx = new PolylineConnectionEx();
            polylineConnectionEx.setSmoothness(16);
            polylineConnectionEx.setJumpLinks(true);
            return polylineConnectionEx;
        }
        return new PolylineConnection();
    }

    public static void createConnectionActions(IActionBars iActionBars) {
        iActionBars.getToolBarManager().add((IContributionItem)new Separator(String.valueOf(ConnectionAction.class.getName()) + "Group"));
        MenuAction menuAction = new MenuAction("Connection types");
        menuAction.setId(String.valueOf(ConnectionAction.class.getName()) + "DropDown");
        if (iActionBars.getToolBarManager().find(menuAction.getId()) != null) {
            return;
        }
        menuAction.setImageDescriptor(Activator.getImageDescriptor("icons/connection_menu.gif"));
        iActionBars.getToolBarManager().add((IAction)menuAction);
        CheckableActionGroup checkableActionGroup = new CheckableActionGroup();
        ConnectionAction connectionAction = new ConnectionAction(CONNECTION_TYPE.STRAIGHT);
        if (iActionBars.getToolBarManager().find(connectionAction.getId()) == null) {
            connectionAction.setText("Straight connections");
            connectionAction.setImageDescriptor(Activator.getImageDescriptor("icons/connection_straight.gif"));
            connectionAction.setEnabled(true);
            connectionAction.setChecked(true);
            menuAction.add((IAction)connectionAction);
            checkableActionGroup.add((IAction)connectionAction);
        }
        connectionAction = new ConnectionAction(CONNECTION_TYPE.STRAIGHT_JUMPS);
        if (iActionBars.getToolBarManager().find(connectionAction.getId()) == null) {
            connectionAction.setText("Straight connections with jumps");
            connectionAction.setImageDescriptor(Activator.getImageDescriptor("icons/connection_straight_jumps.gif"));
            connectionAction.setEnabled(true);
            menuAction.add((IAction)connectionAction);
            checkableActionGroup.add((IAction)connectionAction);
        }
        connectionAction = new ConnectionAction(CONNECTION_TYPE.CURVES);
        if (iActionBars.getToolBarManager().find(connectionAction.getId()) == null) {
            connectionAction.setText("Curved connections");
            connectionAction.setImageDescriptor(Activator.getImageDescriptor("icons/connection_curved.gif"));
            connectionAction.setEnabled(true);
            menuAction.add((IAction)connectionAction);
            checkableActionGroup.add((IAction)connectionAction);
        }
        connectionAction = new ConnectionAction(CONNECTION_TYPE.CURVES_JUMPS);
        if (iActionBars.getToolBarManager().find(connectionAction.getId()) == null) {
            connectionAction.setText("Curved connections with jumps");
            connectionAction.setImageDescriptor(Activator.getImageDescriptor("icons/connection_curved_jumps.gif"));
            connectionAction.setEnabled(true);
            menuAction.add((IAction)connectionAction);
            checkableActionGroup.add((IAction)connectionAction);
        }
    }

    public static void createRouterActions(IActionBars iActionBars) {
        iActionBars.getToolBarManager().add((IContributionItem)new Separator(String.valueOf(RouterAction.class.getName()) + "Group"));
        CheckableActionGroup checkableActionGroup = new CheckableActionGroup();
        RouterAction routerAction = new RouterAction(ROUTER_TYPE.SCAMANHATTAN, 1);
        if (iActionBars.getToolBarManager().find(routerAction.getId()) == null) {
            routerAction.setText("Manhattan routing with collision avoidance");
            routerAction.setImageDescriptor(Activator.getImageDescriptor("icons/router_manhattan.gif"));
            routerAction.setEnabled(true);
            iActionBars.getToolBarManager().add((IAction)routerAction);
            checkableActionGroup.add((IAction)routerAction);
        }
        routerAction = new RouterAction(ROUTER_TYPE.DIRECT, 2);
        if (iActionBars.getToolBarManager().find(routerAction.getId()) == null) {
            routerAction.setText("Direct routing");
            routerAction.setImageDescriptor(Activator.getImageDescriptor("icons/router_direct.gif"));
            routerAction.setEnabled(true);
            iActionBars.getToolBarManager().add((IAction)routerAction);
            checkableActionGroup.add((IAction)routerAction);
        }
        routerAction = new RouterAction(ROUTER_TYPE.RECTILINEAR, 3);
        if (iActionBars.getToolBarManager().find(routerAction.getId()) == null) {
            routerAction.setText("Rectilinear router");
            routerAction.setImageDescriptor(Activator.getImageDescriptor("icons/router_manhattan2.gif"));
            routerAction.setEnabled(true);
            iActionBars.getToolBarManager().add((IAction)routerAction);
            checkableActionGroup.add((IAction)routerAction);
        }
    }

    public static enum CONNECTION_TYPE {
        STRAIGHT,
        STRAIGHT_JUMPS,
        CURVES,
        CURVES_JUMPS;

    }

    public static enum ROUTER_TYPE {
        SCAMANHATTAN(null){

            @Override
            public AbstractRouter getRouter(IFigure iFigure) {
                return new SCAManhattanConnectionRouter(iFigure);
            }
        }
        ,
        DIRECT((AbstractRouter)new BendpointConnectionRouter()),
        RECTILINEAR((AbstractRouter)new RectilinearRouter());

        private AbstractRouter router;

        private ROUTER_TYPE(AbstractRouter abstractRouter) {
            this.router = abstractRouter;
        }

        public AbstractRouter getRouter(IFigure iFigure) {
            return this.router;
        }

        public static ROUTER_TYPE getDefaultType() {
            int n = Activator.getDefault().getPreferenceStore().getInt(RouterFactory.ROUTER_PREF);
            switch (n) {
                case 1: {
                    return SCAMANHATTAN;
                }
                case 2: {
                    return DIRECT;
                }
                case 3: {
                    return RECTILINEAR;
                }
            }
            return SCAMANHATTAN;
        }
    }
}

