/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.workbench.model.editor.ui.editor.actions;

import com.isencia.passerelle.workbench.model.editor.ui.views.RenameWizard;
import com.isencia.passerelle.workbench.model.ui.command.RenameCommand;
import java.util.HashMap;
import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import ptolemy.kernel.util.NamedObj;

public class RenameAction
extends SelectionAction {
    public RenameAction(IWorkbenchPart iWorkbenchPart) {
        super(iWorkbenchPart);
        this.setLazyEnablementCalculation(false);
    }

    protected void init() {
        this.setText("Rename...");
        this.setToolTipText("Rename");
        this.setId(ActionFactory.RENAME.getId());
        ImageDescriptor imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"TutoGEF", (String)"icons/rename-icon.png");
        if (imageDescriptor != null) {
            this.setImageDescriptor(imageDescriptor);
        }
        this.setEnabled(false);
    }

    protected boolean calculateEnabled() {
        return true;
    }

    public Command createRenameCommand(String string, NamedObj namedObj) {
        Request request = new Request((Object)"rename");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("newName", string);
        request.setExtendedData(hashMap);
        RenameCommand renameCommand = new RenameCommand(namedObj, string);
        return renameCommand;
    }

    public void run() {
        NamedObj namedObj = this.getSelectedNode();
        RenameWizard renameWizard = new RenameWizard(namedObj.getName());
        WizardDialog wizardDialog = new WizardDialog(this.getWorkbenchPart().getSite().getShell(), (IWizard)renameWizard);
        wizardDialog.create();
        wizardDialog.getShell().setSize(400, 300);
        wizardDialog.setTitle("Rename Actor");
        wizardDialog.setMessage("This is the same as setting the 'Name' attribute in the Actor Attributes view.");
        if (wizardDialog.open() == 0) {
            String string = renameWizard.getRenameValue();
            this.execute(this.createRenameCommand(string, namedObj));
        }
    }

    private NamedObj getSelectedNode() {
        List list = this.getSelectedObjects();
        if (list.isEmpty()) {
            return null;
        }
        if (!(list.get(0) instanceof EditPart)) {
            return null;
        }
        EditPart editPart = (EditPart)list.get(0);
        return (NamedObj)editPart.getModel();
    }
}

