/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.workbench.model.editor.ui.editor.actions;

import com.isencia.passerelle.workbench.model.actor.IPartListenerActor;
import com.isencia.passerelle.workbench.model.actor.IResourceActor;
import com.isencia.passerelle.workbench.model.actor.ResourceObject;
import com.isencia.passerelle.workbench.model.editor.ui.Activator;
import com.isencia.passerelle.workbench.model.editor.ui.editpart.ActorEditPart;
import com.isencia.passerelle.workbench.model.ui.utils.EclipseUtils;
import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.actor.Actor;

public class OpenFileAction
extends SelectionAction {
    private static final Logger logger = LoggerFactory.getLogger(OpenFileAction.class);
    public static String ID1 = String.valueOf(OpenFileAction.class.getName()) + "_actionID1";
    public static String ID2 = String.valueOf(OpenFileAction.class.getName()) + "_actionID2";

    public OpenFileAction(IWorkbenchPart iWorkbenchPart, String string) {
        super(iWorkbenchPart);
        this.setLazyEnablementCalculation(true);
        this.setId(string);
        if (this.getId().equals(ID1)) {
            this.setImageDescriptor(Activator.getImageDescriptor("icons/open_file1.gif"));
        } else {
            this.setImageDescriptor(Activator.getImageDescriptor("icons/open_file2.gif"));
        }
    }

    protected void init() {
        super.init();
        this.setText("");
        this.setEnabled(false);
    }

    protected void setSelection(ISelection iSelection) {
        super.setSelection(iSelection);
        this.refresh();
    }

    public boolean calculateEnabled() {
        this.setText("");
        ResourceObject resourceObject = null;
        try {
            resourceObject = this.getResourceObject();
        }
        catch (Exception exception) {
            logger.error("Cannot get resource!", (Throwable)exception);
            return false;
        }
        if (resourceObject != null) {
            this.setText("Open " + resourceObject.getResourceTypeName());
            return resourceObject.getResource() != null;
        }
        return false;
    }

    public void run() {
        IResourceActor iResourceActor = this.getResourceActor();
        ResourceObject resourceObject = null;
        try {
            resourceObject = this.getResourceObject();
        }
        catch (Exception exception) {
            logger.error("Problem finding resource! " + this.getId(), (Throwable)exception);
        }
        if (resourceObject != null) {
            try {
                if (iResourceActor instanceof IPartListenerActor) {
                    ((IPartListenerActor)iResourceActor).partPreopen(resourceObject);
                }
                Object object = resourceObject.getResource();
                EclipseUtils.getActivePage().saveAllEditors(false);
                IEditorPart iEditorPart = null;
                if (object instanceof IFile) {
                    iEditorPart = resourceObject.getEditorId() != null ? EclipseUtils.openEditor((IFile)((IFile)object), (String)resourceObject.getEditorId()) : EclipseUtils.openEditor((IFile)((IFile)object));
                } else if (object instanceof File) {
                    iEditorPart = resourceObject.getEditorId() != null ? EclipseUtils.openExternalEditor((File)((File)object), (String)resourceObject.getEditorId()) : EclipseUtils.openExternalEditor((File)((File)object));
                }
                if (iResourceActor instanceof IPartListenerActor) {
                    ((IPartListenerActor)iResourceActor).partOpened((IWorkbenchPart)iEditorPart, resourceObject);
                }
            }
            catch (Exception exception) {
                logger.error("Cannot open file " + resourceObject.getResource(), (Throwable)exception);
            }
        }
    }

    private int getResourceNumber() {
        return this.getId() == ID1 ? 0 : 1;
    }

    private ResourceObject getResourceObject() throws Exception {
        IResourceActor iResourceActor = this.getResourceActor();
        if (iResourceActor == null) {
            return null;
        }
        return iResourceActor.getResource(this.getResourceNumber());
    }

    protected IResourceActor getResourceActor() {
        ActorEditPart actorEditPart;
        Actor actor;
        Object object;
        ISelection iSelection = this.getSelection();
        if (iSelection instanceof StructuredSelection && (object = ((StructuredSelection)iSelection).getFirstElement()) instanceof ActorEditPart && (actor = (actorEditPart = (ActorEditPart)object).getActor()) instanceof IResourceActor) {
            IResourceActor iResourceActor = (IResourceActor)actor;
            if (iResourceActor != null) {
                iResourceActor.setMomlResource((IResource)EclipseUtils.getIFile((IEditorInput)((IEditorPart)this.getWorkbenchPart()).getEditorInput()));
            }
            return iResourceActor;
        }
        return null;
    }
}

