/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.workbench.model.editor.ui.editor.actions;

import com.isencia.passerelle.workbench.model.editor.ui.editor.actions.ExecuteActionEvent;
import com.isencia.passerelle.workbench.model.editor.ui.editor.actions.ExecuteActionListener;
import com.isencia.passerelle.workbench.model.editor.ui.editor.actions.ModelChangeEvent;
import com.isencia.passerelle.workbench.model.editor.ui.editor.actions.ModelChangeListener;
import com.isencia.passerelle.workbench.model.jmx.RemoteManagerAgent;
import com.isencia.passerelle.workbench.model.ui.utils.EclipseUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.management.MBeanServerConnection;
import javax.management.Notification;
import javax.management.NotificationListener;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.SubActionBars2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExecutionAction
extends Action {
    private static final Logger logger = LoggerFactory.getLogger(ExecutionAction.class);
    private List<ExecuteActionListener> executeActionListeners;
    private boolean buttonUpdateAllowed = true;
    private static Set<ModelChangeListener> modelChangeListeners;

    protected void addRefreshListener() throws Exception {
        this.addRefreshListener(null);
    }

    protected void addRefreshListener(MBeanServerConnection mBeanServerConnection) throws Exception {
        try {
            if (mBeanServerConnection == null) {
                mBeanServerConnection = RemoteManagerAgent.getServerConnection((long)5000L);
            }
            logger.debug("Client connected = " + mBeanServerConnection);
            if (!mBeanServerConnection.isRegistered(RemoteManagerAgent.REMOTE_MANAGER)) {
                return;
            }
            logger.debug("Adding notification listener");
            mBeanServerConnection.addNotificationListener(RemoteManagerAgent.REMOTE_MANAGER, this.createRefreshListener(), null, (Object)this);
            logger.debug("Added notification listener");
        }
        catch (Exception exception) {
            logger.error("Cannot add listener", (Throwable)exception);
        }
    }

    private NotificationListener createRefreshListener() {
        return new NotificationListener(){

            @Override
            public void handleNotification(Notification notification, Object object) {
                ExecutionAction.this.updateActionsAvailable(1000L);
            }
        };
    }

    protected void updateActionsAvailable(long l) {
        if (!this.buttonUpdateAllowed) {
            return;
        }
        Job job = new Job("Update action bars"){

            public IStatus run(IProgressMonitor iProgressMonitor) {
                IEditorPart iEditorPart = EclipseUtils.getPage().getActiveEditor();
                if (iEditorPart != null) {
                    final SubActionBars2 subActionBars2 = (SubActionBars2)iEditorPart.getEditorSite().getActionBars();
                    logger.debug("Doing refresh of toolbar actions.");
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                ExecutionAction.this.buttonUpdateAllowed = false;
                                subActionBars2.deactivate();
                                subActionBars2.activate(true);
                                ExecutionAction.this.fireButtonRefreshListeners();
                            }
                            finally {
                                ExecutionAction.this.buttonUpdateAllowed = true;
                            }
                        }
                    });
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(false);
        job.setSystem(true);
        job.schedule(l);
    }

    public void addExecuteActionListener(ExecuteActionListener executeActionListener) {
        if (this.executeActionListeners == null) {
            this.executeActionListeners = new ArrayList<ExecuteActionListener>(3);
        }
        this.executeActionListeners.add(executeActionListener);
    }

    protected void fireButtonRefreshListeners() {
        if (this.executeActionListeners == null) {
            return;
        }
        ExecuteActionEvent executeActionEvent = new ExecuteActionEvent((Object)this, this.isEnabled());
        for (ExecuteActionListener executeActionListener : this.executeActionListeners) {
            executeActionListener.buttonRefreshRequested(executeActionEvent);
        }
    }

    protected void fireRunListeners() {
        if (this.executeActionListeners == null) {
            return;
        }
        ExecuteActionEvent executeActionEvent = new ExecuteActionEvent((Object)this, false);
        for (ExecuteActionListener executeActionListener : this.executeActionListeners) {
            executeActionListener.executionRequested(executeActionEvent);
        }
    }

    protected void fireStopListeners() {
        if (this.executeActionListeners == null) {
            return;
        }
        ExecuteActionEvent executeActionEvent = new ExecuteActionEvent((Object)this, false);
        for (ExecuteActionListener executeActionListener : this.executeActionListeners) {
            executeActionListener.stopRequested(executeActionEvent);
        }
    }

    public void removeExecuteActionListener(ExecuteActionListener executeActionListener) {
        if (this.executeActionListeners == null) {
            return;
        }
        this.executeActionListeners.remove(executeActionListener);
    }

    public static void notifyExecutionTerminated(int n) {
        if (modelChangeListeners == null) {
            return;
        }
        for (ModelChangeListener modelChangeListener : modelChangeListeners) {
            modelChangeListener.executionTerminated(new ModelChangeEvent(modelChangeListeners, n));
        }
    }

    public static void notifyExecutionStarted() {
        if (modelChangeListeners == null) {
            return;
        }
        for (ModelChangeListener modelChangeListener : modelChangeListeners) {
            modelChangeListener.executionStarted(new ModelChangeEvent(modelChangeListeners));
        }
    }

    public static void addModelChangeListener(ModelChangeListener modelChangeListener) {
        if (modelChangeListeners == null) {
            modelChangeListeners = new HashSet<ModelChangeListener>(3);
        }
        modelChangeListeners.add(modelChangeListener);
    }
}

