/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.workbench.model.editor.ui.editor.actions;

import com.isencia.passerelle.actor.gui.PasserelleActorControllerFactory;
import com.isencia.passerelle.actor.gui.PasserelleEditorFactory;
import com.isencia.passerelle.actor.gui.PasserelleEditorPaneFactory;
import com.isencia.passerelle.model.Flow;
import com.isencia.passerelle.model.FlowManager;
import com.isencia.passerelle.workbench.model.editor.ui.Activator;
import com.isencia.passerelle.workbench.model.editor.ui.editor.PasserelleModelMultiPageEditor;
import com.isencia.passerelle.workbench.model.editor.ui.editor.actions.SubModelViewUtils;
import com.isencia.passerelle.workbench.model.editor.ui.palette.PaletteItemFactory;
import com.isencia.passerelle.workbench.model.ui.utils.EclipseUtils;
import com.isencia.passerelle.workbench.model.ui.utils.FileUtils;
import com.isencia.passerelle.workbench.model.ui.wizards.NameChecker;
import com.isencia.passerelle.workbench.model.ui.wizards.NameWizard;
import com.isencia.passerelle.workbench.model.utils.ModelUtils;
import com.isencia.passerelle.workbench.model.utils.SubModelUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.actor.CompositeActor;
import ptolemy.kernel.Entity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.NamedObj;

public class CreateSubModelAction
extends SelectionAction
implements NameChecker {
    private static final Logger logger = LoggerFactory.getLogger(CreateSubModelAction.class);
    private PasserelleModelMultiPageEditor parent;
    private final String icon = "icons/flow.png";
    public static String CREATE_SUBMODEL = "createSubModel";

    public CreateSubModelAction() {
        this(null, null);
        this.setId(ActionFactory.NEW.getId());
    }

    public CreateSubModelAction(IEditorPart iEditorPart) {
        this(iEditorPart, null);
        this.setId(ActionFactory.NEW.getId());
    }

    public CreateSubModelAction(IEditorPart iEditorPart, PasserelleModelMultiPageEditor passerelleModelMultiPageEditor) {
        super((IWorkbenchPart)iEditorPart);
        this.parent = passerelleModelMultiPageEditor;
        this.setLazyEnablementCalculation(true);
        if (passerelleModelMultiPageEditor != null) {
            this.setId(ActionFactory.EXPORT.getId());
        }
    }

    protected void init() {
        super.init();
        Activator.getImageDescriptor("icons/flow.png");
        this.setHoverImageDescriptor(Activator.getImageDescriptor("icons/flow.png"));
        this.setImageDescriptor(Activator.getImageDescriptor("icons/flow.png"));
        this.setDisabledImageDescriptor(Activator.getImageDescriptor("icons/flow.png"));
        this.setEnabled(false);
    }

    public void run() {
        try {
            if (this.parent != null) {
                CompositeActor compositeActor = this.parent.getSelectedContainer();
                String string = this.getName(compositeActor.getName());
                if (string != null) {
                    compositeActor.setName(string);
                    this.exportEntityToClassFile((Entity)compositeActor);
                    this.parent.getActorTreeViewPage().refresh();
                }
            } else {
                String string = this.getName("emptyComposite");
                if (string != null) {
                    IProject iProject = ModelUtils.getPasserelleProject();
                    File file = new File(String.valueOf(iProject.getLocation().toOSString()) + "/" + string + ".moml");
                    InputStream inputStream = ModelUtils.getEmptyCompositeStream((String)file.getAbsolutePath());
                    FileUtils.write((InputStream)inputStream, (OutputStream)new FileOutputStream(file));
                    PaletteItemFactory paletteItemFactory = PaletteItemFactory.getInstance();
                    Flow flow = FlowManager.readMoml((Reader)new FileReader(file));
                    flow.setName(string);
                    paletteItemFactory.addSubModel(flow);
                    SubModelUtils.addSubModel((Flow)flow);
                    IFile iFile = iProject.getFile(String.valueOf(string) + ".moml");
                    EclipseUtils.openEditor((IFile)iFile, (String)"com.isencia.passerelle.workbench.model.editor.ui.editors.modelEditor");
                    SubModelViewUtils.refreshPallette();
                }
            }
        }
        catch (Exception exception) {
            logger.error("Cannot export sub-model", (Throwable)exception);
        }
    }

    private String getName(String string) {
        NameWizard nameWizard = new NameWizard(string, (NameChecker)this);
        WizardDialog wizardDialog = new WizardDialog(Display.getCurrent().getActiveShell(), (IWizard)nameWizard);
        wizardDialog.create();
        wizardDialog.getShell().setSize(400, 300);
        wizardDialog.setTitle("Name of Composite");
        wizardDialog.setMessage("Please choose a unique name for your exported composite.");
        if (wizardDialog.open() == 0) {
            return nameWizard.getRenameValue();
        }
        return null;
    }

    public Entity exportEntityToClassFile(Entity entity) throws Exception {
        Object object;
        Object object2;
        Object object3;
        IProject iProject;
        Entity entity2 = (Entity)entity.clone(entity.workspace());
        entity2.setClassDefinition(true);
        if (entity2 instanceof CompositeActor) {
            iProject = (CompositeActor)entity2;
            object3 = iProject.getDirector();
            if (object3 != null) {
                object3.setContainer(null);
            }
            if ((object2 = iProject.getAttribute("_controllerFactory")) == null) {
                new PasserelleActorControllerFactory((NamedObj)iProject, "_controllerFactory");
            } else if (!(object2 instanceof PasserelleActorControllerFactory)) {
                object2.setContainer(null);
                new PasserelleActorControllerFactory((NamedObj)iProject, "_controllerFactory");
            }
            object = iProject.getAttribute("_editorFactory");
            if (object == null) {
                new PasserelleEditorFactory((NamedObj)iProject, "_editorFactory");
            } else if (!(object instanceof PasserelleEditorFactory)) {
                object.setContainer(null);
                new PasserelleEditorFactory((NamedObj)iProject, "_editorFactory");
            }
            Attribute attribute = iProject.getAttribute("_editorPaneFactory");
            if (attribute == null) {
                new PasserelleEditorPaneFactory((NamedObj)iProject, "_editorPaneFactory");
            } else if (!(attribute instanceof PasserelleEditorPaneFactory)) {
                attribute.setContainer(null);
                new PasserelleEditorPaneFactory((NamedObj)iProject, "_editorPaneFactory");
            }
        }
        iProject = ModelUtils.getPasserelleProject();
        object3 = new File(String.valueOf(iProject.getLocation().toOSString()) + "/" + entity2.getName() + ".moml");
        object2 = entity2.getName();
        object = ((File)object3).getName();
        int n = ((String)object).indexOf(".");
        object2 = n > 0 ? ((String)object).substring(0, n) : object;
        FileWriter fileWriter = new FileWriter((File)object3);
        try {
            if (entity2.getContainer() != null) {
                fileWriter.write("<?xml version=\"1.0\" standalone=\"no\"?>\n<!DOCTYPE " + entity2.getElementName() + " PUBLIC " + "\"-//UC Berkeley//DTD MoML 1//EN\"\n" + "    \"http://ptolemy.eecs.berkeley.edu" + "/xml/dtd/MoML_1.dtd\">\n");
            }
            entity2.exportMoML((Writer)fileWriter, 0, (String)object2);
        }
        finally {
            fileWriter.close();
        }
        PaletteItemFactory paletteItemFactory = PaletteItemFactory.getInstance();
        Flow flow = FlowManager.readMoml((Reader)new FileReader((File)object3));
        paletteItemFactory.addSubModel(flow);
        SubModelUtils.addSubModel((Flow)flow);
        return entity2;
    }

    protected boolean calculateEnabled() {
        return true;
    }

    public boolean isNameValid(String string) {
        return !SubModelUtils.isSubModel((String)string);
    }

    public String getErrorMessage(String string) {
        if (SubModelUtils.isSubModel((String)string)) {
            return "'" + string + "' is already existing as a composite.";
        }
        return null;
    }
}

