/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.workbench.model.editor.ui.editor;

import com.isencia.passerelle.workbench.model.editor.ui.Activator;
import com.isencia.passerelle.workbench.model.editor.ui.editor.PasserelleModelMultiPageEditor;
import com.isencia.passerelle.workbench.model.editor.ui.editor.WizardModelEditor;
import com.isencia.passerelle.workbench.model.ui.utils.EclipseUtils;
import com.teaminabox.eclipse.wiki.editors.WikiBrowser;
import com.teaminabox.eclipse.wiki.editors.WikiEditor;
import java.lang.reflect.Field;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WizardWorkflowEditor
extends PasserelleModelMultiPageEditor
implements IReusableEditor {
    private static Logger logger = LoggerFactory.getLogger(WizardWorkflowEditor.class);
    public static final String ID = "com.isencia.passerelle.workbench.model.editor.ui.editors.wizardEditor";
    private WizardModelEditor wizEd;
    private boolean subPagesActive = false;
    private WikiEditor wikiEditor;
    private WikiBrowser wikiBrowser;

    @Override
    protected void createPages() {
        this.subPagesActive = false;
        try {
            this.createWizardPage(0);
            this.createWorkflowPage(1);
            this.createXmlPage(2);
            this.createDocPage(3);
        }
        catch (Exception exception) {
            logger.error("Cannot open passerelle editor " + this.getEditorInput().getName(), (Throwable)exception);
        }
        this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    int n = Activator.getDefault().getPreferenceStore().getInt(WizardWorkflowEditor.this.getPageKey());
                    if (n > -1 && n < WizardWorkflowEditor.this.getPageCount()) {
                        WizardWorkflowEditor.this.setActivePage(n);
                    }
                    EclipseUtils.getActivePage().showView("com.isencia.passerelle.workbench.model.editor.ui.views.ActorAttributesView");
                    EclipseUtils.getActivePage().activate((IWorkbenchPart)WizardWorkflowEditor.this);
                }
                catch (Throwable throwable) {}
            }
        });
    }

    protected String getPageKey() {
        return "com.isencia.passerelle.workbench.model.editor.ui.editors.wizardEditor.selectedPage." + this.getEditorInput().getName();
    }

    protected void initializePageSwitching() {
        super.initializePageSwitching();
        this.subPagesActive = true;
    }

    private void createWizardPage(int n) throws PartInitException {
        this.wizEd = new WizardModelEditor();
        this.addPage((IEditorPart)this.wizEd, this.getEditorInput());
        this.setPageText(n, "Run");
        this.pages.add(this.wizEd);
    }

    protected void createDocPage(int n) throws Exception {
        String string = this.getEditorInput().getName();
        int n2 = string.toLowerCase().lastIndexOf(".moml");
        String string2 = string.substring(0, n2);
        IFile iFile = EclipseUtils.getIFile((IEditorInput)this.getEditorInput());
        String string3 = String.valueOf(string2) + ".wiki";
        IResource iResource = iFile.getParent().findMember(string3);
        if (iResource != null && iResource.exists() && iResource instanceof IFile) {
            this.wikiEditor = new WikiEditor();
            this.wikiEditor.setReusableEditor((IReusableEditor)this);
            this.addPage(n, (IEditorPart)this.wikiEditor, this.createWikiInput((IFile)iResource));
            this.setPageText(n, "Edit Documentation");
            this.wikiBrowser = new WikiBrowser(this.wikiEditor);
            Composite composite = new Composite(this.getContainer(), 0);
            composite.setLayout((Layout)new FillLayout());
            this.wikiBrowser.createPartControl(composite);
            this.addPage(n, (Control)composite);
            this.setPageText(n, "Documentation");
            this.wikiBrowser.redrawWebView();
            this.pages.add(composite);
            this.pages.add(this.wikiEditor);
            Field field = MultiPageEditorPart.class.getDeclaredField("container");
            try {
                field.setAccessible(true);
                CTabFolder cTabFolder = (CTabFolder)field.get((Object)this);
                CTabItem cTabItem = cTabFolder.getItem(n + 1);
                cTabItem.dispose();
            }
            finally {
                field.setAccessible(false);
            }
        }
    }

    private IEditorInput createWikiInput(IFile iFile) {
        return new FileEditorInput(iFile);
    }

    @Override
    public void setActorSelected(String string, boolean bl, int n) {
        this.wizEd.setActorSelected(string, bl, n);
        super.setActorSelected(string, bl, n);
    }

    @Override
    public void pageChange(int n) {
        super.pageChange(n);
        if (!this.subPagesActive) {
            return;
        }
        if (EclipseUtils.getActivePage() == null) {
            return;
        }
        if (!EclipseUtils.getActivePage().isEditorAreaVisible()) {
            return;
        }
        if (n == 0) {
            try {
                EclipseUtils.getActivePage().showView("org.eclipse.ui.navigator.ProjectExplorer");
            }
            catch (Throwable throwable) {
                logger.error("Cannot select actor tree view!");
            }
        }
        Activator.getDefault().getPreferenceStore().setValue(this.getPageKey(), n);
    }

    @Override
    public void setPasserelleEditorActive() {
        this.setActivePage(1);
    }

    @Override
    public void setInput(IEditorInput iEditorInput) {
        if (iEditorInput.getName().toLowerCase().endsWith(".moml")) {
            super.setInput(iEditorInput);
        } else if (iEditorInput.getName().toLowerCase().endsWith(".wiki") && this.wikiEditor != null) {
            this.wikiEditor.setInput(iEditorInput);
            this.wikiBrowser.redrawWebView();
        }
    }
}

