/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.workbench.model.editor.ui.editor;

import com.isencia.passerelle.workbench.model.editor.ui.editor.actions.ExecuteActionEvent;
import com.isencia.passerelle.workbench.model.editor.ui.editor.actions.ExecuteActionListener;
import com.isencia.passerelle.workbench.model.editor.ui.editor.actions.RunAction;
import com.isencia.passerelle.workbench.model.editor.ui.editor.actions.StopAction;
import com.swtdesigner.ResourceManager;
import com.swtdesigner.SWTResourceManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.part.EditorPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WizardModelEditor
extends EditorPart
implements ExecuteActionListener {
    private static final Logger logger = LoggerFactory.getLogger(WizardModelEditor.class);
    public static final String ID = "com.isencia.passerelle.workbench.model.editor.ui.editor.WizardModelEditor";
    private final FormToolkit formToolkit = new FormToolkit(Display.getDefault());
    private Text actorText;
    private RunAction runAction;
    private StopAction stopAction;
    private Button btnStart;
    private Button btnStop;
    private Form frmRunWorkflow;

    public void init(IEditorSite iEditorSite, IEditorInput iEditorInput) throws PartInitException {
        this.setSite((IWorkbenchPartSite)iEditorSite);
        this.setInput(iEditorInput);
        this.setPartName(iEditorInput.getName());
    }

    public void createPartControl(Composite composite) {
        IToolBarManager iToolBarManager = this.getEditorSite().getActionBars().getToolBarManager();
        ActionContributionItem actionContributionItem = (ActionContributionItem)iToolBarManager.find(RunAction.class.getName());
        ActionContributionItem actionContributionItem2 = (ActionContributionItem)iToolBarManager.find(StopAction.class.getName());
        this.runAction = (RunAction)actionContributionItem.getAction();
        this.stopAction = (StopAction)actionContributionItem2.getAction();
        this.runAction.addExecuteActionListener(this);
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new FillLayout(256));
        this.frmRunWorkflow = this.formToolkit.createForm(composite2);
        this.formToolkit.paintBordersFor((Composite)this.frmRunWorkflow);
        this.frmRunWorkflow.setText("Run '" + this.getEditorInput().getName() + "'");
        Label label = this.formToolkit.createLabel(this.frmRunWorkflow.getBody(), "Please use the start and stop buttons for running this workflow.", 0);
        label.setForeground(SWTResourceManager.getColor(16));
        label.setFont(SWTResourceManager.getFont("Sans", 10, 0));
        label.setBounds(10, 10, 554, 17);
        final Section section = this.formToolkit.createSection(this.frmRunWorkflow.getBody(), 258);
        section.setBounds(10, 129, 740, 142);
        this.formToolkit.paintBordersFor((Composite)section);
        section.setText("Progress");
        this.actorText = this.formToolkit.createText((Composite)section, "", 584);
        section.setClient((Control)this.actorText);
        section.setExpanded(true);
        final Section section2 = this.formToolkit.createSection(this.frmRunWorkflow.getBody(), 258);
        section2.setBounds(10, 54, 740, 59);
        this.formToolkit.paintBordersFor((Composite)section2);
        section2.setText("Controls");
        section2.setExpanded(true);
        Composite composite3 = this.formToolkit.createComposite((Composite)section2, 0);
        this.formToolkit.paintBordersFor(composite3);
        section2.setClient((Control)composite3);
        this.btnStart = this.formToolkit.createButton(composite3, "Start", 0);
        this.btnStart.setImage(ResourceManager.getPluginImage("com.isencia.passerelle.workbench.model.editor.ui", "icons/run_workflow.gif"));
        this.btnStart.setBounds(10, 0, 88, 29);
        this.btnStart.setEnabled(this.runAction.isEnabled());
        this.btnStart.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                WizardModelEditor.this.runModel();
            }
        });
        this.btnStop = this.formToolkit.createButton(composite3, "Stop", 0);
        this.btnStop.setImage(ResourceManager.getPluginImage("com.isencia.passerelle.workbench.model.editor.ui", "icons/stop_workflow.gif"));
        this.btnStop.setBounds(104, 0, 88, 29);
        this.btnStop.setEnabled(this.stopAction.isEnabled());
        this.btnStop.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                WizardModelEditor.this.stopModel();
            }
        });
        section2.layout(section2.getChildren());
        composite2.layout(composite2.getChildren());
        section2.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                section2.setExpanded(true);
                section.setExpanded(true);
            }
        });
    }

    public void dispose() {
        this.formToolkit.dispose();
        this.runAction.removeExecuteActionListener(this);
        this.runAction = null;
        this.stopAction = null;
    }

    public void setFocus() {
        this.frmRunWorkflow.setFocus();
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void doSave(IProgressMonitor iProgressMonitor) {
    }

    public void doSaveAs() {
    }

    private void runModel() {
        this.btnStart.setEnabled(false);
        this.btnStop.setEnabled(true);
        this.runAction.run();
    }

    private void stopModel() {
        this.stopAction.run();
        this.btnStart.setEnabled(true);
        this.btnStop.setEnabled(false);
    }

    @Override
    public void buttonRefreshRequested(ExecuteActionEvent executeActionEvent) {
        this.btnStart.setEnabled(this.runAction.isEnabled());
        this.btnStop.setEnabled(this.stopAction.isEnabled());
    }

    public void setActorSelected(String string, boolean bl, int n) {
        if (string == null) {
            return;
        }
        if (this.actorText == null || this.actorText.isDisposed()) {
            return;
        }
        this.actorText.append("'");
        this.actorText.append(string);
        this.actorText.append("'");
        if (bl) {
            this.actorText.append(", Running");
        } else {
            this.actorText.append(", Completed");
        }
        this.actorText.append("\n");
    }

    @Override
    public void executionRequested(ExecuteActionEvent executeActionEvent) {
        this.actorText.setText("");
    }

    @Override
    public void stopRequested(ExecuteActionEvent executeActionEvent) {
        this.actorText.append("Workflow stopped");
    }
}

