/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.workbench.model.editor.ui.editor;

import com.isencia.passerelle.workbench.model.editor.ui.palette.PaletteBuilder;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.ui.palette.PaletteCustomizer;
import org.eclipse.gef.ui.palette.PaletteMessages;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.gef.ui.palette.customize.PaletteDrawerFactory;
import org.eclipse.gef.ui.palette.customize.PaletteSeparatorFactory;
import org.eclipse.gef.ui.palette.customize.PaletteStackFactory;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PasserellePaletteCustomizer
extends PaletteCustomizer {
    private static Logger logger = LoggerFactory.getLogger(PasserellePaletteCustomizer.class);
    PaletteViewer paletteViewer;

    public PasserellePaletteCustomizer(PaletteViewer paletteViewer) {
        this.paletteViewer = paletteViewer;
        this.paletteViewer.setCustomizer((PaletteCustomizer)this);
    }

    public List getNewEntryFactories() {
        ArrayList<Object> arrayList = new ArrayList<Object>(4);
        arrayList.add(new PaletteSeparatorFactory());
        arrayList.add(new PaletteStackFactory());
        arrayList.add(new PaletteDrawerFactory(){

            protected PaletteEntry createNewEntry(Shell shell) {
                PaletteContainer paletteContainer = PaletteBuilder.createFavoriteContainer(PaletteMessages.NEW_DRAWER_LABEL);
                PaletteBuilder.addFavoriteGroup(paletteContainer.getLabel(), (PaletteEntry)paletteContainer);
                return paletteContainer;
            }
        });
        return arrayList;
    }

    public void revertToSaved() {
    }

    public void save() {
        try {
            PaletteBuilder.synchFavorites(this.paletteViewer);
        }
        catch (Exception exception) {
            logger.error("Cannot sync favourites!", (Throwable)exception);
        }
    }
}

