/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.workbench.model.editor.ui.editor;

import com.isencia.passerelle.model.Flow;
import com.isencia.passerelle.workbench.model.editor.ui.palette.PaletteBuilder;
import com.isencia.passerelle.workbench.model.editor.ui.palette.PaletteItemFactory;
import com.isencia.passerelle.workbench.model.editor.ui.palette.SubModelPaletteItemDefinition;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.gef.internal.ui.palette.editparts.DrawerEditPart;
import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaletteMouseListener
implements MouseMotionListener {
    private static Logger logger = LoggerFactory.getLogger(PaletteMouseListener.class);
    private DrawerEditPart drawerFigure;
    private PaletteViewer paletteViewer;

    public PaletteMouseListener(DrawerEditPart drawerEditPart, PaletteViewer paletteViewer) {
        this.drawerFigure = drawerEditPart;
        this.paletteViewer = paletteViewer;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        try {
            this.addFavorite();
        }
        catch (Exception exception) {
            logger.error("Cannot add favourite!", (Throwable)exception);
        }
    }

    private void addFavorite() throws Exception {
        PaletteItemFactory paletteItemFactory = PaletteItemFactory.getInstance();
        CreationFactory creationFactory = paletteItemFactory.getSelectedItem();
        if (creationFactory != null) {
            Class clazz = (Class)creationFactory.getObjectType();
            this.drawerFigure.getDrawer().getLabel();
            if (clazz.equals(Flow.class)) {
                SubModelPaletteItemDefinition subModelPaletteItemDefinition = (SubModelPaletteItemDefinition)creationFactory.getNewObject();
                paletteItemFactory.addFavorite(subModelPaletteItemDefinition.getName(), (PaletteContainer)PaletteBuilder.getFavoriteGroup(this.drawerFigure.getDrawer().getLabel()));
            } else {
                paletteItemFactory.addFavorite(clazz.getName(), (PaletteContainer)PaletteBuilder.getFavoriteGroup(this.drawerFigure.getDrawer().getLabel()));
            }
            PaletteBuilder.synchFavorites(this.paletteViewer);
            paletteItemFactory.setSelectedItem(null);
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseHover(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }
}

