/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.workbench.model.editor.ui.dnd;

import com.isencia.passerelle.workbench.model.editor.ui.dnd.DefaultDropClassFactory;
import com.isencia.passerelle.workbench.model.editor.ui.dnd.IDropClassFactory;
import com.isencia.passerelle.workbench.model.editor.ui.palette.ClassTypeFactory;
import com.isencia.passerelle.workbench.model.ui.command.CreateComponentCommand;
import com.isencia.passerelle.workbench.model.ui.utils.EclipseUtils;
import java.io.File;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.dnd.AbstractTransferDropTargetListener;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.IContributorResourceAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.data.expr.FileParameter;
import ptolemy.kernel.util.NamedObj;

public class FileTransferDropTargetListener
extends AbstractTransferDropTargetListener {
    private IDropClassFactory dropFactory;
    private static final Logger logger = LoggerFactory.getLogger(FileTransferDropTargetListener.class);
    private boolean isFullPath = false;
    private boolean isFolder = false;

    public FileTransferDropTargetListener(EditPartViewer editPartViewer, Transfer transfer) {
        super(editPartViewer, transfer);
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor("com.isencia.passerelle.workbench.model.editor.ui.dropFactory");
        if (iConfigurationElementArray != null && iConfigurationElementArray.length >= 1) {
            try {
                this.dropFactory = (IDropClassFactory)iConfigurationElementArray[0].createExecutableExtension("class");
            }
            catch (CoreException coreException) {
                logger.error("Cannot create class from " + iConfigurationElementArray[0], (Throwable)coreException);
                this.dropFactory = new DefaultDropClassFactory();
            }
        } else {
            this.dropFactory = new DefaultDropClassFactory();
        }
    }

    public FileTransferDropTargetListener(EditPartViewer editPartViewer) {
        this(editPartViewer, (Transfer)FileTransfer.getInstance());
    }

    protected void updateTargetRequest() {
        CreateRequest createRequest = (CreateRequest)this.getTargetRequest();
        if (createRequest == null) {
            return;
        }
        createRequest.setLocation(this.getDropLocation());
    }

    protected Request createTargetRequest() {
        CreateRequest createRequest = new CreateRequest();
        Class<? extends NamedObj> clazz = this.dropFactory.getClassForPath(this.getSelected(), this.getFilePath());
        if (clazz == null) {
            return null;
        }
        ClassTypeFactory classTypeFactory = new ClassTypeFactory(clazz, this.getFileName());
        createRequest.setFactory((CreationFactory)classTypeFactory);
        return createRequest;
    }

    private String getFilePath() {
        Object object;
        DropTargetEvent dropTargetEvent = this.getCurrentEvent();
        if (dropTargetEvent != null && dropTargetEvent.data != null) {
            String string = ((String[])dropTargetEvent.data)[0];
            if (this.isFullPath) {
                return string;
            }
            String string2 = ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString();
            return string.substring(string2.length() + 1, string.length()).replace('\\', '/');
        }
        IResource iResource = this.getSelected();
        String string = null;
        if (iResource == null) {
            object = this.getSelectedFile();
            if (!((File)object).isDirectory()) {
                object = ((File)object).getParentFile();
            }
            string = ((File)object).getAbsolutePath();
        } else {
            string = iResource.getRawLocation().toOSString();
        }
        if (string != null) {
            this.isFullPath = iResource != null ? iResource.isLinked(512) : true;
            boolean bl = this.isFolder = iResource != null ? iResource instanceof IContainer : true;
            if (this.isFullPath) {
                return string;
            }
            object = ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString();
            int n = ((String)object).length() + 1;
            return string.substring(n, string.length()).replace('\\', '/');
        }
        return null;
    }

    private IResource getSelected() {
        ISelection iSelection = EclipseUtils.getPage().getSelection();
        if (!(iSelection instanceof IStructuredSelection)) {
            return null;
        }
        IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
        Object object = iStructuredSelection.getFirstElement();
        if (object instanceof IResource) {
            return (IResource)object;
        }
        if (object instanceof IContributorResourceAdapter) {
            return ((IContributorResourceAdapter)object).getAdaptedResource((IAdaptable)object);
        }
        return null;
    }

    private File getSelectedFile() {
        ISelection iSelection = EclipseUtils.getPage().getSelection();
        if (!(iSelection instanceof IStructuredSelection)) {
            return null;
        }
        IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
        Object object = iStructuredSelection.getFirstElement();
        if (object instanceof File) {
            return (File)object;
        }
        return null;
    }

    private String getFileName() {
        String string = this.getFilePath();
        if (string == null) {
            return null;
        }
        return new Path(string).lastSegment();
    }

    protected Command getCommand() {
        Command command = this.getTargetEditPart().getCommand(this.getTargetRequest());
        if (command instanceof CreateComponentCommand) {
            CreateComponentCommand createComponentCommand = (CreateComponentCommand)command;
            createComponentCommand.addConfigurableParameterValue((Object)"Relative Path", (Object)(!this.isFullPath ? 1 : 0));
            createComponentCommand.addConfigurableParameterValue((Object)"Folder", (Object)this.isFolder);
            createComponentCommand.addConfigurableParameterValue(FileParameter.class, (Object)this.getFilePath());
            DropTargetEvent dropTargetEvent = this.getCurrentEvent();
            if (dropTargetEvent != null && dropTargetEvent.data != null) {
                String string = ((String[])dropTargetEvent.data)[0];
                this.dropFactory.setConfigurableParameters(createComponentCommand, string);
            }
        }
        return command;
    }

    protected void handleDragOver() {
        this.getCurrentEvent().detail = 1;
        super.handleDragOver();
    }
}

