/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.workbench.model.editor.ui.descriptor;

import com.isencia.passerelle.util.ptolemy.RegularExpressionParameter;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class RegularExpressionDescriptor
extends PropertyDescriptor {
    private RegularExpressionParameter param;

    public String getDisplayName() {
        return super.getDisplayName();
    }

    public RegularExpressionDescriptor(RegularExpressionParameter regularExpressionParameter) {
        super((Object)regularExpressionParameter.getName(), regularExpressionParameter.getDisplayName());
        this.param = regularExpressionParameter;
    }

    public CellEditor createPropertyEditor(Composite composite) {
        final TextCellEditor textCellEditor = new TextCellEditor(composite);
        textCellEditor.setValidator(new ICellEditorValidator(){

            public String isValid(Object object) {
                Text text = (Text)textCellEditor.getControl();
                text.setForeground(text.getDisplay().getSystemColor(2));
                if (object instanceof String) {
                    String string = (String)object;
                    if (RegularExpressionDescriptor.this.isLegalExpression(string)) {
                        text.setForeground(text.getDisplay().getSystemColor(9));
                    } else {
                        text.setForeground(text.getDisplay().getSystemColor(3));
                    }
                    return null;
                }
                return "Invalid - must be string";
            }
        });
        return textCellEditor;
    }

    protected boolean isLegalExpression(String string) {
        if (string == null || "".equals(string)) {
            return false;
        }
        if (this.param.isRegularExpression()) {
            try {
                Pattern.compile(string);
                return true;
            }
            catch (PatternSyntaxException patternSyntaxException) {
                return false;
            }
        }
        return true;
    }
}

