/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.workbench.model.editor.ui.cell;

import com.isencia.passerelle.actor.Actor;
import com.isencia.passerelle.util.ptolemy.ResourceParameter;
import com.isencia.passerelle.workbench.model.editor.ui.cell.DialogBrowserEditor;
import com.isencia.passerelle.workbench.model.utils.ModelUtils;
import com.isencia.passerelle.workbench.util.ResourceUtils;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.ui.dialogs.WorkspaceResourceDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.data.BooleanToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Settable;

public class ResourceBrowserEditor
extends DialogBrowserEditor {
    private static final Logger logger = LoggerFactory.getLogger(ResourceBrowserEditor.class);
    protected String stringValue = "";
    protected ResourceParameter param;

    public ResourceBrowserEditor(Composite composite, ResourceParameter resourceParameter) {
        super(composite);
        this.param = resourceParameter;
    }

    @Override
    protected Object openDialogBox(Control control, Object object) {
        Object object2;
        IResource iResource = null;
        try {
            iResource = this.getSelectedResource((String)object);
        }
        catch (Exception exception) {
            logger.error("Cannot get resource!", (Throwable)exception);
        }
        Actor actor = (Actor)this.param.getContainer();
        Parameter parameter = (Parameter)actor.getAttribute("Folder");
        Parameter parameter2 = (Parameter)actor.getAttribute("Relative Path");
        boolean bl = false;
        try {
            bl = this.param.getResourceType() == 2 ? true : (parameter == null ? (iResource != null ? iResource instanceof IContainer : false) : ((BooleanToken)parameter.getToken()).booleanValue());
        }
        catch (IllegalActionException illegalActionException) {
            logger.error("Cannot read folder parameter", (Throwable)illegalActionException);
        }
        IContainer iContainer = null;
        if (bl) {
            object2 = WorkspaceResourceDialog.openFolderSelection((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)"Choose folder in workspace", (String)"Please choose a folder from the workspace.\nIf your folder is outside please import the file to a project first.\nNote that if you want this node to be a file set the 'Folder' parameter to false.", (boolean)false, (Object[])new Object[]{iResource}, null);
            if (object2 != null && ((IContainer[])object2).length > 0) {
                iContainer = object2[0];
            }
        } else {
            object2 = WorkspaceResourceDialog.openFileSelection((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)"Choose file in workspace", (String)"Please choose a file from the workspace.\nIf your file is outside please import the file to a project first.\nNote that if you want this node to be a folder set the 'Folder' parameter to true.", (boolean)false, (Object[])new Object[]{iResource}, null);
            if (object2 != null && ((IContainer[])object2).length > 0) {
                iContainer = object2[0];
            }
        }
        if (iContainer == null) {
            return object;
        }
        object2 = iContainer.getRawLocation().toOSString();
        if (iContainer.isLinked(512)) {
            if (parameter2 != null) {
                try {
                    parameter2.setToken((Token)new BooleanToken(false));
                }
                catch (IllegalActionException illegalActionException) {
                    logger.error("Cannot set Relative Path parameter to false", (Throwable)illegalActionException);
                }
            }
            return ((String)object2).replace('\\', '/');
        }
        try {
            if (parameter2 != null) {
                parameter2.setToken((Token)new BooleanToken(true));
            }
        }
        catch (IllegalActionException illegalActionException) {
            logger.error("Cannot set Relative Path parameter to false", (Throwable)illegalActionException);
        }
        String string = ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString();
        return ((String)object2).substring(string.length(), ((String)object2).length()).replace('\\', '/');
    }

    private IResource getSelectedResource(String string) throws Exception {
        if (string != null) {
            Actor actor = (Actor)this.param.getContainer();
            String string2 = ModelUtils.substitute((String)string, (NamedObj)actor);
            return ResourceUtils.getResource((String)string2);
        }
        return ResourceUtils.getResource((Settable)this.param);
    }
}

