/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.workbench.model.editor.ui.cell;

import java.text.MessageFormat;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public abstract class DialogBrowserEditor
extends TextCellEditor {
    private Button button;
    private FocusListener buttonFocusListener;

    public DialogBrowserEditor(Composite composite) {
        super(composite);
    }

    protected Control createControl(Composite composite) {
        final Composite composite2 = new Composite(composite, this.getStyle());
        composite2.setFont(composite.getFont());
        composite2.setBackground(composite.getBackground());
        composite2.setLayout((Layout)new DialogCellLayout());
        super.createControl(composite2);
        this.text.setLayoutData((Object)new GridData(16384, 0x1000000, true, true));
        this.button = this.createButton(composite2);
        this.button.setFont(composite2.getFont());
        this.button.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        this.button.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.character == '\u001b') {
                    DialogBrowserEditor.this.fireCancelEditor();
                }
            }
        });
        this.button.addFocusListener(this.getButtonFocusListener());
        this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DialogBrowserEditor.this.button.removeFocusListener(DialogBrowserEditor.this.getButtonFocusListener());
                Object object = DialogBrowserEditor.this.openDialogBox((Control)composite2, DialogBrowserEditor.this.doGetValue());
                DialogBrowserEditor.this.button.addFocusListener(DialogBrowserEditor.this.getButtonFocusListener());
                if (object != null) {
                    boolean bl = DialogBrowserEditor.this.isCorrect(object);
                    if (bl) {
                        DialogBrowserEditor.this.markDirty();
                        DialogBrowserEditor.this.doSetValue(object);
                    } else {
                        DialogBrowserEditor.this.setErrorMessage(MessageFormat.format(DialogBrowserEditor.this.getErrorMessage(), object.toString()));
                    }
                    DialogBrowserEditor.this.fireApplyEditorValue();
                }
            }
        });
        this.setValueValid(true);
        return composite2;
    }

    protected Button createButton(Composite composite) {
        Button button = new Button(composite, 1024);
        button.setText("...");
        return button;
    }

    private FocusListener getButtonFocusListener() {
        if (this.buttonFocusListener == null) {
            this.buttonFocusListener = new FocusListener(){

                public void focusGained(FocusEvent focusEvent) {
                }

                public void focusLost(FocusEvent focusEvent) {
                    DialogBrowserEditor.this.focusLost();
                }
            };
        }
        return this.buttonFocusListener;
    }

    protected abstract Object openDialogBox(Control var1, Object var2);

    protected void focusLost() {
        if (this.text.isFocusControl() || this.button.isFocusControl()) {
            return;
        }
        if (this.isActivated()) {
            this.fireApplyEditorValue();
            this.deactivate();
        }
    }

    private class DialogCellLayout
    extends Layout {
        private DialogCellLayout() {
        }

        public void layout(Composite composite, boolean bl) {
            Rectangle rectangle = composite.getClientArea();
            Point point = DialogBrowserEditor.this.button.computeSize(-1, -1, bl);
            if (DialogBrowserEditor.this.text != null) {
                DialogBrowserEditor.this.text.setBounds(0, 0, rectangle.width - point.x, rectangle.height);
            }
            DialogBrowserEditor.this.button.setBounds(rectangle.width - point.x, 0, point.x, rectangle.height);
        }

        public Point computeSize(Composite composite, int n, int n2, boolean bl) {
            if (n != -1 && n2 != -1) {
                return new Point(n, n2);
            }
            Point point = DialogBrowserEditor.this.text.computeSize(-1, -1, bl);
            Point point2 = DialogBrowserEditor.this.button.computeSize(-1, -1, bl);
            Point point3 = new Point(point2.x, Math.max(point.y, point2.y));
            return point3;
        }
    }
}

