/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.workbench.model.editor.ui;

import com.isencia.passerelle.workbench.model.editor.ui.editor.PaletteMouseListener;
import com.isencia.passerelle.workbench.model.editor.ui.editpart.DiagramEditPart;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.internal.ui.palette.editparts.DrawerEditPart;
import org.eclipse.gef.internal.ui.palette.editparts.DrawerFigure;
import org.eclipse.gef.ui.palette.PaletteViewer;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.NamedObj;

public abstract class WorkbenchUtility {
    public static void addMouseListenerToPaletteViewer(PaletteViewer paletteViewer) {
        paletteViewer.getControl();
        EditPart editPart = paletteViewer.getContents();
        HashSet<DrawerEditPart> hashSet = new HashSet<DrawerEditPart>();
        for (Object object : editPart.getChildren()) {
            if (!(object instanceof DrawerEditPart) || ((DrawerEditPart)object).getDrawer().getLabel().equals("Utilities")) continue;
            hashSet.add((DrawerEditPart)object);
        }
        for (DrawerEditPart drawerEditPart : hashSet) {
            DrawerFigure drawerFigure = drawerEditPart.getDrawerFigure();
            drawerFigure.addMouseMotionListener((MouseMotionListener)new PaletteMouseListener(drawerEditPart, paletteViewer));
        }
    }

    public static CompositeEntity getParentActor(Object object) {
        NamedObj namedObj;
        if (object instanceof DiagramEditPart && ((DiagramEditPart)((Object)object)).getCompositeActor() != null && (namedObj = ((DiagramEditPart)((Object)object)).getCompositeActor().getContainer()) != null) {
            return ((DiagramEditPart)((Object)object)).getCompositeActor();
        }
        if (object instanceof EditPart && ((EditPart)object).getParent() instanceof DiagramEditPart) {
            namedObj = ((DiagramEditPart)((EditPart)object).getParent()).getCompositeActor();
            return namedObj;
        }
        return null;
    }

    public static String getPath(NamedObj namedObj) {
        StringBuffer stringBuffer = new StringBuffer();
        ArrayList<String> arrayList = new ArrayList<String>();
        WorkbenchUtility.addModelToPath(namedObj, arrayList);
        if (arrayList.size() > 1) {
            int n = 0;
            while (n < arrayList.size() - 1) {
                stringBuffer.append((String)arrayList.get(n));
                stringBuffer.append(".");
                ++n;
            }
        }
        stringBuffer.append(namedObj.getDisplayName());
        return stringBuffer.toString();
    }

    private static void addModelToPath(NamedObj namedObj, List<String> list) {
        if (namedObj.getContainer() != null) {
            list.add(namedObj.getContainer().getDisplayName());
            WorkbenchUtility.addModelToPath(namedObj.getContainer(), list);
        }
    }

    public static CompositeEntity containsCompositeEntity(List list) {
        if (list != null) {
            for (Object e : list) {
                CompositeEntity compositeEntity = WorkbenchUtility.getParentActor(e);
                if (compositeEntity == null) continue;
                return compositeEntity;
            }
        }
        return null;
    }
}

