/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.csveditor.model;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.csveditor.model.CsvRow;
import net.sourceforge.csveditor.model.ICsvFileModelListener;
import net.sourceforge.csveditor.model.ICsvOptionsProvider;
import org.supercsv.io.CsvListReader;
import org.supercsv.io.CsvListWriter;
import org.supercsv.prefs.CsvPreference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CsvFileModel {
    private int noOfColumns = 1;
    private ArrayList<CsvRow> rows = new ArrayList();
    private ArrayList<String> headers = new ArrayList();
    private ArrayList<ICsvFileModelListener> listeners = new ArrayList();
    private ICsvOptionsProvider optionsProvider;

    public CsvFileModel(ICsvOptionsProvider provider) {
        this.setCsvOptionsProvider(provider);
    }

    public void setInput(String text) {
        this.readLines(text);
    }

    public void setCsvOptionsProvider(ICsvOptionsProvider provider) {
        this.optionsProvider = provider;
    }

    public ICsvOptionsProvider getCsvOptionsProvider() {
        return this.optionsProvider;
    }

    private void readLines(String fileText) {
        this.rows.clear();
        try {
            String customDelimiter = this.optionsProvider.getCustomDelimiter();
            char customDelimiterAsChar = customDelimiter.charAt(0);
            CsvPreference customCSVPreference = CsvPreference.STANDARD_PREFERENCE;
            customCSVPreference.setDelimiterChar((int)customDelimiterAsChar);
            StringReader sr = new StringReader(fileText);
            CsvListReader clr = new CsvListReader((Reader)sr, customCSVPreference);
            List line = clr.read();
            while (line != null) {
                CsvRow csvRow = new CsvRow(line, this);
                this.rows.add(csvRow);
                if (this.noOfColumns < line.size()) {
                    this.noOfColumns = line.size();
                }
                line = clr.read();
            }
            this.populateHeaders();
        }
        catch (Exception exception) {}
    }

    public Object[] getRows() {
        return this.rows.toArray();
    }

    private void populateHeaders() {
        this.headers.clear();
        if (this.optionsProvider.getUseFirstLineAsHeader() && this.rows.size() > 0) {
            Object[] columnTitles;
            Object[] objectArray = columnTitles = this.rows.get(0).getEntries().toArray();
            int n = columnTitles.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                this.headers.add(o.toString());
                ++n2;
            }
            this.rows.remove(0);
            int i = this.headers.size();
            while (i < this.noOfColumns) {
                this.headers.add("");
                ++i;
            }
        } else {
            int i = 1;
            while (i < this.noOfColumns + 1) {
                this.headers.add("Column" + i);
                ++i;
            }
        }
    }

    public ArrayList<String> getHeaders() {
        return this.headers;
    }

    public int getColumnCount() {
        return this.noOfColumns;
    }

    protected void rowChanged(CsvRow row, int rowIndex) {
        for (ICsvFileModelListener l : this.listeners) {
            l.entryChanged(row, rowIndex);
        }
    }

    public void removeModelListener(ICsvFileModelListener csvFileListener) {
        this.listeners.remove(csvFileListener);
    }

    public void addModelListener(ICsvFileModelListener csvFileListener) {
        if (!this.listeners.contains(csvFileListener)) {
            this.listeners.add(csvFileListener);
        }
    }

    public String getTextRepresentation() {
        StringWriter sw = new StringWriter();
        try {
            CsvListWriter clw = new CsvListWriter((Writer)sw, CsvPreference.STANDARD_PREFERENCE);
            if (this.optionsProvider.getUseFirstLineAsHeader() && this.headers.size() > 0) {
                clw.write(this.headers);
            }
            for (CsvRow row : this.rows) {
                clw.write(row.getEntries());
            }
            clw.close();
            sw.close();
        }
        catch (Exception exception) {}
        return sw.toString();
    }
}

