/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.csveditor.editors;

import net.sourceforge.csveditor.editors.CsvContentProvider;
import net.sourceforge.csveditor.editors.CsvEditorCellModifier;
import net.sourceforge.csveditor.editors.CsvLabelProvider;
import net.sourceforge.csveditor.model.CsvFileModel;
import net.sourceforge.csveditor.model.CsvRow;
import net.sourceforge.csveditor.model.ICsvFileModelListener;
import net.sourceforge.csveditor.model.PreferencesCsvOptionsProvider;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.MultiPageEditorPart;

public class MultiPageCsvEditor
extends MultiPageEditorPart
implements IResourceChangeListener {
    private boolean isPageModified;
    private TextEditor editor;
    private TableViewer tableViewer;
    private CsvFileModel model = new CsvFileModel(new PreferencesCsvOptionsProvider());
    private final ICsvFileModelListener csvFileListener = new ICsvFileModelListener(){

        public void entryChanged(CsvRow row, int rowIndex) {
            MultiPageCsvEditor.this.tableViewer.update((Object)row, new String[]{Integer.toString(rowIndex)});
            MultiPageCsvEditor.this.tableModified();
        }
    };

    public MultiPageCsvEditor() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    void createSourcePage() {
        try {
            this.editor = new TextEditor();
            int index = this.addPage((IEditorPart)this.editor, this.getEditorInput());
            this.setPageText(index, "Source");
        }
        catch (PartInitException e) {
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)"Error creating nested text editor", null, (IStatus)e.getStatus());
        }
    }

    void createTablePage() {
        this.tableViewer = new TableViewer(this.getContainer(), 65538);
        Table table = this.tableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        int index = this.addPage(this.tableViewer.getControl());
        this.setPageText(index, "Table");
    }

    protected void createPages() {
        try {
            this.createTablePage();
            this.createSourcePage();
            this.updateTitle();
            this.populateTablePage();
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    void updateTitle() {
        IEditorInput input = this.getEditorInput();
        this.setPartName(input.getName());
        this.setTitleToolTip(input.getToolTipText());
    }

    void populateTablePage() throws Exception {
        this.tableViewer.setContentProvider((IContentProvider)new CsvContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new CsvLabelProvider());
        this.tableViewer.getTable().getDisplay().asyncExec(new Runnable(){

            public void run() {
                MultiPageCsvEditor.this.updateTableFromTextEditor();
            }
        });
    }

    public void tableModified() {
        boolean wasDirty = this.isDirty();
        this.isPageModified = true;
        if (!wasDirty) {
            this.firePropertyChange(257);
        }
    }

    void updateTableFromTextEditor() {
        TableColumn[] tableColumnArray = this.tableViewer.getTable().getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn column = tableColumnArray[n2];
            column.dispose();
            ++n2;
        }
        this.model.removeModelListener(this.csvFileListener);
        this.model.setInput(this.editor.getDocumentProvider().getDocument((Object)this.editor.getEditorInput()).get());
        for (String s : this.model.getHeaders()) {
            TableColumn tableColumn = new TableColumn(this.tableViewer.getTable(), 16384);
            tableColumn.setText(s);
            tableColumn.setWidth(100);
        }
        this.tableViewer.setInput((Object)this.model);
        this.model.addModelListener(this.csvFileListener);
        String[] columnProperties = new String[this.model.getColumnCount()];
        CellEditor[] cellEditors = new CellEditor[this.model.getColumnCount()];
        int i = 0;
        while (i < this.model.getColumnCount()) {
            columnProperties[i] = Integer.toString(i);
            cellEditors[i] = new TextCellEditor((Composite)this.tableViewer.getTable());
            ++i;
        }
        this.tableViewer.setColumnProperties(columnProperties);
        this.tableViewer.setCellEditors(cellEditors);
        this.tableViewer.setCellModifier((ICellModifier)new CsvEditorCellModifier());
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        super.dispose();
    }

    public void doSave(IProgressMonitor monitor) {
        if (this.getActivePage() == 0 && this.isPageModified) {
            this.updateTextEditorFromTable();
        } else {
            this.updateTableFromTextEditor();
        }
        this.isPageModified = false;
        this.editor.doSave(monitor);
    }

    public void doSaveAs() {
        if (this.getActivePage() == 0 && this.isPageModified) {
            this.updateTextEditorFromTable();
        } else {
            this.updateTableFromTextEditor();
        }
        this.isPageModified = false;
        this.editor.doSaveAs();
        this.setInput(this.editor.getEditorInput());
        this.updateTitle();
    }

    public void gotoMarker(IMarker marker) {
        this.setActivePage(0);
        IDE.gotoMarker((IEditorPart)this.getEditor(0), (IMarker)marker);
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        if (!(editorInput instanceof IFileEditorInput)) {
            throw new PartInitException("Invalid Input: Must be IFileEditorInput");
        }
        super.init(site, editorInput);
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    protected void handlePropertyChange(int propertyId) {
        if (propertyId == 257) {
            this.isPageModified = this.isDirty();
        }
        super.handlePropertyChange(propertyId);
    }

    public boolean isDirty() {
        return this.isPageModified || super.isDirty();
    }

    protected void pageChange(int newPageIndex) {
        switch (newPageIndex) {
            case 0: {
                if (!this.isDirty()) break;
                this.updateTableFromTextEditor();
                break;
            }
            case 1: {
                if (!this.isPageModified) break;
                this.updateTextEditorFromTable();
            }
        }
        this.isPageModified = false;
        super.pageChange(newPageIndex);
    }

    void updateTextEditorFromTable() {
        this.editor.getDocumentProvider().getDocument((Object)this.editor.getEditorInput()).set(((CsvFileModel)this.tableViewer.getInput()).getTextRepresentation());
    }

    public void resourceChanged(final IResourceChangeEvent event) {
        if (event.getType() == 2) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    IWorkbenchPage[] pages = MultiPageCsvEditor.this.getSite().getWorkbenchWindow().getPages();
                    int i = 0;
                    while (i < pages.length) {
                        if (((FileEditorInput)MultiPageCsvEditor.this.editor.getEditorInput()).getFile().getProject().equals((Object)event.getResource())) {
                            IEditorPart editorPart = pages[i].findEditor(MultiPageCsvEditor.this.editor.getEditorInput());
                            pages[i].closeEditor(editorPart, true);
                        }
                        ++i;
                    }
                }
            });
        }
    }
}

