/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.moml.filter;

import java.util.HashMap;
import java.util.Map;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.NamedObj;
import ptolemy.moml.MoMLFilter;
import ptolemy.moml.MoMLParser;

public class PortNameChanges
implements MoMLFilter {
    private static HashMap _actorsWithPortNameChanges = new HashMap();
    private static HashMap _containerPortMap = new HashMap();
    private String _currentActorFullName;
    private boolean _currentlyProcessingActorWithPortNameChanges = false;
    private boolean _doneProcessingActorWithPortNameChanges = false;
    private String _lastNameSeen;
    private static HashMap _portMap;

    static {
        HashMap<String, String> cartesianPorts = new HashMap<String, String>();
        cartesianPorts.put("real", "x");
        cartesianPorts.put("imag", "y");
        _actorsWithPortNameChanges.put("ptolemy.actor.lib.conversions.ComplexToCartesian", cartesianPorts);
        _actorsWithPortNameChanges.put("ptolemy.actor.lib.conversions.CartesianToComplex", cartesianPorts);
        HashMap<String, String> sleepPorts = new HashMap<String, String>();
        sleepPorts.put("delay", "sleepTime");
        _actorsWithPortNameChanges.put("ptolemy.actor.lib.Sleep", sleepPorts);
        HashMap<String, String> scramblerPorts = new HashMap<String, String>();
        scramblerPorts.put("initial", "initialState");
        _actorsWithPortNameChanges.put("ptolemy.actor.lib.comm.Scrambler", scramblerPorts);
        HashMap<String, String> convolutionalCoderPorts = new HashMap<String, String>();
        convolutionalCoderPorts.put("initial", "initialState");
        convolutionalCoderPorts.put("uncodeBlockSize", "uncodedRate");
        _actorsWithPortNameChanges.put("ptolemy.actor.lib.comm.ConvolutionalCoder", convolutionalCoderPorts);
        HashMap<String, String> viterbiDecoderPorts = new HashMap<String, String>();
        viterbiDecoderPorts.put("uncodeBlockSize", "uncodedRate");
        viterbiDecoderPorts.put("amplitude", "constellation");
        _actorsWithPortNameChanges.put("ptolemy.actor.lib.comm.ViterbiDecoder", viterbiDecoderPorts);
        HashMap<String, String> serverPorts = new HashMap<String, String>();
        serverPorts.put("newServiceTime", "serviceTime");
        _actorsWithPortNameChanges.put("ptolemy.domains.de.lib.Server", serverPorts);
    }

    public String filterAttributeValue(NamedObj container, String element, String attributeName, String attributeValue) {
        if (attributeValue == null) {
            return null;
        }
        if (attributeName.equals("name")) {
            this._lastNameSeen = attributeValue;
            if (this._currentlyProcessingActorWithPortNameChanges && _portMap != null && _portMap.containsKey(attributeValue)) {
                String containerName = container.getFullName();
                String newPort = (String)_portMap.get(attributeValue);
                _containerPortMap.put(String.valueOf(containerName) + "." + attributeValue, String.valueOf(containerName) + "." + newPort);
                MoMLParser.setModified(true);
                return newPort;
            }
        }
        if (attributeName.equals("class")) {
            if (_actorsWithPortNameChanges.containsKey(attributeValue)) {
                this._currentlyProcessingActorWithPortNameChanges = true;
                this._doneProcessingActorWithPortNameChanges = false;
                this._currentActorFullName = String.valueOf(container.getFullName()) + "." + this._lastNameSeen;
                _portMap = (HashMap)_actorsWithPortNameChanges.get(attributeValue);
            } else if (this._currentlyProcessingActorWithPortNameChanges && container != null && !container.getFullName().equals(this._currentActorFullName) && !container.getFullName().startsWith(this._currentActorFullName)) {
                this._currentlyProcessingActorWithPortNameChanges = false;
                this._doneProcessingActorWithPortNameChanges = true;
            }
        } else {
            if (this._doneProcessingActorWithPortNameChanges && attributeName.equals("port") && _containerPortMap.containsKey(String.valueOf(container.getFullName()) + "." + attributeValue)) {
                String newPort = (String)_containerPortMap.get(String.valueOf(container.getFullName()) + "." + attributeValue);
                newPort = newPort.substring(container.getFullName().length() + 1);
                MoMLParser.setModified(true);
                return newPort;
            }
            if (this._doneProcessingActorWithPortNameChanges && attributeName.equals("port")) {
                HashMap portMap;
                String className;
                int lastIndex = attributeValue.lastIndexOf(".");
                NamedObj portContainer = null;
                String portContainerName = null;
                String portName = null;
                if (lastIndex > 0) {
                    portContainerName = attributeValue.substring(0, lastIndex);
                    portContainer = ((CompositeEntity)container).getEntity(portContainerName);
                    portName = attributeValue.substring(lastIndex + 1);
                } else {
                    portContainer = container;
                    portName = attributeValue;
                }
                if (portContainer != null && _actorsWithPortNameChanges.containsKey(className = portContainer.getClassName()) && (portMap = (HashMap)_actorsWithPortNameChanges.get(className)).containsKey(portName)) {
                    String newPort = (String)portMap.get(portName);
                    if (lastIndex > 0) {
                        newPort = String.valueOf(portContainerName) + "." + newPort;
                    }
                    return newPort;
                }
            }
        }
        return attributeValue;
    }

    public void filterEndElement(NamedObj container, String elementName) throws Exception {
    }

    public String toString() {
        StringBuffer results = new StringBuffer(String.valueOf(this.getClass().getName()) + ": Update any actor port names that have been\n" + "renamed.\n" + "Below are the actors that are affected, along\n" + "with the old port name and the new port name:\n");
        for (String actor : _actorsWithPortNameChanges.keySet()) {
            results.append("\t" + actor + "\n");
            HashMap portMap = (HashMap)_actorsWithPortNameChanges.get(actor);
            for (Map.Entry ports : portMap.entrySet()) {
                String oldPort = (String)ports.getKey();
                String newPort = (String)ports.getValue();
                results.append("\t\t" + oldPort + "\t -> " + newPort + "\n");
            }
        }
        return results.toString();
    }
}

