/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.moml.filter;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import ptolemy.actor.TypedCompositeActor;
import ptolemy.kernel.util.NamedObj;
import ptolemy.moml.MoMLFilter;

public class NamedObjClassesSeen
implements MoMLFilter {
    private Set _classesSeen;
    private HashMap _classesToBeIndexed;
    String _modelPath;
    private static Class _namedObjClass;

    static {
        try {
            _namedObjClass = Class.forName("ptolemy.kernel.util.NamedObj");
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException(ex);
        }
    }

    public NamedObjClassesSeen(HashMap classesToBeIndexed) {
        this.reset(null);
        this._classesToBeIndexed = classesToBeIndexed;
    }

    public String filterAttributeValue(NamedObj container, String element, String attributeName, String attributeValue) {
        if (attributeValue == null) {
            return null;
        }
        if (attributeName.equals("class") && !this._classesSeen.contains(attributeValue)) {
            this._classesSeen.add(attributeValue);
            Set models = null;
            models = (Set)this._classesToBeIndexed.get(attributeValue);
            if (models != null) {
                Class<?> theClass = null;
                try {
                    theClass = Class.forName(attributeValue);
                }
                catch (Throwable ex) {
                    System.err.println("Failed to process " + attributeValue + "\n" + ex);
                }
                if (theClass != null && _namedObjClass.isAssignableFrom(theClass)) {
                    if (container != null && container instanceof TypedCompositeActor && container.getFullName().indexOf(".", 1) != -1) {
                        String compositePath = String.valueOf(this._modelPath) + "#" + container.getFullName().substring(container.getFullName().indexOf(".", 1) + 1);
                        models.add(compositePath);
                    } else {
                        models.add(this._modelPath);
                    }
                }
            }
        }
        return attributeValue;
    }

    public void filterEndElement(NamedObj container, String elementName) throws Exception {
    }

    public void reset(String modelPath) {
        this._modelPath = modelPath;
        this._classesSeen = new HashSet();
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + ": Create a Set of classes that have been parsed thus far. " + "The classes extend NamedObj. " + "This filter does not modify the model. ";
    }
}

