/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.moml.filter;

import ptolemy.data.BooleanToken;
import ptolemy.data.expr.SingletonParameter;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Settable;
import ptolemy.moml.MoMLFilter;
import ptolemy.moml.MoMLParser;

public class HideAnnotationNames
implements MoMLFilter {
    private boolean _currentlyProcessingAnnotation = false;
    private String _currentAnnotationFullName;

    public String filterAttributeValue(NamedObj container, String element, String attributeName, String attributeValue) {
        if (attributeValue == null) {
            return null;
        }
        if (attributeName.equals("name")) {
            if (attributeValue.endsWith("annotation1")) {
                this._currentlyProcessingAnnotation = true;
                this._currentAnnotationFullName = String.valueOf(container.getFullName()) + "." + attributeValue;
            } else if (this._currentlyProcessingAnnotation && attributeValue.equals("_hideName")) {
                this._currentlyProcessingAnnotation = false;
                this._currentAnnotationFullName = null;
            }
        }
        if (this._currentlyProcessingAnnotation && container != null && !container.getFullName().equals(this._currentAnnotationFullName) && (this._currentAnnotationFullName == null || this._currentAnnotationFullName != null && !this._currentAnnotationFullName.startsWith(container.getFullName())) && !container.getFullName().startsWith(this._currentAnnotationFullName)) {
            this._currentlyProcessingAnnotation = false;
            this._currentAnnotationFullName = null;
        }
        return attributeValue;
    }

    public void filterEndElement(NamedObj container, String elementName) throws Exception {
        if (!elementName.equals("property")) {
            return;
        }
        if (this._currentlyProcessingAnnotation && container != null && container.getFullName().equals(this._currentAnnotationFullName)) {
            this._currentlyProcessingAnnotation = false;
            this._currentAnnotationFullName = null;
            try {
                SingletonParameter hide = new SingletonParameter(container, "_hideName");
                hide.setToken(BooleanToken.TRUE);
                hide.setVisibility(Settable.EXPERT);
                MoMLParser.setModified(true);
            }
            catch (NameDuplicationException nameDuplicationException) {}
        }
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + ": If an annotation name ends with\n" + "'annotation1', then add _hideName if necessary.\n";
    }
}

