/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.moml;

import com.microstar.xml.HandlerBase;
import com.microstar.xml.XmlException;
import com.microstar.xml.XmlHandler;
import com.microstar.xml.XmlParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import ptolemy.actor.Director;
import ptolemy.actor.IOPort;
import ptolemy.kernel.ComponentEntity;
import ptolemy.kernel.ComponentPort;
import ptolemy.kernel.ComponentRelation;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.Entity;
import ptolemy.kernel.Port;
import ptolemy.kernel.Relation;
import ptolemy.kernel.attributes.URIAttribute;
import ptolemy.kernel.undo.UndoStackAttribute;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.ChangeListener;
import ptolemy.kernel.util.ChangeRequest;
import ptolemy.kernel.util.Configurable;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.Instantiable;
import ptolemy.kernel.util.KernelException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Settable;
import ptolemy.kernel.util.Singleton;
import ptolemy.kernel.util.Workspace;
import ptolemy.moml.Documentation;
import ptolemy.moml.ErrorHandler;
import ptolemy.moml.HandlesInternalLinks;
import ptolemy.moml.IconLoader;
import ptolemy.moml.MissingClassException;
import ptolemy.moml.MoMLFilter;
import ptolemy.moml.MoMLUndoEntry;
import ptolemy.moml.ParserAttribute;
import ptolemy.moml.SharedParameter;
import ptolemy.moml.UndoContext;
import ptolemy.util.CancelException;
import ptolemy.util.ClassUtilities;
import ptolemy.util.MessageHandler;
import ptolemy.util.StringUtilities;

public class MoMLParser
extends HandlerBase
implements ChangeListener {
    private static Map<String, ComponentEntity> actorClasses = new HashMap<String, ComponentEntity>();
    public static String MoML_DTD_1 = "<!ELEMENT model (class | configure | deleteEntity | deletePort | deleteRelation | director | display | doc | entity | group | import | input | link | property | relation | rename | rendition | unlink)*><!ATTLIST model name CDATA #REQUIRED class CDATA #IMPLIED><!ELEMENT class (class | configure | deleteEntity | deletePort | deleteRelation | director | display | doc | entity | group | import | input | link | port | property | relation | rename | rendition | unlink)*><!ATTLIST class name CDATA #REQUIRED extends CDATA #IMPLIED source CDATA #IMPLIED><!ELEMENT configure (#PCDATA)><!ATTLIST configure source CDATA #IMPLIED><!ELEMENT deleteEntity EMPTY><!ATTLIST deleteEntity name CDATA #REQUIRED><!ELEMENT deletePort EMPTY><!ATTLIST deletePort name CDATA #REQUIRED><!ELEMENT deleteProperty EMPTY><!ATTLIST deleteProperty name CDATA #REQUIRED><!ELEMENT deleteRelation EMPTY><!ATTLIST deleteRelation name CDATA #REQUIRED><!ELEMENT director (configure | doc | property)*><!ATTLIST director name CDATA \"director\" class CDATA #REQUIRED><!ELEMENT display EMPTY><!ATTLIST display name CDATA #REQUIRED><!ELEMENT doc (#PCDATA)><!ATTLIST doc name CDATA #IMPLIED><!ELEMENT entity (class | configure | deleteEntity | deletePort | deleteRelation | director | display | doc | entity | group | import | input | link | port | property | relation | rename | rendition | unlink)*><!ATTLIST entity name CDATA #REQUIRED class CDATA #IMPLIED source CDATA #IMPLIED><!ELEMENT group ANY><!ATTLIST group name CDATA #IMPLIED><!ELEMENT import EMPTY><!ATTLIST import source CDATA #REQUIRED base CDATA #IMPLIED><!ELEMENT input EMPTY><!ATTLIST input source CDATA #REQUIRED base CDATA #IMPLIED><!ELEMENT link EMPTY><!ATTLIST link insertAt CDATA #IMPLIED insertInsideAt CDATA #IMPLIED port CDATA #REQUIRED relation CDATA #IMPLIED vertex CDATA #IMPLIED><!ELEMENT location EMPTY><!ATTLIST location value CDATA #REQUIRED><!ELEMENT port (configure | display | doc | property | rename)*><!ATTLIST port class CDATA #IMPLIED name CDATA #REQUIRED><!ELEMENT property (configure | display | doc | property | rename)*><!ATTLIST property class CDATA #IMPLIED name CDATA #REQUIRED value CDATA #IMPLIED><!ELEMENT relation (configure | display | doc | property | rename | vertex)*><!ATTLIST relation name CDATA #REQUIRED class CDATA #IMPLIED><!ELEMENT rename EMPTY><!ATTLIST rename name CDATA #REQUIRED><!ELEMENT rendition (configure | location | property)*><!ATTLIST rendition class CDATA #REQUIRED><!ELEMENT unlink EMPTY><!ATTLIST unlink index CDATA #IMPLIED insideIndex CDATA #IMPLIED port CDATA #REQUIRED relation CDATA #IMPLIED><!ELEMENT vertex (configure | display | doc | location | property | rename)*><!ATTLIST vertex name CDATA #REQUIRED pathTo CDATA #IMPLIED value CDATA #IMPLIED>";
    public static String MoML_PUBLIC_ID_1 = "-//UC Berkeley//DTD MoML 1//EN";
    public static List inputFileNamesToSkip = null;
    private static Set _approvedRemoteXmlFiles = new HashSet();
    private Map _attributes = new HashMap();
    private List _attributeNameList = new ArrayList(0);
    private static String _AUTO_NAMESPACE = "auto";
    private URL _base;
    private ClassLoader _classLoader = this.getClass().getClassLoader();
    private int _configureNesting = 0;
    private String _configureSource;
    private Stack _containers = new Stack();
    private NamedObj _current;
    private StringBuffer _currentCharData;
    private String _currentDocName;
    private static String _DEFAULT_NAMESPACE = "";
    private static int _DELETE_ENTITY = 0;
    private static int _DELETE_PORT = 1;
    private static int _DELETE_PROPERTY = 2;
    private static int _DELETE_RELATION = 3;
    private List _deleteRequests;
    private Stack _deleteRequestStack = new Stack();
    private int _docNesting = 0;
    private Stack _externalEntities = new Stack();
    private static ErrorHandler _handler = null;
    private static List _filterList = null;
    private static IconLoader _iconLoader;
    private static Map _imports;
    private List _linkRequests;
    private Stack _linkRequestStack = new Stack();
    private static boolean _modified;
    private String _namespace = _DEFAULT_NAMESPACE;
    private Stack _namespaces = new Stack();
    private boolean _namespacesPushed = false;
    private Map _namespaceTranslationTable = null;
    private Stack _namespaceTranslations = new Stack();
    private NamedObj _originalContext = null;
    private List _paramsToParse = new LinkedList();
    private XmlParser _xmlParser;
    private boolean _previousDeferStatus = false;
    private int _skipElement = 0;
    private boolean _skipElementIsNew = false;
    private String _skipElementName;
    private boolean _skipRendition = false;
    private NamedObj _toplevel = null;
    private List _topObjectsCreated = null;
    private Stack _undoContexts = new Stack();
    private UndoContext _undoContext = null;
    private static boolean _undoDebug;
    private boolean _undoEnabled = false;
    private List _unrecognized;
    private Workspace _workspace;
    private URL _xmlFile = null;

    static {
        _modified = false;
        _undoDebug = false;
    }

    public static ComponentEntity getActorClass(String className) {
        return actorClasses.get(className);
    }

    public static void putActorClass(String className, ComponentEntity actorClass) {
        actorClasses.put(className, actorClass);
    }

    public MoMLParser() {
        this(null);
    }

    public MoMLParser(Workspace workspace) {
        if (workspace == null) {
            workspace = new Workspace();
        }
        this._workspace = workspace;
    }

    public MoMLParser(Workspace workspace, ClassLoader loader) {
        this(workspace);
        this._classLoader = loader;
    }

    public static void addMoMLFilter(MoMLFilter filter) {
        if (_filterList == null) {
            _filterList = new LinkedList();
        }
        if (!_filterList.contains(filter)) {
            _filterList.add(filter);
        }
    }

    public static void addMoMLFilters(List filterList) {
        if (_filterList == null) {
            _filterList = new LinkedList();
        }
        _filterList.addAll(filterList);
    }

    public void attribute(String name, String value, boolean specified) throws XmlException {
        if (name == null) {
            throw new XmlException("Attribute has no name", this._currentExternalEntity(), this._getLineNumber(), this._getColumnNumber());
        }
        if (this._namespace.equals(_AUTO_NAMESPACE) && this._current != null && (name.equals("name") || name.equals("port") || name.startsWith("relation") || name.equals("vertex") || name.equals("pathTo"))) {
            boolean nameSeenAlready = false;
            if (this._namespaceTranslationTable != null) {
                String replacement;
                String prefix = value;
                String suffix = "";
                int period = -1;
                if (value != null) {
                    period = value.indexOf(".");
                }
                if (period >= 0) {
                    prefix = value.substring(0, period);
                    suffix = value.substring(period);
                }
                if ((replacement = (String)this._namespaceTranslationTable.get(prefix)) != null) {
                    value = String.valueOf(replacement) + suffix;
                    nameSeenAlready = true;
                }
            }
            if (!nameSeenAlready && name.equals("name")) {
                String oldValue = value;
                String createIfNecessary = (String)this._attributes.get("createIfNecessary");
                value = this._current.uniqueName(oldValue);
                if (createIfNecessary != null && createIfNecessary.equals("true") && !value.equals(oldValue)) {
                    String currentElement = this._xmlParser.getCurrentElement();
                    ++this._skipElement;
                    this._skipElementIsNew = true;
                    this._skipElementName = currentElement;
                    return;
                }
                this._namespaceTranslationTable.put(oldValue, value);
            }
        } else if (!this._namespace.equals(_DEFAULT_NAMESPACE) && !this._namespace.equals(_AUTO_NAMESPACE) && (name.equals("name") || name.equals("port") || name.equals("relation") || name.equals("vertex") || name.equals("pathTo"))) {
            value = String.valueOf(this._namespace) + ":" + value;
        }
        if (_filterList != null) {
            String currentElement = this._xmlParser.getCurrentElement();
            Iterator filters = _filterList.iterator();
            String filteredValue = value;
            while (filters.hasNext()) {
                MoMLFilter filter = (MoMLFilter)filters.next();
                filteredValue = filter.filterAttributeValue(this._current, currentElement, name, filteredValue);
            }
            if (value != null && filteredValue == null) {
                this._skipElementIsNew = true;
                this._skipElementName = currentElement;
                ++this._skipElement;
            }
            value = filteredValue;
        }
        this._attributes.put(name, value);
        this._attributeNameList.add(name);
    }

    public void changeExecuted(ChangeRequest change) {
    }

    public void changeFailed(ChangeRequest change, Exception exception) {
        int reply;
        if (_handler != null && (reply = _handler.handleError(change.toString(), this._toplevel, exception)) == 0) {
            return;
        }
        System.err.println(exception.toString());
        exception.printStackTrace();
    }

    public void charData(char[] chars, int offset, int length) {
        if (this._currentCharData != null) {
            this._currentCharData.append(chars, offset, length);
        }
    }

    public void clearTopObjectsList() {
        if (this._topObjectsCreated == null) {
            this._topObjectsCreated = new LinkedList();
        } else {
            this._topObjectsCreated.clear();
        }
    }

    public void doctypeDecl(String name, String publicID, String systemID) throws CancelException {
        if (publicID != null && !publicID.trim().equals("") && !publicID.startsWith("-//UC Berkeley//DTD MoML")) {
            throw new CancelException("Public ID is not that of MoML version 1: " + publicID);
        }
    }

    public void endDocument() throws Exception {
        this._processPendingRequests();
        if (this._undoContext != null && this._undoContext.hasUndoMoML()) {
            NamedObj context;
            String undoMoML = this._undoContext.getUndoMoML();
            if (_undoDebug) {
                System.out.println("=======================");
                System.out.println("Generated UNDO MoML: ");
                System.out.print(undoMoML);
                System.out.println("=======================");
            }
            if ((context = this._current) == null) {
                context = this._toplevel;
            }
            MoMLUndoEntry newEntry = new MoMLUndoEntry(context, undoMoML);
            UndoStackAttribute undoInfo = UndoStackAttribute.getUndoInfo(context);
            undoInfo.push(newEntry);
            this._resetUndo();
        }
        if (this._unrecognized != null) {
            StringBuffer warning = new StringBuffer("Warning: Unrecognized XML elements:");
            Iterator elements = this._unrecognized.iterator();
            while (elements.hasNext()) {
                warning.append(" " + elements.next().toString());
            }
            try {
                MessageHandler.warning(warning.toString());
            }
            catch (CancelException cancelException) {}
        }
        try {
            if (this._toplevel != null) {
                this._toplevel.setDeferringChangeRequests(this._previousDeferStatus);
                this._toplevel.executeChangeRequests();
            }
            Iterator parameters = this._paramsToParse.iterator();
            HashSet<Settable> parametersValidated = new HashSet<Settable>();
            while (parameters.hasNext()) {
                Settable param = (Settable)parameters.next();
                if (parametersValidated.contains(param)) continue;
                try {
                    param.validate();
                    for (Settable derivedParam : ((NamedObj)((Object)param)).getDerivedList()) {
                        derivedParam.validate();
                        parametersValidated.add(derivedParam);
                    }
                    if (!(param instanceof SharedParameter)) continue;
                    parametersValidated.addAll(((SharedParameter)param).sharedParameterSet());
                }
                catch (Exception ex) {
                    int reply;
                    if (_handler != null && (reply = _handler.handleError("<param name=\"" + param.getName() + "\" value=\"" + param.getExpression() + "\"/>", param.getContainer(), ex)) == 0) continue;
                    throw ex;
                }
            }
        }
        finally {
            if (_handler != null) {
                _handler.enableErrorSkipping(false);
            }
        }
    }

    public void endElement(String elementName) throws Exception {
        String undoMoML;
        block61: {
            if (_filterList != null) {
                for (MoMLFilter filter : _filterList) {
                    filter.filterEndElement(this._current, elementName);
                }
            }
            if (this._skipElement <= 0) {
                if (elementName.equals("configure")) {
                    --this._configureNesting;
                    if (this._configureNesting < 0) {
                        throw new XmlException("Internal Error: _configureNesting is " + this._configureNesting + " which is <0, which indicates a nesting bug", this._currentExternalEntity(), this._getLineNumber(), this._getColumnNumber());
                    }
                } else if (elementName.equals("doc")) {
                    --this._docNesting;
                    if (this._docNesting < 0) {
                        throw new XmlException("Internal Error: _docNesting is " + this._docNesting + " which is <0, which indicates a nesting bug", this._currentExternalEntity(), this._getLineNumber(), this._getColumnNumber());
                    }
                }
                if (this._configureNesting > 0 || this._docNesting > 0) {
                    this._currentCharData.append("</");
                    this._currentCharData.append(elementName);
                    this._currentCharData.append(">");
                    return;
                }
            }
            if (this._skipRendition) {
                if (elementName.equals("rendition")) {
                    this._skipRendition = false;
                }
            } else if (this._skipElement > 0) {
                if (elementName.equals(this._skipElementName)) {
                    --this._skipElement;
                }
            } else if (elementName.equals("configure")) {
                try {
                    Configurable castCurrent = (Configurable)((Object)this._current);
                    String previousSource = castCurrent.getConfigureSource();
                    String previousText = castCurrent.getConfigureText();
                    castCurrent.configure(this._base, this._configureSource, this._currentCharData.toString());
                    try {
                        this._current.propagateValue();
                    }
                    catch (IllegalActionException ex) {
                        castCurrent.configure(this._base, previousSource, previousText);
                        throw ex;
                    }
                }
                catch (NoClassDefFoundError noClassDefFoundError) {}
            } else if (elementName.equals("doc")) {
                if (this._currentDocName == null && this._docNesting == 0) {
                    this._currentDocName = "_doc";
                }
                Documentation previous = (Documentation)this._current.getAttribute(this._currentDocName);
                String previousValue = null;
                if (previous != null) {
                    previousValue = previous.getValueAsString();
                }
                if (!this._currentCharData.toString().equals(previousValue)) {
                    if (previous != null) {
                        String newString = this._currentCharData.toString();
                        previous.setExpression(newString);
                        try {
                            previous.propagateValue();
                        }
                        catch (IllegalActionException ex) {
                            previous.setExpression(previousValue);
                            throw ex;
                        }
                    } else {
                        Documentation doc = new Documentation(this._current, this._currentDocName);
                        doc.setValue(this._currentCharData.toString());
                        doc.propagateExistence();
                        doc.propagateValue();
                    }
                }
                if (this._undoEnabled) {
                    this._undoContext.appendUndoMoML("<doc name=\"" + this._currentDocName + "\">");
                    if (previous != null) {
                        this._undoContext.appendUndoMoML(previousValue);
                    }
                    this._undoContext.appendUndoMoML("</doc>\n");
                }
                this._currentDocName = null;
            } else if (elementName.equals("group")) {
                this._processPendingRequests();
                try {
                    this._namespace = (String)this._namespaces.pop();
                    this._namespaceTranslationTable = (Map)this._namespaceTranslations.pop();
                }
                catch (EmptyStackException emptyStackException) {
                    this._namespace = _DEFAULT_NAMESPACE;
                }
                try {
                    this._linkRequests = (List)this._linkRequestStack.pop();
                }
                catch (EmptyStackException emptyStackException) {
                    this._linkRequests = null;
                }
                try {
                    this._deleteRequests = (List)this._deleteRequestStack.pop();
                }
                catch (EmptyStackException emptyStackException) {
                    this._deleteRequests = null;
                }
            } else if (elementName.equals("class") || elementName.equals("entity") || elementName.equals("model")) {
                this._processPendingRequests();
                try {
                    this._current = (NamedObj)this._containers.pop();
                }
                catch (EmptyStackException emptyStackException) {
                    this._current = null;
                }
                try {
                    this._namespace = (String)this._namespaces.pop();
                    this._namespaceTranslationTable = (Map)this._namespaceTranslations.pop();
                }
                catch (EmptyStackException emptyStackException) {
                    this._namespace = _DEFAULT_NAMESPACE;
                }
                try {
                    this._linkRequests = (List)this._linkRequestStack.pop();
                }
                catch (EmptyStackException emptyStackException) {
                    this._linkRequests = null;
                }
                try {
                    this._deleteRequests = (List)this._deleteRequestStack.pop();
                }
                catch (EmptyStackException emptyStackException) {
                    this._deleteRequests = null;
                }
            } else if (elementName.equals("property") || elementName.equals("director") || elementName.equals("port") || elementName.equals("relation") || elementName.equals("rendition") || elementName.equals("vertex")) {
                try {
                    this._current = (NamedObj)this._containers.pop();
                }
                catch (EmptyStackException emptyStackException) {
                    this._current = null;
                }
                try {
                    this._namespace = (String)this._namespaces.pop();
                    this._namespaceTranslationTable = (Map)this._namespaceTranslations.pop();
                }
                catch (EmptyStackException emptyStackException) {
                    this._namespace = _DEFAULT_NAMESPACE;
                }
            }
            undoMoML = null;
            if (this._undoContext != null && this._undoContext.hasUndoMoML()) {
                undoMoML = this._undoContext.generateUndoEntry();
                if (_undoDebug) {
                    System.out.println("Completed element: " + elementName + "\n" + this._undoContext.getUndoMoML());
                }
            }
            try {
                this._undoContext = (UndoContext)this._undoContexts.pop();
                this._undoEnabled = this._undoContext.isUndoable();
            }
            catch (EmptyStackException emptyStackException) {
                if (!_undoDebug) break block61;
                System.out.println("Reached top level of undo context stack");
            }
        }
        if (undoMoML != null) {
            this._undoContext.pushUndoEntry(undoMoML);
        }
    }

    public void endExternalEntity(String systemID) {
        this._externalEntities.pop();
    }

    public void error(String message, String systemID, int line, int column) throws XmlException {
        String currentExternalEntity = "";
        try {
            currentExternalEntity = this._currentExternalEntity();
            if (this._toplevel != null) {
                this._toplevel.setDeferringChangeRequests(this._previousDeferStatus);
                this._toplevel.executeChangeRequests();
            }
        }
        catch (Throwable throwable) {}
        throw new XmlException(message, currentExternalEntity, line, column);
    }

    public URL fileNameToURL(String source, URL base) throws Exception {
        URL result = null;
        StringBuffer errorMessage = new StringBuffer();
        InputStream input = null;
        try {
            result = new URL(base, source);
            String protocol = result.getProtocol();
            if (protocol != null && protocol.trim().toLowerCase().equals("http")) {
                SecurityManager security = System.getSecurityManager();
                boolean withinUntrustedApplet = false;
                if (security != null) {
                    try {
                        security.checkCreateClassLoader();
                    }
                    catch (SecurityException securityException) {
                        withinUntrustedApplet = true;
                    }
                }
                if (!(security != null && withinUntrustedApplet || _approvedRemoteXmlFiles.contains(result))) {
                    String resultBase = result.toString().substring(0, result.toString().lastIndexOf("/"));
                    if (this._base == null || !resultBase.startsWith(this._base.toString())) {
                        MessageHandler.warning("Security concern:\nAbout to look for MoML from the net at address:\n" + result.toExternalForm() + "\nOK to proceed?");
                    }
                    _approvedRemoteXmlFiles.add(result);
                }
            }
            input = result.openStream();
        }
        catch (IOException ioException) {
            errorMessage.append("-- " + ioException.getMessage() + "\n");
            result = this._classLoader.getResource(source);
            if (result != null) {
                input = result.openStream();
            }
            errorMessage.append("-- XML file not found relative to classpath.\n");
            String cwd = StringUtilities.getProperty("user.dir");
            try {
                base = new File(cwd).toURI().toURL();
                result = new URL(base, source);
                input = result.openStream();
            }
            catch (Throwable throwable) {
                errorMessage.append("-- " + cwd + File.separator + source + "\n" + throwable.getMessage() + "\n");
            }
        }
        if (input == null) {
            throw new XmlException(errorMessage.toString(), this._currentExternalEntity(), this._getLineNumber(), this._getColumnNumber());
        }
        input.close();
        return result;
    }

    public static ErrorHandler getErrorHandler() {
        return _handler;
    }

    public static IconLoader getIconLoader() {
        return _iconLoader;
    }

    public static List getMoMLFilters() {
        return _filterList;
    }

    public NamedObj getToplevel() {
        return this._toplevel;
    }

    public static boolean isModified() {
        return _modified;
    }

    public NamedObj parse(URL base, URL input) throws Exception {
        this._xmlFile = input;
        try {
            NamedObj namedObj;
            block15: {
                if (_imports == null) {
                    _imports = new HashMap();
                } else {
                    WeakReference reference = (WeakReference)_imports.get(input);
                    NamedObj previous = null;
                    if (reference != null && (previous = (NamedObj)reference.get()) == null) {
                        _imports.remove(input);
                    }
                    if (previous != null) {
                        NamedObj namedObj2 = previous;
                        return namedObj2;
                    }
                }
                InputStream inputStream = null;
                try {
                    try {
                        inputStream = input.openStream();
                    }
                    catch (Exception ex) {
                        URL jarURL = ClassUtilities.jarURLEntryResource(input.toExternalForm());
                        if (jarURL != null) {
                            inputStream = jarURL.openStream();
                        }
                        throw ex;
                    }
                    NamedObj result = this.parse(base, inputStream);
                    _imports.put(input, new WeakReference<NamedObj>(result));
                    namedObj = result;
                    if (inputStream == null) break block15;
                }
                catch (Throwable throwable) {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    throw throwable;
                }
                inputStream.close();
            }
            return namedObj;
        }
        finally {
            this._xmlFile = null;
        }
    }

    public NamedObj parse(URL base, InputStream input) throws Exception {
        return this.parse(base, new InputStreamReader(input));
    }

    public NamedObj parse(URL base, Reader reader) throws Exception {
        block23: {
            this._base = base;
            BufferedReader buffered = new BufferedReader(reader);
            try {
                try {
                    this._xmlParser = new XmlParser();
                    this._xmlParser.setHandler((XmlHandler)this);
                    if (base == null) {
                        this._xmlParser.parse(null, null, (Reader)buffered);
                        break block23;
                    }
                    boolean xmlFileWasNull = false;
                    if (this._xmlFile == null) {
                        xmlFileWasNull = true;
                        this._xmlFile = new URL(base.toExternalForm());
                    }
                    try {
                        this._xmlParser.parse(base.toExternalForm(), null, (Reader)buffered);
                    }
                    finally {
                        if (xmlFileWasNull) {
                            this._xmlFile = null;
                        }
                    }
                }
                catch (CancelException cancelException) {
                    this._xmlParser = null;
                    ((Reader)buffered).close();
                    return null;
                }
                catch (Exception ex) {
                    if (this._toplevel != null && this._toplevel instanceof ComponentEntity) {
                        try {
                            ((ComponentEntity)this._toplevel).setContainer(null);
                        }
                        catch (Exception exception) {}
                        try {
                            this._workspace.getWriteAccess();
                            this._workspace.remove(this._toplevel);
                        }
                        finally {
                            this._workspace.doneWriting();
                        }
                        this._toplevel = null;
                    }
                    this._paramsToParse.clear();
                    this.reset();
                    if (base != null) {
                        MoMLParser.purgeModelRecord(base);
                    }
                    throw ex;
                }
            }
            finally {
                this._xmlParser = null;
                ((Reader)buffered).close();
            }
        }
        if (this._toplevel == null) {
            throw new Exception("Toplevel was null?  Perhaps the xml does not contain a Ptolemy model?\n base ='" + base + "',\n reader = '" + reader + "'");
        }
        MoMLParser parser = ParserAttribute.getParser(this._toplevel);
        if (parser != this) {
            ParserAttribute parserAttribute = (ParserAttribute)this._toplevel.getAttribute("_parser", ParserAttribute.class);
            if (parserAttribute == null) {
                parserAttribute = new ParserAttribute(this._toplevel, "_parser");
            }
            parserAttribute.setParser(this);
        }
        return this._toplevel;
    }

    public NamedObj parse(String text) throws Exception {
        String cwd = StringUtilities.getProperty("user.dir");
        URL base = new File(cwd).toURI().toURL();
        return this.parse(base, new StringReader(text));
    }

    public NamedObj parse(URL base, String text) throws Exception {
        return this.parse(base, new StringReader(text));
    }

    public NamedObj parseFile(String filename) throws Exception {
        String cwd = StringUtilities.getProperty("user.dir");
        URL base = new File(cwd).toURI().toURL();
        File file = new File(new File(cwd), filename);
        return this.parse(base, file.toURI().toURL());
    }

    public void processingInstruction(String target, String data) {
        if (this._currentCharData != null) {
            this._currentCharData.append("<?");
            this._currentCharData.append(target);
            this._currentCharData.append(" ");
            this._currentCharData.append(data);
            this._currentCharData.append("?>");
        }
    }

    public static void purgeAllModelRecords() {
        _imports = null;
    }

    public static void purgeModelRecord(URL url) {
        if (_imports != null && url != null) {
            Object modelToPurge;
            WeakReference reference = (WeakReference)_imports.get(url);
            if (reference != null && (modelToPurge = reference.get()) instanceof Instantiable) {
                boolean keepTheModel = false;
                List children = ((Instantiable)modelToPurge).getChildren();
                if (children != null) {
                    for (WeakReference child : children) {
                        if (child == null || child.get() == null) continue;
                        keepTheModel = true;
                        break;
                    }
                }
                if (keepTheModel) {
                    return;
                }
            }
            _imports.remove(url);
        }
    }

    public static void purgeModelRecord(String filename) throws MalformedURLException {
        String cwd = StringUtilities.getProperty("user.dir");
        File file = new File(new File(cwd), filename);
        MoMLParser.purgeModelRecord(file.toURI().toURL());
    }

    public void reset() {
        this._attributes = new HashMap();
        this._configureNesting = 0;
        this._containers = new Stack();
        this._linkRequests = null;
        this._linkRequestStack = new Stack();
        this._deleteRequests = null;
        this._deleteRequestStack = new Stack();
        this._current = null;
        this._docNesting = 0;
        this._externalEntities = new Stack();
        _modified = false;
        this._namespace = _DEFAULT_NAMESPACE;
        this._namespaces = new Stack();
        this._namespaceTranslations = new Stack();
        this._skipRendition = false;
        this._skipElementIsNew = false;
        this._skipElement = 0;
        this._toplevel = null;
        this._resetUndo();
    }

    public Object resolveEntity(String publicID, String systemID) {
        if (publicID != null && publicID.equals(MoML_PUBLIC_ID_1)) {
            return new StringReader(MoML_DTD_1);
        }
        return null;
    }

    public ComponentEntity searchForClass(String name, String source) throws Exception {
        ComponentEntity candidate;
        if (_imports != null && source != null) {
            ComponentEntity candidate2;
            WeakReference reference = (WeakReference)_imports.get(source);
            Object possibleCandidate = null;
            if (reference != null && (possibleCandidate = reference.get()) == null) {
                _imports.remove(source);
            }
            if (possibleCandidate instanceof ComponentEntity && (candidate2 = (ComponentEntity)possibleCandidate).isClassDefinition()) {
                String candidateClassName;
                String realClassName = name;
                int lastPeriod = name.lastIndexOf(".");
                if (lastPeriod >= 0 && name.length() > lastPeriod + 1) {
                    realClassName = name.substring(lastPeriod + 1);
                }
                if ((lastPeriod = (candidateClassName = candidate2.getClassName()).lastIndexOf(".")) >= 0 && candidateClassName.length() > lastPeriod + 1) {
                    candidateClassName = candidateClassName.substring(lastPeriod + 1);
                }
                if (candidateClassName.equals(realClassName)) {
                    return candidate2;
                }
            }
        }
        if (source == null && (candidate = this._searchForEntity(name, this._current)) != null && candidate.isClassDefinition()) {
            return candidate;
        }
        return null;
    }

    public void setContext(NamedObj context) {
        this.reset();
        this._toplevel = context.toplevel();
        this._current = context;
        this._originalContext = context;
    }

    public static void setErrorHandler(ErrorHandler handler) {
        _handler = handler;
    }

    public static void setIconLoader(IconLoader loader) {
        _iconLoader = loader;
    }

    public static void setMoMLFilters(List filterList) {
        _filterList = filterList;
    }

    public static void setModified(boolean modified) {
        _modified = modified;
    }

    public void setToplevel(NamedObj toplevel) {
        this.reset();
        this._toplevel = toplevel;
    }

    public void setUndoable(boolean undoable) {
        this._undoEnabled = undoable;
    }

    public void startDocument() {
        this._paramsToParse.clear();
        this._unrecognized = null;
        if (_handler != null) {
            _handler.enableErrorSkipping(true);
        }
        this._previousDeferStatus = this._toplevel != null ? this._toplevel.setDeferringChangeRequests(true) : false;
        this._linkRequests = null;
        this._deleteRequests = null;
        this._linkRequestStack.clear();
        this._deleteRequestStack.clear();
    }

    /*
     * Exception decompiling
     */
    public void startElement(String elementName) throws XmlException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [35[CATCHBLOCK]], but top level block is 14[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void startExternalEntity(String systemID) {
        this._externalEntities.push(systemID);
    }

    public List topObjectsCreated() {
        return this._topObjectsCreated;
    }

    protected String _currentExternalEntity() {
        try {
            return (String)this._externalEntities.peek();
        }
        catch (EmptyStackException emptyStackException) {
            return null;
        }
    }

    private void _addParamsToParamsToParse(NamedObj object) {
        Iterator objects = object.containedObjectsIterator();
        while (objects.hasNext()) {
            NamedObj containedObject = (NamedObj)objects.next();
            if (containedObject instanceof Settable) {
                this._paramsToParse.add(containedObject);
            }
            this._addParamsToParamsToParse(containedObject);
        }
    }

    private ComponentEntity _attemptToFindMoMLClass(String className, String source) throws Exception {
        String classAsFile = null;
        String altClassAsFile = null;
        ComponentEntity reference = MoMLParser.getActorClass(className);
        if (reference != null) {
            return reference;
        }
        if (source == null) {
            classAsFile = String.valueOf(className.replace('.', '/')) + ".xml";
            altClassAsFile = String.valueOf(className.replace('.', '/')) + ".moml";
        } else {
            classAsFile = source;
        }
        URL url = null;
        try {
            url = this.fileNameToURL(classAsFile, this._base);
            if (_imports != null) {
                WeakReference possiblePrevious = (WeakReference)_imports.get(url);
                NamedObj previous = null;
                if (possiblePrevious != null && (previous = (NamedObj)possiblePrevious.get()) == null) {
                    _imports.remove(url);
                }
                if (previous instanceof ComponentEntity) {
                    return (ComponentEntity)previous;
                }
            }
        }
        catch (Exception exception) {}
        MoMLParser newParser = new MoMLParser(this._workspace, this._classLoader);
        NamedObj candidateReference = null;
        try {
            candidateReference = this._findOrParse(newParser, this._base, classAsFile, className, source);
        }
        catch (Exception ex2) {
            url = null;
            if (altClassAsFile != null) {
                url = this.fileNameToURL(altClassAsFile, this._base);
                if (_imports != null) {
                    WeakReference possiblePrevious = (WeakReference)_imports.get(url);
                    NamedObj previous = null;
                    if (possiblePrevious != null && (previous = (NamedObj)possiblePrevious.get()) == null) {
                        _imports.remove(url);
                    }
                    if (previous instanceof ComponentEntity) {
                        return (ComponentEntity)previous;
                    }
                }
                try {
                    candidateReference = this._findOrParse(newParser, this._base, altClassAsFile, className, source);
                    classAsFile = altClassAsFile;
                }
                catch (Exception exception) {
                    throw new XmlException("Could not find '" + classAsFile + "' or '" + altClassAsFile + "' using base '" + this._base + "': ", this._currentExternalEntity(), this._getLineNumber(), this._getColumnNumber(), (Throwable)ex2);
                }
            }
            throw ex2;
        }
        if (!(candidateReference instanceof ComponentEntity)) {
            throw new XmlException("File " + classAsFile + " does not define a ComponentEntity.", this._currentExternalEntity(), this._getLineNumber(), this._getColumnNumber());
        }
        reference = (ComponentEntity)candidateReference;
        String referenceName = reference.getName();
        if (!className.equals(referenceName) && !className.endsWith("." + referenceName)) {
            reference = reference instanceof CompositeEntity ? (className.startsWith(String.valueOf(referenceName) + ".") ? ((CompositeEntity)reference).getEntity(className.substring(referenceName.length() + 1)) : null) : null;
            if (reference == null) {
                throw new XmlException("File " + classAsFile + " does not define a class named " + className, this._currentExternalEntity(), this._getLineNumber(), this._getColumnNumber());
            }
        }
        this._loadIconForClass(className, reference);
        if (reference != null) {
            if (_imports == null) {
                _imports = new HashMap();
            }
            _imports.put(url, new WeakReference<ComponentEntity>(reference));
        }
        return reference;
    }

    private void _checkClass(Object object, Class correctClass, String msg) throws XmlException {
        if (!correctClass.isInstance(object)) {
            throw new XmlException(msg, this._currentExternalEntity(), this._getLineNumber(), this._getColumnNumber());
        }
    }

    private void _checkForNull(Object object, String message) throws XmlException {
        if (object == null) {
            throw new XmlException(message, this._currentExternalEntity(), this._getLineNumber(), this._getColumnNumber());
        }
    }

    private NamedObj _createEntity(String className, String entityName, String source) throws Exception {
        URIAttribute modelURI;
        if (this._current != null && !(this._current instanceof CompositeEntity)) {
            throw new XmlException("Cannot create an entity inside of another that is not a CompositeEntity (Container is '" + this._current + "').", this._currentExternalEntity(), this._getLineNumber(), this._getColumnNumber());
        }
        CompositeEntity container = (CompositeEntity)this._current;
        ComponentEntity previous = this._searchForEntity(entityName, this._current);
        Class<?> newClass = null;
        ComponentEntity reference = null;
        if (className != null) {
            reference = this.searchForClass(className, source);
            if (reference == null && source == null) {
                reference = this._searchForClassInContext(className, null);
            }
            if (reference == null || !reference.isClassDefinition()) {
                try {
                    newClass = Class.forName(className, true, this._classLoader);
                }
                catch (Exception exception) {
                    try {
                        reference = this._attemptToFindMoMLClass(className, source);
                    }
                    catch (Exception ex2) {
                        throw new IllegalActionException(null, ex2, "Cannot find class: " + className);
                    }
                }
                catch (Error error) {
                    StringBuffer errorMessage = new StringBuffer();
                    if (error instanceof ExceptionInInitializerError) {
                        Throwable staticThrowable = ((ExceptionInInitializerError)error).getCause();
                        errorMessage.append("ExceptionInInitializerError: Caused by:\n " + KernelException.stackTraceToString(staticThrowable));
                    } else {
                        errorMessage.append(String.valueOf(className) + ": \n " + error.toString() + "\n");
                    }
                    try {
                        reference = this._attemptToFindMoMLClass(className, source);
                    }
                    catch (XmlException ex2) {
                        throw new Exception("-- " + errorMessage.toString() + className + ": XmlException:\n" + ex2.getMessage());
                    }
                    catch (ClassFormatError ex3) {
                        throw new Exception("-- :" + errorMessage.toString() + className + ": ClassFormatError: " + "found invalid Java class file.\n" + ex3.getMessage());
                    }
                    catch (Exception ex4) {
                        throw new Exception("-- " + errorMessage.toString() + className + ": Exception:\n" + ex4.getMessage());
                    }
                }
            }
        }
        if (previous != null) {
            if (newClass != null) {
                this._checkClass(previous, newClass, "entity named \"" + entityName + "\" exists and is not an instance of " + className);
            }
            return previous;
        }
        this._checkForNull(className, "Cannot create entity without a class name.");
        if (reference == null || !reference.isClassDefinition()) {
            if (this._current != null) {
                List derivedList = container.getDerivedList();
                for (CompositeEntity derived : derivedList) {
                    if (derived.getEntity(entityName) == null) continue;
                    throw new IllegalActionException((Nameable)container, "Cannot create entity because a subclass or instance contains an entity with the same name: " + derived.getEntity(entityName).getFullName());
                }
                this._checkClass(this._current, CompositeEntity.class, "Cannot create an entity inside an element that is not a CompositeEntity. It is: " + this._current);
                Object[] arguments = new Object[]{this._current, entityName};
                NamedObj newEntity = this._createInstance(newClass, arguments);
                newEntity.propagateExistence();
                this._loadIconForClass(className, newEntity);
                this._addParamsToParamsToParse(newEntity);
                return newEntity;
            }
            Object[] arguments = new Object[]{this._workspace};
            NamedObj result = this._createInstance(newClass, arguments);
            result.setName(entityName);
            this._loadIconForClass(className, result);
            return result;
        }
        if (!reference.isClassDefinition()) {
            throw new MissingClassException("Attempt to extend an entity that is not a class: " + reference.getFullName(), reference.getFullName(), this._currentExternalEntity(), this._getLineNumber(), this._getColumnNumber());
        }
        List derivedList = null;
        if (container != null) {
            derivedList = container.getDerivedList();
            for (CompositeEntity derived : derivedList) {
                if (derived.getEntity(entityName) == null) continue;
                throw new IllegalActionException((Nameable)container, "Cannot create entity because a subclass or instance contains an entity with the same name: " + derived.getEntity(entityName).getFullName());
            }
        }
        ComponentEntity newEntity = (ComponentEntity)reference.instantiate(container, entityName);
        if (this._topObjectsCreated != null && container == this._originalContext) {
            this._topObjectsCreated.add(newEntity);
        }
        if ((modelURI = (URIAttribute)newEntity.getAttribute("_uri", URIAttribute.class)) != null) {
            modelURI.setContainer(null);
        }
        this._markParametersToParse(newEntity);
        newEntity.setClassName(className);
        for (ComponentEntity propagatedEntity : newEntity.propagateExistence()) {
            URIAttribute propagatedURI = (URIAttribute)propagatedEntity.getAttribute("_uri", URIAttribute.class);
            if (propagatedURI == null) continue;
            propagatedURI.setContainer(null);
        }
        return newEntity;
    }

    private NamedObj _createInstance(Class newClass, Object[] arguments) throws Exception {
        Constructor<?>[] constructors = newClass.getConstructors();
        int i = 0;
        while (i < constructors.length) {
            Constructor<?> constructor = constructors[i];
            Class<?>[] parameterTypes = constructor.getParameterTypes();
            if (parameterTypes.length == arguments.length) {
                boolean match = true;
                int j = 0;
                while (j < parameterTypes.length) {
                    if (!parameterTypes[j].isInstance(arguments[j])) {
                        match = false;
                        break;
                    }
                    ++j;
                }
                if (match) {
                    NamedObj newEntity = (NamedObj)constructor.newInstance(arguments);
                    this._markContentsDerived(newEntity, 0);
                    if (this._topObjectsCreated != null && arguments[0] == this._originalContext) {
                        this._topObjectsCreated.add(newEntity);
                    }
                    return newEntity;
                }
            }
            ++i;
        }
        StringBuffer argumentBuffer = new StringBuffer();
        int i2 = 0;
        while (i2 < arguments.length) {
            argumentBuffer.append(arguments[i2].getClass() + " = \"" + arguments[i2].toString() + "\"");
            if (i2 < arguments.length - 1) {
                argumentBuffer.append(", ");
            }
            ++i2;
        }
        throw new XmlException("Cannot find a suitable constructor (" + arguments.length + " args) (" + argumentBuffer + ") for '" + newClass.getName() + "'", this._currentExternalEntity(), this._getLineNumber(), this._getColumnNumber());
    }

    private NamedObj _deleteEntity(String entityName) throws Exception {
        ComponentEntity toDelete = this._searchForEntity(entityName, this._current);
        if (toDelete == null) {
            return null;
        }
        if (toDelete.getDerivedLevel() < Integer.MAX_VALUE) {
            throw new IllegalActionException((Nameable)toDelete, "Cannot delete. This entity is part of the class definition.");
        }
        StringBuffer undoMoML = new StringBuffer();
        try {
            Iterator derivedObjects = toDelete.getDerivedList().iterator();
            LinkedList reverse = new LinkedList();
            while (derivedObjects.hasNext()) {
                reverse.add(0, derivedObjects.next());
            }
            for (ComponentEntity derived : reverse) {
                String toUndo = this._getUndoForDeleteEntity(derived);
                derived.setContainer(null);
                undoMoML.insert(0, toUndo);
            }
            String toUndo = this._getUndoForDeleteEntity(toDelete);
            toDelete.setContainer(null);
            undoMoML.insert(0, toUndo);
        }
        finally {
            if (this._undoEnabled) {
                undoMoML.insert(0, "<group>");
                undoMoML.append("</group>\n");
                this._undoContext.appendUndoMoML(undoMoML.toString());
            }
        }
        return toDelete;
    }

    private Port _deletePort(String portName, String entityName) throws Exception {
        Port toDelete = null;
        Entity portContainer = null;
        if (entityName == null) {
            toDelete = this._searchForPort(portName);
            if (toDelete != null) {
                portContainer = (Entity)toDelete.getContainer();
            }
        } else {
            portContainer = this._searchForEntity(entityName, this._current);
            if (portContainer != null) {
                toDelete = portContainer.getPort(portName);
            }
        }
        if (toDelete == null) {
            return null;
        }
        if (portContainer == null) {
            throw new XmlException("No container for the port: " + portName, this._currentExternalEntity(), this._getLineNumber(), this._getColumnNumber());
        }
        if (toDelete.getDerivedLevel() < Integer.MAX_VALUE) {
            throw new IllegalActionException((Nameable)toDelete, "Cannot delete. This port is part of the class definition.");
        }
        StringBuffer undoMoML = new StringBuffer();
        try {
            Iterator derivedObjects = toDelete.getDerivedList().iterator();
            LinkedList reverse = new LinkedList();
            while (derivedObjects.hasNext()) {
                reverse.add(0, derivedObjects.next());
            }
            for (Port derived : reverse) {
                String toUndo = this._getUndoForDeletePort(derived);
                derived.setContainer(null);
                undoMoML.insert(0, toUndo);
            }
            String toUndo = this._getUndoForDeletePort(toDelete);
            toDelete.setContainer(null);
            undoMoML.insert(0, toUndo);
        }
        finally {
            if (this._undoEnabled) {
                undoMoML.insert(0, "<group>");
                undoMoML.append("</group>\n");
                this._undoContext.appendUndoMoML(undoMoML.toString());
            }
        }
        return toDelete;
    }

    private Attribute _deleteProperty(String attributeName) throws Exception {
        Attribute toDelete = this._searchForAttribute(attributeName);
        if (toDelete == null) {
            return null;
        }
        if (toDelete.getDerivedLevel() < Integer.MAX_VALUE) {
            throw new IllegalActionException((Nameable)toDelete, "Cannot delete. This attribute is part of the class definition.");
        }
        StringBuffer undoMoML = new StringBuffer();
        try {
            Iterator derivedObjects = toDelete.getDerivedList().iterator();
            String toUndo = this._getUndoForDeleteAttribute(toDelete);
            toDelete.setContainer(null);
            undoMoML.append(toUndo);
            while (derivedObjects.hasNext()) {
                Attribute derived = (Attribute)derivedObjects.next();
                toUndo = this._getUndoForDeleteAttribute(derived);
                derived.setContainer(null);
                undoMoML.append(toUndo);
            }
        }
        finally {
            if (this._undoEnabled) {
                undoMoML.insert(0, "<group>");
                undoMoML.append("</group>\n");
                this._undoContext.appendUndoMoML(undoMoML.toString());
            }
        }
        return toDelete;
    }

    private Relation _deleteRelation(String relationName) throws Exception {
        ComponentRelation toDelete = this._searchForRelation(relationName);
        if (toDelete == null) {
            return null;
        }
        if (toDelete.getDerivedLevel() < Integer.MAX_VALUE) {
            throw new IllegalActionException((Nameable)toDelete, "Cannot delete. This relation is part of the class definition.");
        }
        StringBuffer undoMoML = new StringBuffer();
        try {
            Iterator derivedObjects = toDelete.getDerivedList().iterator();
            LinkedList reverse = new LinkedList();
            while (derivedObjects.hasNext()) {
                reverse.add(0, derivedObjects.next());
            }
            for (ComponentRelation derived : reverse) {
                derived.setContainer(null);
            }
            String toUndo = this._getUndoForDeleteRelation(toDelete);
            toDelete.setContainer(null);
            undoMoML.insert(0, toUndo);
        }
        finally {
            if (this._undoEnabled) {
                undoMoML.insert(0, "<group>");
                undoMoML.append("</group>\n");
                this._undoContext.appendUndoMoML(undoMoML.toString());
            }
        }
        return toDelete;
    }

    private NamedObj _findOrParse(MoMLParser parser, URL base, String file, String className, String source) throws Exception {
        URL previousXmlFile = parser._xmlFile;
        boolean modified = MoMLParser.isModified();
        parser._xmlFile = this.fileNameToURL(file, base);
        try {
            NamedObj toplevel = parser.parse(parser._xmlFile, parser._xmlFile);
            toplevel.setSource(source);
            if (_imports == null) {
                _imports = new HashMap();
            }
            _imports.put(parser._xmlFile, new WeakReference<NamedObj>(toplevel));
            NamedObj namedObj = toplevel;
            return namedObj;
        }
        catch (CancelException cancelException) {
            return null;
        }
        finally {
            parser._xmlFile = previousXmlFile;
            MoMLParser.setModified(modified);
        }
    }

    private int _getColumnNumber() {
        if (this._xmlParser == null) {
            return -1;
        }
        return this._xmlParser.getColumnNumber();
    }

    private String _getCurrentElement(String elementName) {
        StringBuffer result = new StringBuffer();
        result.append("<");
        result.append(elementName);
        for (String name : this._attributeNameList) {
            String value = (String)this._attributes.get(name);
            if (value == null) continue;
            result.append(" ");
            result.append(name);
            result.append("=\"");
            result.append(StringUtilities.escapeForXML(value));
            result.append("\"");
        }
        result.append(">");
        return result.toString();
    }

    private int _getLineNumber() {
        if (this._xmlParser == null) {
            return -1;
        }
        return this._xmlParser.getLineNumber();
    }

    private ComponentPort _getPort(String portspec, CompositeEntity context) throws XmlException {
        ComponentPort port = (ComponentPort)context.getPort(portspec);
        this._checkForNull(port, "No port named \"" + portspec + "\" in " + context.getFullName());
        return port;
    }

    private String _getUndoForDeleteAttribute(Attribute toDelete) throws IOException {
        StringBuffer moml = new StringBuffer(UndoContext.moveContextStart(this._current, toDelete));
        int depth = toDelete.depthInHierarchy() - this._current.depthInHierarchy();
        if (!this._current.deepContains(toDelete)) {
            depth = 0;
        }
        StringWriter buffer = new StringWriter();
        toDelete.exportMoML(buffer, depth);
        moml.append(buffer.toString());
        moml.append(UndoContext.moveContextEnd(this._current, toDelete));
        return moml.toString();
    }

    private String _getUndoForDeleteEntity(ComponentEntity toDelete) throws IOException {
        StringBuffer moml = new StringBuffer(UndoContext.moveContextStart(this._current, toDelete));
        int depth = toDelete.depthInHierarchy() - this._current.depthInHierarchy();
        if (depth < 0) {
            depth = 0;
        }
        StringWriter buffer = new StringWriter();
        toDelete.exportMoML(buffer, depth);
        moml.append(buffer.toString());
        CompositeEntity container = (CompositeEntity)toDelete.getContainer();
        if (container instanceof HandlesInternalLinks) {
            return moml.toString();
        }
        HashSet<NamedObj> filter = new HashSet<NamedObj>();
        if (toDelete.getDerivedLevel() == Integer.MAX_VALUE) {
            filter.addAll(toDelete.linkedRelationList());
        } else {
            for (Relation relation : toDelete.linkedRelationList()) {
                if (relation == null || relation.getDerivedLevel() != Integer.MAX_VALUE) continue;
                filter.add(relation);
            }
        }
        filter.add(toDelete);
        moml.append(container.exportLinks(0, filter));
        moml.append(UndoContext.moveContextEnd(this._current, toDelete));
        return moml.toString();
    }

    private String _getUndoForDeletePort(Port toDelete) throws IOException {
        NamedObj containerContainer;
        StringBuffer moml = new StringBuffer(UndoContext.moveContextStart(this._current, toDelete));
        int depth = toDelete.depthInHierarchy() - this._current.depthInHierarchy();
        if (!this._current.deepContains(toDelete)) {
            depth = 0;
        }
        StringWriter buffer = new StringWriter();
        toDelete.exportMoML(buffer, depth);
        moml.append(buffer.toString());
        NamedObj container = toDelete.getContainer();
        HashSet<Port> filter = new HashSet<Port>();
        filter.addAll(toDelete.linkedRelationList());
        if (container != null && !(container instanceof HandlesInternalLinks) && toDelete instanceof ComponentPort) {
            filter.addAll(((ComponentPort)toDelete).insideRelationList());
        }
        filter.add(toDelete);
        if (container instanceof CompositeEntity) {
            moml.append(((CompositeEntity)container).exportLinks(depth, filter));
        }
        moml.append(UndoContext.moveContextEnd(this._current, toDelete));
        if (container != null && (containerContainer = container.getContainer()) instanceof CompositeEntity && !(containerContainer instanceof HandlesInternalLinks)) {
            moml.append(UndoContext.moveContextStart(this._current, container));
            if (depth == 0) {
                depth = 1;
            }
            moml.append(((CompositeEntity)containerContainer).exportLinks(depth - 1, filter));
            moml.append(UndoContext.moveContextEnd(this._current, container));
        }
        return moml.toString();
    }

    private String _getUndoForDeleteRelation(ComponentRelation toDelete) throws IOException {
        StringBuffer moml = new StringBuffer(UndoContext.moveContextStart(this._current, toDelete));
        int depth = toDelete.depthInHierarchy() - this._current.depthInHierarchy();
        if (!this._current.deepContains(toDelete)) {
            depth = 0;
        }
        StringWriter buffer = new StringWriter();
        toDelete.exportMoML(buffer, depth);
        moml.append(buffer.toString());
        CompositeEntity container = (CompositeEntity)toDelete.getContainer();
        if (container instanceof HandlesInternalLinks) {
            return moml.toString();
        }
        HashSet<Relation> filter = new HashSet<Relation>();
        if (toDelete.getDerivedLevel() == Integer.MAX_VALUE) {
            filter.addAll(toDelete.linkedObjectsList());
        } else {
            for (Relation portOrRelation : toDelete.linkedObjectsList()) {
                if (portOrRelation == null || portOrRelation.getDerivedLevel() != Integer.MAX_VALUE) continue;
                filter.add(portOrRelation);
            }
        }
        filter.add(toDelete);
        moml.append(container.exportLinks(0, filter));
        moml.append(UndoContext.moveContextEnd(this._current, toDelete));
        return moml.toString();
    }

    private void _handlePropertyElement(String className, String propertyName, String value) throws Exception {
        boolean isIOPort = this._current instanceof IOPort;
        if (propertyName.equals("multiport") && isIOPort) {
            IOPort currentIOPort = (IOPort)this._current;
            boolean previousValue = currentIOPort.isMultiport();
            boolean newValue = true;
            if (value != null && value.trim().toLowerCase().equals("false")) {
                newValue = false;
            }
            if (this._current.getDerivedLevel() < Integer.MAX_VALUE && ((IOPort)this._current).isMultiport() != newValue) {
                throw new IllegalActionException((Nameable)this._current, "Cannot change whether this port is a multiport. That property is fixed by the class definition.");
            }
            ((IOPort)this._current).setMultiport(newValue);
            for (IOPort derived : this._current.getDerivedList()) {
                derived.setMultiport(newValue);
            }
            this._pushContext();
            this._current = this._current.getAttribute(propertyName);
            this._namespace = _DEFAULT_NAMESPACE;
            if (this._undoEnabled) {
                this._undoContext.appendUndoMoML("<property name=\"" + propertyName + "\" value=\"");
                this._undoContext.appendUndoMoML(String.valueOf(previousValue) + "\" >\n");
                this._undoContext.setChildrenUndoable(true);
                this._undoContext.appendClosingUndoMoML("</property>\n");
            }
        } else if (propertyName.equals("output") && isIOPort) {
            IOPort currentIOPort = (IOPort)this._current;
            boolean previousValue = currentIOPort.isOutput();
            boolean newValue = true;
            if (value != null && value.trim().toLowerCase().equals("false")) {
                newValue = false;
            }
            if (this._current.getDerivedLevel() < Integer.MAX_VALUE && ((IOPort)this._current).isOutput() != newValue) {
                throw new IllegalActionException((Nameable)this._current, "Cannot change whether this port is an output. That property is fixed by the class definition.");
            }
            ((IOPort)this._current).setOutput(newValue);
            for (IOPort derived : this._current.getDerivedList()) {
                derived.setOutput(newValue);
            }
            this._pushContext();
            this._current = this._current.getAttribute(propertyName);
            this._namespace = _DEFAULT_NAMESPACE;
            if (this._undoEnabled) {
                this._undoContext.appendUndoMoML("<property name=\"" + propertyName + "\" value=\"");
                this._undoContext.appendUndoMoML(String.valueOf(previousValue) + "\" >\n");
                this._undoContext.setChildrenUndoable(true);
                this._undoContext.appendClosingUndoMoML("</property>\n");
            }
        } else if (propertyName.equals("input") && isIOPort) {
            IOPort currentIOPort = (IOPort)this._current;
            boolean previousValue = currentIOPort.isInput();
            boolean newValue = true;
            if (value != null && value.trim().toLowerCase().equals("false")) {
                newValue = false;
            }
            if (this._current.getDerivedLevel() < Integer.MAX_VALUE && ((IOPort)this._current).isInput() != newValue) {
                throw new IllegalActionException((Nameable)this._current, "Cannot change whether this port is an input. That property is fixed by the class definition.");
            }
            ((IOPort)this._current).setInput(newValue);
            for (IOPort derived : this._current.getDerivedList()) {
                derived.setInput(newValue);
            }
            this._pushContext();
            this._current = this._current.getAttribute(propertyName);
            this._namespace = _DEFAULT_NAMESPACE;
            if (this._undoEnabled) {
                this._undoContext.appendUndoMoML("<property name=\"" + propertyName + "\" value=\"");
                this._undoContext.appendUndoMoML(String.valueOf(previousValue) + "\" >\n");
                this._undoContext.setChildrenUndoable(true);
                this._undoContext.appendClosingUndoMoML("</property>\n");
            }
        } else {
            Settable settable;
            NamedObj property = null;
            if (this._current != null) {
                property = this._current.getAttribute(propertyName);
            }
            Class<Object> newClass = null;
            if (className != null) {
                try {
                    newClass = Class.forName(className, true, this._classLoader);
                }
                catch (NoClassDefFoundError ex) {
                    throw new XmlException("Failed to find class '" + className + "'", this._currentExternalEntity(), this._getLineNumber(), this._getColumnNumber(), (Throwable)ex);
                }
                catch (SecurityException ex) {
                    throw new XmlException("Failed to find class '" + className + "'", this._currentExternalEntity(), this._getLineNumber(), this._getColumnNumber(), (Throwable)ex);
                }
            }
            boolean previouslyExisted = property != null;
            boolean createdNew = false;
            String oldClassName = null;
            String oldValue = null;
            if (previouslyExisted) {
                oldClassName = property.getClass().getName();
                if (property instanceof Settable) {
                    settable = (Settable)((Object)property);
                    oldValue = settable.getExpression();
                }
            }
            if (!previouslyExisted || newClass != null && !newClass.isInstance(property)) {
                try {
                    if (newClass == null) {
                        newClass = Attribute.class;
                    }
                    if (this._current == null) {
                        Object[] arguments = new Object[]{this._workspace, propertyName};
                        this._toplevel = property = this._createInstance(newClass, arguments);
                    } else {
                        List derivedList = this._current.getDerivedList();
                        for (NamedObj derived : derivedList) {
                            Attribute other = derived.getAttribute(propertyName);
                            if (other == null || other instanceof Singleton) continue;
                            throw new IllegalActionException((Nameable)this._current, "Cannot create attribute because a subclass or instance contains an attribute with the same name: " + derived.getAttribute(propertyName).getFullName());
                        }
                        Object[] arguments = new Object[]{this._current, propertyName};
                        property = this._createInstance(newClass, arguments);
                        if (property instanceof Director) {
                            this._loadIconForClass(className, property);
                        }
                        if (!(property instanceof Attribute)) {
                            if (property instanceof ComponentEntity) {
                                ((ComponentEntity)property).setContainer(null);
                            } else if (property instanceof Port) {
                                ((Port)property).setContainer(null);
                            } else if (property instanceof ComponentRelation) {
                                ((ComponentRelation)property).setContainer(null);
                            }
                            throw new XmlException("Property is not an instance of Attribute. ", this._currentExternalEntity(), this._getLineNumber(), this._getColumnNumber());
                        }
                        property.propagateExistence();
                    }
                    if (value != null) {
                        if (property == null) {
                            throw new XmlException("Property does not exist: " + propertyName + "\n", this._currentExternalEntity(), this._getLineNumber(), this._getColumnNumber());
                        }
                        if (!(property instanceof Settable)) {
                            throw new XmlException("Property cannot be assigned a value: " + property.getFullName() + " (instance of " + property.getClass().toString() + ")\n", this._currentExternalEntity(), this._getLineNumber(), this._getColumnNumber());
                        }
                        settable = (Settable)((Object)property);
                        settable.setExpression(value);
                        this._paramsToParse.add(property);
                        property.propagateValue();
                    }
                    createdNew = true;
                }
                catch (NameDuplicationException nameDuplicationException) {}
            }
            if (!createdNew && value != null) {
                if (!(property instanceof Settable)) {
                    throw new XmlException("Property is not an instance of Settable, so can't set the value.", this._currentExternalEntity(), this._getLineNumber(), this._getColumnNumber());
                }
                settable = (Settable)((Object)property);
                settable.setExpression(value);
                property.propagateValue();
                this._paramsToParse.add(property);
            }
            this._pushContext();
            this._current = property;
            this._namespace = _DEFAULT_NAMESPACE;
            if (this._undoEnabled) {
                if (!previouslyExisted) {
                    this._undoContext.appendUndoMoML("<deleteProperty name=\"" + propertyName + "\" />\n");
                    this._undoContext.setChildrenUndoable(false);
                    this._undoContext.setUndoable(false);
                    this._undoEnabled = false;
                } else {
                    this._undoContext.appendUndoMoML("<property name=\"" + property.getName() + "\" ");
                    this._undoContext.appendUndoMoML("class=\"" + oldClassName + "\" ");
                    if (oldValue != null) {
                        this._undoContext.appendUndoMoML("value=\"" + StringUtilities.escapeForXML(oldValue) + "\" ");
                    }
                    this._undoContext.appendUndoMoML(">\n");
                    this._undoContext.appendClosingUndoMoML("</property>\n");
                    this._undoContext.setChildrenUndoable(true);
                }
            }
        }
    }

    private boolean _isLinkInClass(NamedObj context, Port port, Relation relation) {
        boolean portIsInClass;
        boolean bl = port.getContainer() == context ? port.getDerivedLevel() < Integer.MAX_VALUE : (portIsInClass = port.getContainer().getDerivedLevel() < Integer.MAX_VALUE);
        return portIsInClass && (relation == null || relation.getDerivedLevel() < Integer.MAX_VALUE);
    }

    private boolean _isLinkInClass(NamedObj context, Relation relation1, Relation relation2) {
        return relation1.getDerivedLevel() < Integer.MAX_VALUE && relation2.getDerivedLevel() < Integer.MAX_VALUE;
    }

    private boolean _isUndoableElement(String elementName) {
        return elementName.equals("property") || elementName.equals("class") || elementName.equals("doc") || elementName.equals("deleteEntity") || elementName.equals("deletePort") || elementName.equals("deleteProperty") || elementName.equals("deleteRelation") || elementName.equals("display") || elementName.equals("entity") || elementName.equals("group") || elementName.equals("link") || elementName.equals("port") || elementName.equals("relation") || elementName.equals("rename") || elementName.equals("unlink") || elementName.equals("vertex");
    }

    private boolean _loadFileInContext(String fileName, NamedObj context) throws Exception {
        URL xmlFile = this._classLoader.getResource(fileName);
        if (xmlFile == null) {
            return false;
        }
        InputStream input = xmlFile.openStream();
        boolean modified = MoMLParser.isModified();
        MoMLParser newParser = new MoMLParser(this._workspace, this._classLoader);
        newParser.setContext(context);
        MoMLParser.setModified(modified);
        newParser._topObjectsCreated = new LinkedList();
        newParser.parse(this._base, input);
        for (NamedObj newObject : newParser._topObjectsCreated) {
            newObject.setDerivedLevel(1);
            this._markContentsDerived(newObject, 1);
        }
        return true;
    }

    private boolean _loadIconForClass(String className, NamedObj context) throws Exception {
        if (_iconLoader != null) {
            return _iconLoader.loadIconForClass(className, context);
        }
        String fileName = String.valueOf(className.replace('.', '/')) + "Icon.xml";
        return this._loadFileInContext(fileName, context);
    }

    private void _markContentsDerived(NamedObj object, int depth) {
        Iterator objects = object.containedObjectsIterator();
        while (objects.hasNext()) {
            NamedObj containedObject = (NamedObj)objects.next();
            containedObject.setDerivedLevel(depth + 1);
            if (containedObject instanceof Settable) {
                this._paramsToParse.add(containedObject);
            }
            this._markContentsDerived(containedObject, depth + 1);
        }
    }

    private void _markParametersToParse(NamedObj object) {
        Iterator objects = object.containedObjectsIterator();
        while (objects.hasNext()) {
            NamedObj containedObject = (NamedObj)objects.next();
            if (containedObject instanceof Settable) {
                this._paramsToParse.add(containedObject);
            }
            this._markParametersToParse(containedObject);
        }
    }

    private NamedObj _parse(MoMLParser parser, URL base, String source) throws Exception {
        this._xmlFile = this.fileNameToURL(source, base);
        InputStream input = null;
        try {
            input = this._xmlFile.openStream();
            try {
                NamedObj toplevel = parser.parse(this._xmlFile, input);
                input.close();
                NamedObj namedObj = toplevel;
                return namedObj;
            }
            catch (CancelException cancelException) {
                block13: {
                    if (input == null) break block13;
                    try {
                        input.close();
                    }
                    catch (Throwable throwable) {
                        System.out.println("Ignoring failure to close stream on " + this._xmlFile);
                        throwable.printStackTrace();
                    }
                }
                this._xmlFile = null;
                return null;
            }
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (Throwable throwable) {
                    System.out.println("Ignoring failure to close stream on " + this._xmlFile);
                    throwable.printStackTrace();
                }
            }
            this._xmlFile = null;
        }
    }

    private void _processLink(String relation1Name, String relation2Name) throws XmlException, IllegalActionException {
        this._checkClass(this._current, CompositeEntity.class, "Element \"link\" found inside an element that is not a CompositeEntity. It is: " + this._current);
        if (relation1Name == null || relation2Name == null) {
            throw new XmlException("Element link requires two relations.", this._currentExternalEntity(), this._getLineNumber(), this._getColumnNumber());
        }
        CompositeEntity context = (CompositeEntity)this._current;
        ComponentRelation relation1 = context.getRelation(relation1Name);
        this._checkForNull(relation1, "No relation named \"" + relation1Name + "\" in " + context.getFullName());
        ComponentRelation relation2 = context.getRelation(relation2Name);
        this._checkForNull(relation2, "No relation named \"" + relation2Name + "\" in " + context.getFullName());
        if (this._isLinkInClass((NamedObj)context, relation1, (Relation)relation2)) {
            throw new IllegalActionException((Nameable)relation1, relation2, "Cannot link relations when both are part of the class definition.");
        }
        relation1.link(relation2);
        for (ComponentRelation derivedRelation1 : relation1.getDerivedList()) {
            CompositeEntity derivedContext = (CompositeEntity)derivedRelation1.getContainer();
            ComponentRelation derivedRelation2 = derivedContext.getRelation(relation2Name);
            derivedRelation1.link(derivedRelation2);
        }
        if (this._undoEnabled && (relation1.getDerivedLevel() == Integer.MAX_VALUE || relation2.getDerivedLevel() == Integer.MAX_VALUE)) {
            this._undoContext.appendUndoMoML("<group><unlink relation1=\"" + relation1Name + "\" relation2=\"" + relation2Name + "\" /></group>\n");
        }
    }

    private void _processLink(String portName, String relationName, String insertAtSpec, String insertInsideAtSpec) throws XmlException, IllegalActionException {
        this._checkClass(this._current, CompositeEntity.class, "Element \"link\" found inside an element that is not a CompositeEntity. It is: " + this._current);
        int countArgs = 0;
        if (insertAtSpec != null) {
            ++countArgs;
        }
        if (insertInsideAtSpec != null) {
            ++countArgs;
        }
        if (relationName != null) {
            ++countArgs;
        }
        if (countArgs == 0) {
            throw new XmlException("Element link requires at least one of an insertAt, an insertInsideAt, or a relation.", this._currentExternalEntity(), this._getLineNumber(), this._getColumnNumber());
        }
        if (insertAtSpec != null && insertInsideAtSpec != null) {
            throw new XmlException("Element link requires at most one of insertAt and insertInsideAt, not both.", this._currentExternalEntity(), this._getLineNumber(), this._getColumnNumber());
        }
        CompositeEntity context = (CompositeEntity)this._current;
        ComponentPort port = this._getPort(portName, context);
        int origNumOutsideLinks = port.numLinks();
        int origNumInsideLinks = port.numInsideLinks();
        ComponentRelation relation = null;
        if (relationName != null) {
            ComponentRelation tmpRelation = context.getRelation(relationName);
            this._checkForNull(tmpRelation, "No relation named \"" + relationName + "\" in " + context.getFullName());
            relation = tmpRelation;
        }
        if (this._isLinkInClass((NamedObj)context, port, relation)) {
            throw new IllegalActionException((Nameable)port, "Cannot link a port to a relation when both are part of the class definition.");
        }
        int insertAt = -1;
        if (insertAtSpec != null) {
            insertAt = Integer.parseInt(insertAtSpec);
        }
        int insertInsideAt = -1;
        if (insertInsideAtSpec != null) {
            insertInsideAt = Integer.parseInt(insertInsideAtSpec);
        }
        if (insertAtSpec != null) {
            port.insertLink(insertAt, relation);
        } else if (insertInsideAtSpec != null) {
            port.insertInsideLink(insertInsideAt, relation);
        } else {
            port.link(relation);
        }
        if (relation != null) {
            for (ComponentRelation derivedRelation : relation.getDerivedList()) {
                CompositeEntity derivedContext = (CompositeEntity)derivedRelation.getContainer();
                ComponentPort derivedPort = this._getPort(portName, derivedContext);
                if (insertAtSpec != null) {
                    derivedPort.insertLink(insertAt, derivedRelation);
                    continue;
                }
                if (insertInsideAtSpec != null) {
                    derivedPort.insertInsideLink(insertInsideAt, derivedRelation);
                    continue;
                }
                derivedPort.link(derivedRelation);
            }
        } else {
            for (ComponentPort derivedPort : port.getDerivedList()) {
                if (insertAtSpec != null) {
                    derivedPort.insertLink(insertAt, null);
                    continue;
                }
                if (insertInsideAtSpec != null) {
                    derivedPort.insertInsideLink(insertInsideAt, null);
                    continue;
                }
                derivedPort.link(null);
            }
        }
        if (this._undoEnabled) {
            if (relation == null) {
                if (port.getDerivedLevel() == Integer.MAX_VALUE) {
                    if (insertAt != -1) {
                        if (port.numLinks() != origNumOutsideLinks) {
                            this._undoContext.appendUndoMoML("<group><unlink port=\"" + portName + "\" index=\"" + insertAtSpec + "\" /></group>\n");
                        }
                    } else if (port.numInsideLinks() != origNumInsideLinks) {
                        this._undoContext.appendUndoMoML("<group><unlink port=\"" + portName + "\" insideIndex=\"" + insertInsideAtSpec + "\" /></group>\n");
                    }
                }
            } else if (port.getDerivedLevel() == Integer.MAX_VALUE || relation.getDerivedLevel() == Integer.MAX_VALUE) {
                if (port.numInsideLinks() != origNumInsideLinks) {
                    if (insertInsideAt == -1) {
                        insertInsideAt = port.numInsideLinks() - 1;
                    }
                    this._undoContext.appendClosingUndoMoML("<group><unlink port=\"" + portName + "\" insideIndex=\"" + insertInsideAt + "\" /></group>" + "\n");
                } else if (port.numLinks() != origNumOutsideLinks) {
                    if (insertAt == -1) {
                        insertAt = port.numLinks() - 1;
                    }
                    this._undoContext.appendClosingUndoMoML("<group><unlink port=\"" + portName + "\" index=\"" + insertAt + "\" /></group>" + "\n");
                }
            }
        }
    }

    private void _processPendingRequests() throws Exception {
        int reply;
        if (this._linkRequests != null) {
            for (Object request : this._linkRequests) {
                try {
                    ((LinkRequest)request).execute();
                }
                catch (Exception ex) {
                    if (_handler != null) {
                        reply = _handler.handleError(((LinkRequest)request).toString(), this._current, ex);
                        if (reply == 0 || reply != 1) continue;
                        throw new XmlException("*** Canceled.", this._currentExternalEntity(), this._getLineNumber(), this._getColumnNumber());
                    }
                    throw ex;
                }
            }
        }
        if (this._deleteRequests != null) {
            for (Object request : this._deleteRequests) {
                try {
                    ((DeleteRequest)request).execute();
                }
                catch (Exception ex) {
                    if (_handler != null) {
                        reply = _handler.handleError(request.toString(), this._current, ex);
                        if (reply == 0 || reply != 1) continue;
                        throw new XmlException("*** Canceled.", this._currentExternalEntity(), this._getLineNumber(), this._getColumnNumber());
                    }
                    throw ex;
                }
            }
        }
    }

    private void _processUnlink(String relation1Name, String relation2Name) throws XmlException, IllegalActionException {
        if (relation1Name == null || relation2Name == null) {
            throw new XmlException("Element unlink requires two relations.", this._currentExternalEntity(), this._getLineNumber(), this._getColumnNumber());
        }
        CompositeEntity context = (CompositeEntity)this._current;
        ComponentRelation relation1 = context.getRelation(relation1Name);
        this._checkForNull(relation1, "No relation named \"" + relation1Name + "\" in " + context.getFullName());
        ComponentRelation relation2 = context.getRelation(relation2Name);
        this._checkForNull(relation2, "No relation named \"" + relation2Name + "\" in " + context.getFullName());
        if (this._isLinkInClass((NamedObj)context, relation1, (Relation)relation2)) {
            throw new IllegalActionException((Nameable)relation1, relation2, "Cannot unlink relations when both are part of the class definition.");
        }
        relation1.unlink(relation2);
        for (ComponentRelation derivedRelation1 : relation1.getDerivedList()) {
            CompositeEntity derivedContext = (CompositeEntity)derivedRelation1.getContainer();
            ComponentRelation derivedRelation2 = derivedContext.getRelation(relation2Name);
            derivedRelation1.unlink(derivedRelation2);
        }
        if (this._undoEnabled && (relation1.getDerivedLevel() == Integer.MAX_VALUE || relation2.getDerivedLevel() == Integer.MAX_VALUE)) {
            this._undoContext.appendUndoMoML("<link relation1=\"" + relation1Name + "\" relation2=\"" + relation2Name + "\" />\n");
        }
    }

    private void _processUnlink(String portName, String relationName, String indexSpec, String insideIndexSpec) throws XmlException, IllegalActionException {
        this._checkClass(this._current, CompositeEntity.class, "Element \"unlink\" found inside an element that is not a CompositeEntity. It is: " + this._current);
        int countArgs = 0;
        if (indexSpec != null) {
            ++countArgs;
        }
        if (insideIndexSpec != null) {
            ++countArgs;
        }
        if (relationName != null) {
            ++countArgs;
        }
        if (countArgs != 1) {
            throw new XmlException("Element unlink requires exactly one of an index, an insideIndex, or a relation.", this._currentExternalEntity(), this._getLineNumber(), this._getColumnNumber());
        }
        CompositeEntity context = (CompositeEntity)this._current;
        ComponentPort port = this._getPort(portName, context);
        if (relationName != null) {
            ComponentRelation tmpRelation = context.getRelation(relationName);
            this._checkForNull(tmpRelation, "No relation named \"" + relationName + "\" in " + context.getFullName());
            ComponentRelation relation = tmpRelation;
            if (this._isLinkInClass((NamedObj)context, port, (Relation)relation)) {
                throw new IllegalActionException((Nameable)port, "Cannot unlink a port from a relation when both are part of the class definition.");
            }
            if (this._undoEnabled && (port.getDerivedLevel() == Integer.MAX_VALUE || relation.getDerivedLevel() == Integer.MAX_VALUE)) {
                List linkedRelations = port.linkedRelationList();
                int index = linkedRelations.indexOf(tmpRelation);
                if (index != -1) {
                    this._undoContext.appendUndoMoML("<link port=\"" + portName + "\" insertAt=\"" + index + "\" relation=\"" + relationName + "\" />\n");
                } else {
                    List insideLinkedRelations = port.insideRelationList();
                    index = insideLinkedRelations.indexOf(tmpRelation);
                    this._undoContext.appendUndoMoML("<link port=\"" + portName + "\" insertInsideAt=\"" + index + "\" relation=\"" + relationName + "\" />\n");
                }
            }
            for (ComponentRelation derivedRelation : relation.getDerivedList()) {
                CompositeEntity derivedContext = (CompositeEntity)derivedRelation.getContainer();
                ComponentPort derivedPort = this._getPort(portName, derivedContext);
                derivedPort.unlink(derivedRelation);
            }
            port.unlink(relation);
        } else if (indexSpec != null) {
            int index = Integer.parseInt(indexSpec);
            List relationList = port.linkedRelationList();
            if (relationList.size() <= index) {
                throw new IllegalActionException((Nameable)port, "Cannot unlink index " + indexSpec + ", because there is no such link.");
            }
            Relation relation = (Relation)relationList.get(index);
            if (this._isLinkInClass((NamedObj)context, port, relation)) {
                throw new IllegalActionException((Nameable)port, "Cannot unlink a port from a relation when both are part of the class definition.");
            }
            if (this._undoEnabled) {
                List linkedRelations = port.linkedRelationList();
                Relation r = (Relation)linkedRelations.get(index);
                if (port.getDerivedLevel() == Integer.MAX_VALUE || r != null && r.getDerivedLevel() == Integer.MAX_VALUE) {
                    this._undoContext.appendUndoMoML("<link port=\"" + portName + "\" insertAt=\"" + indexSpec + "\" ");
                    if (r != null) {
                        this._undoContext.appendUndoMoML("relation=\"" + r.getName(context) + "\" ");
                    }
                    this._undoContext.appendUndoMoML(" />\n");
                }
            }
            for (ComponentPort derivedPort : port.getDerivedList()) {
                derivedPort.unlink(index);
            }
            port.unlink(index);
        } else {
            int index = Integer.parseInt(insideIndexSpec);
            List relationList = port.insideRelationList();
            Relation relation = (Relation)relationList.get(index);
            if (this._isLinkInClass((NamedObj)context, port, relation)) {
                throw new IllegalActionException((Nameable)port, "Cannot unlink a port from a relation when both are part of the class definition.");
            }
            if (this._undoEnabled) {
                List linkedRelations = port.insideRelationList();
                Relation r = (Relation)linkedRelations.get(index);
                if (port.getDerivedLevel() == Integer.MAX_VALUE || r != null && r.getDerivedLevel() == Integer.MAX_VALUE) {
                    this._undoContext.appendUndoMoML("<link port=\"" + portName + "\" insertInsideAt=\"" + index + "\" ");
                    if (r != null) {
                        this._undoContext.appendUndoMoML("relation=\"" + r.getName(context) + "\" ");
                    }
                    this._undoContext.appendUndoMoML(" />\n");
                }
            }
            for (ComponentPort derivedPort : port.getDerivedList()) {
                derivedPort.unlinkInside(index);
            }
            port.unlinkInside(index);
        }
    }

    private void _pushContext() {
        this._containers.push(this._current);
        this._namespaces.push(this._namespace);
        this._namespace = _DEFAULT_NAMESPACE;
        this._namespaceTranslations.push(this._namespaceTranslationTable);
        this._namespaceTranslationTable = new HashMap();
        this._namespacesPushed = true;
    }

    private void _resetUndo() {
        this._undoContext = null;
        this._undoContexts = new Stack();
        this._undoEnabled = false;
    }

    private Attribute _searchForAttribute(String name) throws XmlException {
        Attribute result = null;
        String currentName = "(no top level)";
        if (this._current != null) {
            currentName = this._current.getFullName();
        }
        if (this._current != null && name.startsWith(currentName)) {
            int prefix = currentName.length();
            if (name.length() > prefix) {
                name = name.substring(prefix + 1);
            }
        }
        if ((result = this._current.getAttribute(name)) == null) {
            throw new XmlException("No such property: " + name + " in " + currentName, this._currentExternalEntity(), this._getLineNumber(), this._getColumnNumber());
        }
        return result;
    }

    private ComponentEntity _searchForClassInContext(String name, String source) throws Exception {
        ComponentEntity candidate = this._searchForEntity(name, this._current);
        NamedObj context = this._current;
        while (!(candidate != null && candidate.isClassDefinition() || context == null)) {
            if (!((context = context.getContainer()) instanceof CompositeEntity)) continue;
            candidate = ((CompositeEntity)context).getEntity(name);
        }
        if (candidate != null && candidate.isClassDefinition()) {
            URL candidateSourceURL;
            URL sourceURL;
            String candidateSource = candidate.getSource();
            if (source == null && candidateSource == null) {
                return candidate;
            }
            if (source != null && candidateSource != null && (sourceURL = this.fileNameToURL(source, this._base)).equals(candidateSourceURL = this.fileNameToURL(candidateSource, this._base))) {
                return candidate;
            }
        }
        return null;
    }

    private ComponentEntity _searchForEntity(String name, NamedObj context) throws XmlException {
        if (name.startsWith(".")) {
            int nextPeriod = name.indexOf(".", 1);
            String topLevelName = nextPeriod < 1 ? name.substring(1) : name.substring(1, nextPeriod);
            if (this._toplevel != null && this._toplevel instanceof ComponentEntity && topLevelName.equals(this._toplevel.getName())) {
                ComponentEntity result;
                if (nextPeriod < 1) {
                    return (ComponentEntity)this._toplevel;
                }
                if (name.length() > nextPeriod + 1 && (result = ((CompositeEntity)this._toplevel).getEntity(name.substring(nextPeriod + 1))) != null) {
                    return result;
                }
            }
            return null;
        }
        if (context instanceof CompositeEntity) {
            ComponentEntity result = ((CompositeEntity)context).getEntity(name);
            return result;
        }
        if (context == null) {
            return this._searchForEntity("." + name, null);
        }
        return null;
    }

    private Port _searchForPort(String name) throws XmlException {
        Port result = null;
        String topLevelName = "(no top level)";
        if (this._toplevel != null) {
            topLevelName = this._toplevel.getFullName();
        }
        if (this._toplevel != null && name.startsWith(topLevelName)) {
            int prefix = topLevelName.length();
            if (name.length() > prefix) {
                name = name.substring(1, name.length());
            }
        }
        if (this._current instanceof Entity) {
            result = ((Entity)this._current).getPort(name);
        }
        if (result == null) {
            throw new XmlException("No such port: " + name + " in " + topLevelName, this._currentExternalEntity(), this._getLineNumber(), this._getColumnNumber());
        }
        return result;
    }

    private ComponentRelation _searchForRelation(String name) throws XmlException {
        ComponentRelation result = null;
        String topLevelName = "(no top level)";
        if (this._toplevel != null) {
            topLevelName = this._toplevel.getFullName();
        }
        if (this._toplevel != null && name.startsWith(topLevelName)) {
            int prefix = topLevelName.length();
            if (name.length() > prefix) {
                name = name.substring(1, name.length());
            }
        }
        if (this._current instanceof CompositeEntity) {
            result = ((CompositeEntity)this._current).getRelation(name);
        }
        if (result == null) {
            throw new XmlException("No such relation: " + name + " in " + topLevelName, this._currentExternalEntity(), this._getLineNumber(), this._getColumnNumber());
        }
        return result;
    }

    private class DeleteRequest {
        private int _type;
        private String _name;
        private String _context;

        public DeleteRequest(int type, String name, String context) {
            this._type = type;
            this._name = name;
            this._context = context;
        }

        public NamedObj execute() throws Exception {
            if (this._type == _DELETE_ENTITY) {
                return MoMLParser.this._deleteEntity(this._name);
            }
            if (this._type == _DELETE_PORT) {
                return MoMLParser.this._deletePort(this._name, this._context);
            }
            if (this._type == _DELETE_PROPERTY) {
                return MoMLParser.this._deleteProperty(this._name);
            }
            return MoMLParser.this._deleteRelation(this._name);
        }
    }

    private class LinkRequest {
        protected String _portName;
        protected String _relationName;
        protected String _relation2Name;
        protected String _indexSpec;
        protected String _insideIndexSpec;

        public LinkRequest(String relation1Name, String relation2Name) {
            this._relationName = relation1Name;
            this._relation2Name = relation2Name;
        }

        public LinkRequest(String portName, String relationName, String insertAtSpec, String insertInsideAtSpec) {
            this._portName = portName;
            this._relationName = relationName;
            this._indexSpec = insertAtSpec;
            this._insideIndexSpec = insertInsideAtSpec;
        }

        public void execute() throws IllegalActionException, XmlException {
            if (this._portName != null) {
                MoMLParser.this._processLink(this._portName, this._relationName, this._indexSpec, this._insideIndexSpec);
            } else {
                MoMLParser.this._processLink(this._relationName, this._relation2Name);
            }
        }

        public String toString() {
            if (this._portName != null) {
                return "link " + this._portName + " to " + this._relationName;
            }
            return "link " + this._relationName + " to " + this._relation2Name;
        }
    }

    private class UnlinkRequest
    extends LinkRequest {
        public UnlinkRequest(String portName, String relationName, String indexSpec, String insideIndexSpec) {
            super(portName, relationName, indexSpec, insideIndexSpec);
        }

        public UnlinkRequest(String relation1Name, String relation2Name) {
            super(relation1Name, relation2Name);
        }

        public void execute() throws IllegalActionException, XmlException {
            if (this._portName != null) {
                MoMLParser.this._processUnlink(this._portName, this._relationName, this._indexSpec, this._insideIndexSpec);
            } else {
                MoMLParser.this._processUnlink(this._relationName, this._relation2Name);
            }
        }

        public String toString() {
            return "unlink " + this._portName + " from " + this._relationName;
        }
    }
}

