/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.moml;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import ptolemy.kernel.util.ChangeRequest;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Settable;
import ptolemy.kernel.util.StringAttribute;
import ptolemy.util.StringUtilities;

public class Documentation
extends StringAttribute {
    public Documentation(NamedObj container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.setVisibility(Settable.EXPERT);
    }

    public static String consolidate(NamedObj object) {
        List docList = object.attributeList(Documentation.class);
        if (docList.size() > 0) {
            StringBuffer doc = new StringBuffer();
            Iterator segments = docList.iterator();
            while (segments.hasNext()) {
                Documentation segment = (Documentation)segments.next();
                doc.append(segment.getValueAsString());
                if (!segments.hasNext()) continue;
                doc.append("\n");
            }
            return doc.toString();
        }
        return null;
    }

    public void exportMoML(Writer output, int depth, String name) throws IOException {
        if (this._isMoMLSuppressed(depth)) {
            return;
        }
        if (name.equals("_doc")) {
            output.write(String.valueOf(Documentation._getIndentPrefix(depth)) + "<doc>" + StringUtilities.escapeForXML(this.getExpression()) + "</doc>\n");
        } else {
            output.write(String.valueOf(Documentation._getIndentPrefix(depth)) + "<doc name=\"" + name + "\">" + StringUtilities.escapeForXML(this.getExpression()) + "</doc>\n");
        }
    }

    public void setExpression(String expression) throws IllegalActionException {
        if (expression.equals("")) {
            ChangeRequest request = new ChangeRequest(this, "Delete empty doc tag."){

                protected void _execute() throws Exception {
                    Documentation.this.setContainer(null);
                }
            };
            this.requestChange(request);
        } else {
            super.setExpression(expression);
        }
    }

    public void setValue(String value) {
        try {
            this.setExpression(value);
        }
        catch (IllegalActionException e) {
            throw new InternalErrorException(e);
        }
    }

    public String toString() {
        return "(" + this.getClass().getName() + ", " + this.getExpression() + ")";
    }
}

