/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.math;

import java.math.BigDecimal;
import ptolemy.math.FixPoint;
import ptolemy.math.FixPointQuantization;
import ptolemy.math.Overflow;
import ptolemy.math.Precision;
import ptolemy.math.Quantization;
import ptolemy.math.Rounding;

public class Quantizer {
    public static final Overflow SATURATE = Overflow.SATURATE;
    public static final Overflow OVERFLOW_TO_ZERO = Overflow.TO_ZERO;

    private Quantizer() {
    }

    public static FixPoint round(double value, Precision precision) {
        FixPointQuantization q = new FixPointQuantization(precision, Overflow.SATURATE, Rounding.NEAREST);
        return new FixPoint(new BigDecimal(value), (Quantization)q);
    }

    public static FixPoint round(BigDecimal value, Precision precision) {
        FixPointQuantization q = new FixPointQuantization(precision, Overflow.SATURATE, Rounding.NEAREST);
        return new FixPoint(value, (Quantization)q);
    }

    public static FixPoint round(FixPoint value, Precision newPrecision, Overflow mode) {
        FixPointQuantization q = new FixPointQuantization(newPrecision, mode, Rounding.NEAREST);
        return value.quantize(q);
    }

    public static FixPoint roundDown(double value, Precision precision) {
        FixPointQuantization q = new FixPointQuantization(precision, Overflow.SATURATE, Rounding.DOWN);
        return new FixPoint(new BigDecimal(value), (Quantization)q);
    }

    public static FixPoint roundDown(BigDecimal value, Precision precision) {
        FixPointQuantization q = new FixPointQuantization(precision, Overflow.SATURATE, Rounding.DOWN);
        return new FixPoint(value, (Quantization)q);
    }

    public static FixPoint roundDown(FixPoint value, Precision newPrecision, Overflow mode) {
        FixPointQuantization q = new FixPointQuantization(newPrecision, mode, Rounding.DOWN);
        return value.quantize(q);
    }

    public static FixPoint roundNearestEven(double value, Precision precision) {
        FixPointQuantization q = new FixPointQuantization(precision, Overflow.SATURATE, Rounding.HALF_EVEN);
        return new FixPoint(new BigDecimal(value), (Quantization)q);
    }

    public static FixPoint roundNearestEven(BigDecimal value, Precision precision) {
        FixPointQuantization q = new FixPointQuantization(precision, Overflow.SATURATE, Rounding.HALF_EVEN);
        return new FixPoint(value, (Quantization)q);
    }

    public static FixPoint roundNearestEven(FixPoint value, Precision newPrecision, Overflow mode) {
        FixPointQuantization q = new FixPointQuantization(newPrecision, mode, Rounding.HALF_EVEN);
        return value.quantize(q);
    }

    public static FixPoint roundToZero(double value, Precision precision) {
        FixPointQuantization q = new FixPointQuantization(precision, Overflow.SATURATE, Rounding.DOWN);
        return new FixPoint(new BigDecimal(value), (Quantization)q);
    }

    public static FixPoint roundToZero(BigDecimal value, Precision precision) {
        FixPointQuantization q = new FixPointQuantization(precision, Overflow.SATURATE, Rounding.DOWN);
        return new FixPoint(value, (Quantization)q);
    }

    public static FixPoint roundToZero(FixPoint value, Precision newPrecision, Overflow mode) {
        FixPointQuantization q = new FixPointQuantization(newPrecision, mode, Rounding.DOWN);
        return value.quantize(q);
    }

    public static FixPoint roundUp(double value, Precision precision) {
        FixPointQuantization q = new FixPointQuantization(precision, Overflow.SATURATE, Rounding.UP);
        return new FixPoint(new BigDecimal(value), (Quantization)q);
    }

    public static FixPoint roundUp(BigDecimal value, Precision precision) {
        FixPointQuantization q = new FixPointQuantization(precision, Overflow.SATURATE, Rounding.UP);
        return new FixPoint(value, (Quantization)q);
    }

    public static FixPoint roundUp(FixPoint value, Precision newPrecision, Overflow mode) {
        FixPointQuantization q = new FixPointQuantization(newPrecision, mode, Rounding.UP);
        return value.quantize(q);
    }

    public static FixPoint truncate(double value, Precision precision) {
        FixPointQuantization q = new FixPointQuantization(precision, Overflow.SATURATE, Rounding.TRUNCATE);
        return new FixPoint(new BigDecimal(value), (Quantization)q);
    }

    public static FixPoint truncate(BigDecimal value, Precision precision) {
        FixPointQuantization q = new FixPointQuantization(precision, Overflow.SATURATE, Rounding.TRUNCATE);
        return new FixPoint(value, (Quantization)q);
    }

    public static FixPoint truncate(FixPoint value, Precision newPrecision, Overflow mode) {
        FixPointQuantization q = new FixPointQuantization(newPrecision, mode, Rounding.TRUNCATE);
        return value.quantize(q);
    }
}

