/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.math;

import ptolemy.math.Complex;
import ptolemy.math.LongBinaryOperation;
import ptolemy.math.LongUnaryOperation;

public class LongArrayMath {
    protected LongArrayMath() {
    }

    public static final long[] add(long[] array, long z) {
        int length = array.length;
        long[] returnValue = new long[length];
        int i = 0;
        while (i < length) {
            returnValue[i] = array[i] + z;
            ++i;
        }
        return returnValue;
    }

    public static final long[] add(long[] array1, long[] array2) {
        int length = LongArrayMath._commonLength(array1, array2, "LongArrayMath.add");
        long[] returnValue = new long[length];
        int i = 0;
        while (i < length) {
            returnValue[i] = array1[i] + array2[i];
            ++i;
        }
        return returnValue;
    }

    public static final long[] allocCopy(long[] array) {
        int elements = array.length;
        long[] newArray = new long[elements];
        System.arraycopy(array, 0, newArray, 0, elements);
        return newArray;
    }

    public static final long[] append(long[] array1, long[] array2) {
        return LongArrayMath.append(array1, 0, array1.length, array2, 0, array2.length);
    }

    public static final long[] append(long[] array1, int idx1, int length1, long[] array2, int idx2, int length2) {
        long[] returnValue = new long[length1 + length2];
        if (length1 > 0) {
            System.arraycopy(array1, idx1, returnValue, 0, length1);
        }
        if (length2 > 0) {
            System.arraycopy(array2, idx2, returnValue, length1, length2);
        }
        return returnValue;
    }

    public static final long[] applyBinaryOperation(LongBinaryOperation op, long[] array, long z) {
        int length = array.length;
        long[] returnValue = new long[length];
        int i = 0;
        while (i < length) {
            returnValue[i] = op.operate(array[i], z);
            ++i;
        }
        return returnValue;
    }

    public static final long[] applyBinaryOperation(LongBinaryOperation op, long z, long[] array) {
        int length = array.length;
        long[] returnValue = new long[length];
        int i = 0;
        while (i < length) {
            returnValue[i] = op.operate(array[i], z);
            ++i;
        }
        return returnValue;
    }

    public static final long[] applyBinaryOperation(LongBinaryOperation op, long[] array1, long[] array2) {
        int length = LongArrayMath._commonLength(array1, array2, "LongArrayMath.applyBinaryOperation");
        long[] returnValue = new long[length];
        int i = 0;
        while (i < length) {
            returnValue[i] = op.operate(array1[i], array2[i]);
            ++i;
        }
        return returnValue;
    }

    public static final long[] applyUnaryOperation(LongUnaryOperation op, long[] array) {
        int length = array.length;
        long[] returnValue = new long[length];
        int i = 0;
        while (i < length) {
            returnValue[i] = op.operate(array[i]);
            ++i;
        }
        return returnValue;
    }

    public static final long[] bitwiseAnd(long[] array, long z) {
        int length = array.length;
        long[] returnValue = new long[length];
        int i = 0;
        while (i < length) {
            returnValue[i] = array[i] & z;
            ++i;
        }
        return returnValue;
    }

    public static final long[] bitwiseAnd(long[] array1, long[] array2) {
        int length = LongArrayMath._commonLength(array1, array2, "LongArrayMath.bitwiseAnd");
        long[] returnValue = new long[length];
        int i = 0;
        while (i < length) {
            returnValue[i] = array1[i] & array2[i];
            ++i;
        }
        return returnValue;
    }

    public static final long[] bitwiseComplement(long[] array) {
        int length = array.length;
        long[] returnValue = new long[length];
        int i = 0;
        while (i < length) {
            returnValue[i] = array[i] ^ 0xFFFFFFFFFFFFFFFFL;
            ++i;
        }
        return returnValue;
    }

    public static final long[] bitwiseOr(long[] array, long z) {
        int length = array.length;
        long[] returnValue = new long[length];
        int i = 0;
        while (i < length) {
            returnValue[i] = array[i] | z;
            ++i;
        }
        return returnValue;
    }

    public static final long[] bitwiseOr(long[] array1, long[] array2) {
        int length = LongArrayMath._commonLength(array1, array2, "LongArrayMath.bitwiseOr");
        long[] returnValue = new long[length];
        int i = 0;
        while (i < length) {
            returnValue[i] = array1[i] | array2[i];
            ++i;
        }
        return returnValue;
    }

    public static final long[] bitwiseXor(long[] array, long z) {
        int length = array.length;
        long[] returnValue = new long[length];
        int i = 0;
        while (i < length) {
            returnValue[i] = array[i] ^ z;
            ++i;
        }
        return returnValue;
    }

    public static final long[] bitwiseXor(long[] array1, long[] array2) {
        int length = LongArrayMath._commonLength(array1, array2, "LongArrayMath.bitwiseXor");
        long[] returnValue = new long[length];
        int i = 0;
        while (i < length) {
            returnValue[i] = array1[i] ^ array2[i];
            ++i;
        }
        return returnValue;
    }

    public static final long[] divide(long[] array, long z) {
        int length = array.length;
        long[] returnValue = new long[length];
        int i = 0;
        while (i < length) {
            returnValue[i] = array[i] / z;
            ++i;
        }
        return returnValue;
    }

    public static final long[] divideElements(long[] array1, long[] array2) {
        int length = LongArrayMath._commonLength(array1, array2, "LongArrayMath.divideElements");
        long[] returnValue = new long[length];
        int i = 0;
        while (i < length) {
            returnValue[i] = array1[i] / array2[i];
            ++i;
        }
        return returnValue;
    }

    public static final long dotProduct(long[] array1, long[] array2) {
        int length = LongArrayMath._commonLength(array1, array2, "LongArrayMath.dotProduct");
        long sum = 0L;
        int i = 0;
        while (i < length) {
            sum += array1[i] * array2[i];
            ++i;
        }
        return sum;
    }

    public static final long[] limit(long[] array, long bottom, long top) {
        long[] returnValue = new long[array.length];
        int i = 0;
        while (i < array.length) {
            returnValue[i] = array[i] > top || array[i] == Long.MAX_VALUE ? top : (array[i] < bottom || array[i] == Long.MIN_VALUE ? bottom : array[i]);
            ++i;
        }
        return returnValue;
    }

    public static final long[] modulo(long[] array, long z) {
        int length = array.length;
        long[] returnValue = new long[length];
        int i = 0;
        while (i < length) {
            returnValue[i] = array[i] % z;
            ++i;
        }
        return returnValue;
    }

    public static final long[] modulo(long[] array1, long[] array2) {
        int length = LongArrayMath._commonLength(array1, array2, "LongArrayMath.modulo");
        long[] returnValue = new long[length];
        int i = 0;
        while (i < length) {
            returnValue[i] = array1[i] % array2[i];
            ++i;
        }
        return returnValue;
    }

    public static final long[] multiply(long[] array1, long[] array2) {
        int length = LongArrayMath._commonLength(array1, array2, "LongArrayMath.multiply");
        long[] returnValue = new long[length];
        int i = 0;
        while (i < length) {
            returnValue[i] = array1[i] * array2[i];
            ++i;
        }
        return returnValue;
    }

    public static final long[] multiply(long[] array, long factor) {
        int length = array.length;
        long[] returnValue = new long[length];
        int i = 0;
        while (i < length) {
            returnValue[i] = array[i] * factor;
            ++i;
        }
        return returnValue;
    }

    public static final long[] negative(long[] array) {
        int length = array.length;
        long[] returnValue = new long[length];
        int i = 0;
        while (i < length) {
            returnValue[i] = -array[i];
            ++i;
        }
        return returnValue;
    }

    public static final long[] padMiddle(long[] array, int newLength) {
        int length = array.length;
        int entriesNeeded = newLength - length;
        if (entriesNeeded < 0) {
            throw new IllegalArgumentException("ptolemy.math.LongArrayMath.padMiddle() : newLength must be >= length of array.");
        }
        if (entriesNeeded == 0) {
            return LongArrayMath.resize(array, newLength);
        }
        double halfLength = (double)length * 0.5;
        int halfLengthFloor = (int)Math.floor(halfLength);
        int halfLengthCeil = (int)Math.ceil(halfLength);
        long[] returnValue = new long[newLength];
        System.arraycopy(array, 0, returnValue, 0, halfLengthCeil);
        System.arraycopy(array, halfLengthFloor, returnValue, newLength - halfLengthCeil, halfLengthCeil);
        return returnValue;
    }

    public static final long[] resize(long[] array, int newLength) {
        return LongArrayMath.resize(array, newLength, 0);
    }

    public static final long[] resize(long[] array, int newLength, int startIdx) {
        long[] returnValue = new long[newLength];
        int copySize = Math.min(newLength, array.length - startIdx);
        if (startIdx >= array.length && copySize > 0) {
            throw new IllegalArgumentException("resize():  the start index '" + startIdx + "' is greather than equal to the array length '" + array.length + "' and the number of items to be copied '" + copySize + "' is greater than zero.");
        }
        if (copySize > 0) {
            System.arraycopy(array, startIdx, returnValue, 0, copySize);
        }
        return returnValue;
    }

    public static final long[] scale(long[] array, long scaleFactor) {
        long[] returnValue = new long[array.length];
        int i = 0;
        while (i < array.length) {
            returnValue[i] = scaleFactor * array[i];
            ++i;
        }
        return returnValue;
    }

    public static final long[] shiftArithmetic(long[] array, int shiftAmount) {
        long[] returnValue;
        block3: {
            block2: {
                returnValue = new long[array.length];
                if (shiftAmount < 0) break block2;
                int i = 0;
                while (i < array.length) {
                    returnValue[i] = array[i] << shiftAmount;
                    ++i;
                }
                break block3;
            }
            if (shiftAmount >= 0) break block3;
            int i = 0;
            while (i < array.length) {
                returnValue[i] = array[i] >>> -shiftAmount;
                ++i;
            }
        }
        return returnValue;
    }

    public static final long[] shiftLogical(long[] array, int shiftAmount) {
        long[] returnValue;
        block3: {
            block2: {
                returnValue = new long[array.length];
                if (shiftAmount < 0) break block2;
                int i = 0;
                while (i < array.length) {
                    returnValue[i] = array[i] << shiftAmount;
                    ++i;
                }
                break block3;
            }
            if (shiftAmount >= 0) break block3;
            int i = 0;
            while (i < array.length) {
                returnValue[i] = array[i] >> -shiftAmount;
                ++i;
            }
        }
        return returnValue;
    }

    public static final long[] subtract(long[] array1, long[] array2) {
        int length = LongArrayMath._commonLength(array1, array2, "LongArrayMath.subtract");
        long[] returnValue = new long[length];
        int i = 0;
        while (i < length) {
            returnValue[i] = array1[i] - array2[i];
            ++i;
        }
        return returnValue;
    }

    public static final long sumOfSquares(long[] array) {
        long sum = 0L;
        int i = 0;
        while (i < array.length) {
            sum += array[i] * array[i];
            ++i;
        }
        return sum;
    }

    public static final Complex[] toComplexArray(long[] array) {
        int length = array.length;
        Complex[] returnValue = new Complex[length];
        int i = 0;
        while (i < length) {
            returnValue[i] = new Complex(array[i], 0.0);
            ++i;
        }
        return returnValue;
    }

    public static final double[] toDoubleArray(long[] array) {
        int length = array.length;
        double[] returnValue = new double[length];
        int i = 0;
        while (i < length) {
            returnValue[i] = array[i];
            ++i;
        }
        return returnValue;
    }

    public static final float[] toFloatArray(long[] array) {
        int length = array.length;
        float[] returnValue = new float[length];
        int i = 0;
        while (i < length) {
            returnValue[i] = array[i];
            ++i;
        }
        return returnValue;
    }

    public static final int[] toIntegerArray(long[] array) {
        int length = array.length;
        int[] returnValue = new int[length];
        int i = 0;
        while (i < length) {
            returnValue[i] = (int)array[i];
            ++i;
        }
        return returnValue;
    }

    public static final String toString(long[] array) {
        return LongArrayMath.toString(array, ", ", "{", "}");
    }

    public static final String toString(long[] array, String elementDelimiter, String vectorBegin, String vectorEnd) {
        int length = array.length;
        StringBuffer sb = new StringBuffer();
        sb.append(vectorBegin);
        int i = 0;
        while (i < length) {
            sb.append(Long.toString(array[i]));
            if (i < length - 1) {
                sb.append(elementDelimiter);
            }
            ++i;
        }
        sb.append(vectorEnd);
        return new String(sb);
    }

    public static final boolean within(long[] array1, long[] array2, long maxError) {
        int length = LongArrayMath._commonLength(array1, array2, "LongArrayMath.within");
        int i = 0;
        while (i < length) {
            if (array1[i] > array2[i] + maxError || array1[i] < array2[i] - maxError) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static final boolean within(long[] array1, long[] array2, long[] maxError) {
        int length = LongArrayMath._commonLength(array1, array2, "LongArrayMath.within");
        int i = 0;
        while (i < length) {
            if (array1[i] > array2[i] + maxError[i] || array1[i] < array2[i] - maxError[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected static final int _commonLength(long[] array1, long[] array2, String methodName) {
        if (array1 == null) {
            throw new IllegalArgumentException("ptolemy.math." + methodName + "() : first input array is null.");
        }
        if (array2 == null) {
            throw new IllegalArgumentException("ptolemy.math." + methodName + "() : second input array is null.");
        }
        if (array1.length != array2.length) {
            throw new IllegalArgumentException("ptolemy.math." + methodName + "() : input arrays must have the same length, " + "but the first array has length " + array1.length + " and the second array has length " + array2.length + ".");
        }
        return array1.length;
    }
}

