/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.math;

import ptolemy.math.Fraction;

public class FractionArrayMath {
    protected FractionArrayMath() {
    }

    public static final Fraction[] add(Fraction[] array, Fraction z) {
        int length = array.length;
        Fraction[] returnValue = new Fraction[length];
        int i = 0;
        while (i < length) {
            returnValue[i] = array[i].add(z);
            ++i;
        }
        return returnValue;
    }

    public static final Fraction[] add(Fraction[] array1, Fraction[] array2) {
        int length = FractionArrayMath._commonLength(array1, array2, "FractionArrayMath.add");
        Fraction[] returnValue = new Fraction[length];
        int i = 0;
        while (i < length) {
            returnValue[i] = array1[i].add(array2[i]);
            ++i;
        }
        return returnValue;
    }

    public static final Fraction[] allocCopy(Fraction[] array) {
        int elements = array.length;
        Fraction[] newArray = new Fraction[elements];
        System.arraycopy(array, 0, newArray, 0, elements);
        return newArray;
    }

    public static final Fraction[] append(Fraction[] array1, Fraction[] array2) {
        return FractionArrayMath.append(array1, 0, array1.length, array2, 0, array2.length);
    }

    public static final Fraction[] append(Fraction[] array1, int idx1, int length1, Fraction[] array2, int idx2, int length2) {
        Fraction[] returnValue = new Fraction[length1 + length2];
        if (length1 > 0) {
            System.arraycopy(array1, idx1, returnValue, 0, length1);
        }
        if (length2 > 0) {
            System.arraycopy(array2, idx2, returnValue, length1, length2);
        }
        return returnValue;
    }

    public static final Fraction[] divide(Fraction[] num, Fraction[] den) {
        int length = FractionArrayMath._commonLength(num, den, "divide");
        Fraction[] returnValue = new Fraction[length];
        int i = 0;
        while (i < length) {
            returnValue[i] = num[i].divide(den[i]);
            ++i;
        }
        return returnValue;
    }

    public static final Fraction dotProduct(Fraction[] array1, Fraction[] array2) {
        int length = FractionArrayMath._commonLength(array1, array2, "FractionArrayMath.dotProduct");
        Fraction sum = new Fraction(0, 1);
        int i = 0;
        while (i < length) {
            sum = sum.add(array1[i].multiply(array2[i]));
            ++i;
        }
        return sum;
    }

    public static final boolean equals(Fraction[] array1, Fraction[] array2) {
        boolean output = true;
        if (array1.length != array2.length) {
            output = false;
        } else {
            int i = 0;
            while (i < array1.length) {
                output = output && array1[i].equals(array2[i]);
                ++i;
            }
        }
        return output;
    }

    public static final Fraction[] multiply(Fraction[] array1, Fraction[] array2) {
        int length = FractionArrayMath._commonLength(array1, array2, "FractionArrayMath.multiply");
        Fraction[] returnValue = new Fraction[length];
        int i = 0;
        while (i < length) {
            returnValue[i] = array1[i].multiply(array2[i]);
            ++i;
        }
        return returnValue;
    }

    public static final Fraction[] multiply(Fraction[] array, Fraction factor) {
        int length = array.length;
        Fraction[] returnValue = new Fraction[length];
        int i = 0;
        while (i < length) {
            returnValue[i] = array[i].multiply(factor);
            ++i;
        }
        return returnValue;
    }

    public static final Fraction[] negative(Fraction[] array) {
        int length = array.length;
        Fraction[] returnValue = new Fraction[length];
        int i = 0;
        while (i < length) {
            returnValue[i] = array[i].negate();
            ++i;
        }
        return returnValue;
    }

    public static final Fraction[] subtract(Fraction[] array1, Fraction[] array2) {
        int length = FractionArrayMath._commonLength(array1, array2, "FractionArrayMath.subtract");
        Fraction[] returnValue = new Fraction[length];
        int i = 0;
        while (i < length) {
            returnValue[i] = array1[i].subtract(array2[i]);
            ++i;
        }
        return returnValue;
    }

    public static final Fraction sum(Fraction[] array) {
        Fraction sum = new Fraction(0, 1);
        int i = 0;
        while (i < array.length) {
            sum = sum.add(array[i]);
            ++i;
        }
        return sum;
    }

    public static final double[] toDoubleArray(Fraction[] array) {
        int length = array.length;
        double[] returnValue = new double[length];
        int i = 0;
        while (i < length) {
            returnValue[i] = array[i].toDouble();
            ++i;
        }
        return returnValue;
    }

    public static final String toString(Fraction[] array) {
        return FractionArrayMath.toString(array, ", ", "{", "}");
    }

    public static final String toString(Fraction[] array, String elementDelimiter, String vectorBegin, String vectorEnd) {
        int length = array.length;
        StringBuffer sb = new StringBuffer();
        sb.append(vectorBegin);
        int i = 0;
        while (i < length) {
            sb.append(array[i].toString());
            if (i < length - 1) {
                sb.append(elementDelimiter);
            }
            ++i;
        }
        sb.append(vectorEnd);
        return new String(sb);
    }

    protected static final int _commonLength(Fraction[] array1, Fraction[] array2, String methodName) {
        if (array1 == null) {
            throw new IllegalArgumentException("ptolemy.math." + methodName + "() : first input array is null.");
        }
        if (array2 == null) {
            throw new IllegalArgumentException("ptolemy.math." + methodName + "() : second input array is null.");
        }
        if (array1.length != array2.length) {
            throw new IllegalArgumentException("ptolemy.math." + methodName + "() : input arrays must have the same length, " + "but the first array has length " + array1.length + " and the second array has length " + array2.length + ".");
        }
        return array1.length;
    }
}

