/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.math;

import ptolemy.math.Complex;
import ptolemy.math.FloatBinaryOperation;
import ptolemy.math.FloatUnaryOperation;

public class FloatArrayMath {
    protected FloatArrayMath() {
    }

    public static final float[] add(float[] array, float z) {
        int length = array.length;
        float[] returnValue = new float[length];
        int i = 0;
        while (i < length) {
            returnValue[i] = array[i] + z;
            ++i;
        }
        return returnValue;
    }

    public static final float[] add(float[] array1, float[] array2) {
        int length = FloatArrayMath._commonLength(array1, array2, "FloatArrayMath.add");
        float[] returnValue = new float[length];
        int i = 0;
        while (i < length) {
            returnValue[i] = array1[i] + array2[i];
            ++i;
        }
        return returnValue;
    }

    public static final float[] append(float[] array1, float[] array2) {
        return FloatArrayMath.append(array1, 0, array1.length, array2, 0, array2.length);
    }

    public static final float[] append(float[] array1, int idx1, int length1, float[] array2, int idx2, int length2) {
        float[] returnValue = new float[length1 + length2];
        if (length1 > 0) {
            System.arraycopy(array1, idx1, returnValue, 0, length1);
        }
        if (length2 > 0) {
            System.arraycopy(array2, idx2, returnValue, length1, length2);
        }
        return returnValue;
    }

    public static final float[] applyBinaryOperation(FloatBinaryOperation op, float[] array, float z) {
        int length = array.length;
        float[] returnValue = new float[length];
        int i = 0;
        while (i < length) {
            returnValue[i] = op.operate(array[i], z);
            ++i;
        }
        return returnValue;
    }

    public static final float[] applyBinaryOperation(FloatBinaryOperation op, float z, float[] array) {
        int length = array.length;
        float[] returnValue = new float[length];
        int i = 0;
        while (i < length) {
            returnValue[i] = op.operate(array[i], z);
            ++i;
        }
        return returnValue;
    }

    public static final float[] applyBinaryOperation(FloatBinaryOperation op, float[] array1, float[] array2) {
        int length = FloatArrayMath._commonLength(array1, array2, "FloatArrayMath.applyBinaryOperation");
        float[] returnValue = new float[length];
        int i = 0;
        while (i < length) {
            returnValue[i] = op.operate(array1[i], array2[i]);
            ++i;
        }
        return returnValue;
    }

    public static final float[] applyUnaryOperation(FloatUnaryOperation op, float[] array) {
        int length = array.length;
        float[] returnValue = new float[length];
        int i = 0;
        while (i < length) {
            returnValue[i] = op.operate(array[i]);
            ++i;
        }
        return returnValue;
    }

    public static final float[] divideElements(float[] array1, float[] array2) {
        int length = FloatArrayMath._commonLength(array1, array2, "FloatArrayMath.divideElements");
        float[] returnValue = new float[length];
        int i = 0;
        while (i < length) {
            returnValue[i] = array1[i] / array2[i];
            ++i;
        }
        return returnValue;
    }

    public static final float[] divide(float[] array, float num) {
        float[] returnValue = new float[array.length];
        int i = 0;
        while (i < array.length) {
            returnValue[i] = array[i] / num;
            ++i;
        }
        return returnValue;
    }

    public static final float dotProduct(float[] array1, float[] array2) {
        int length = FloatArrayMath._commonLength(array1, array2, "FloatArrayMath.dotProduct");
        float sum = 0.0f;
        int i = 0;
        while (i < length) {
            sum += array1[i] * array2[i];
            ++i;
        }
        return sum;
    }

    public static final float l2norm(float[] array) {
        return (float)Math.sqrt(FloatArrayMath.sumOfSquares(array));
    }

    public static final float[] limit(float[] array, float bottom, float top) {
        float[] returnValue = new float[array.length];
        int i = 0;
        while (i < array.length) {
            returnValue[i] = array[i] > top || array[i] == Float.POSITIVE_INFINITY ? top : (array[i] < bottom || array[i] == Float.NEGATIVE_INFINITY ? bottom : array[i]);
            ++i;
        }
        return returnValue;
    }

    public static final float[] multiply(float[] array1, float[] array2) {
        int length = FloatArrayMath._commonLength(array1, array2, "FloatArrayMath.multiply");
        float[] returnValue = new float[length];
        int i = 0;
        while (i < length) {
            returnValue[i] = array1[i] * array2[i];
            ++i;
        }
        return returnValue;
    }

    public static final float[] multiply(float[] array, float factor) {
        int length = array.length;
        float[] returnValue = new float[length];
        int i = 0;
        while (i < length) {
            returnValue[i] = array[i] * factor;
            ++i;
        }
        return returnValue;
    }

    public static final float[] negative(float[] array) {
        int length = array.length;
        float[] returnValue = new float[length];
        int i = 0;
        while (i < length) {
            returnValue[i] = -array[i];
            ++i;
        }
        return returnValue;
    }

    public static final float[] normalize(float[] array) {
        return FloatArrayMath.scale(array, 1.0f / FloatArrayMath.l2norm(array));
    }

    public static final float[] padMiddle(float[] array, int newLength) {
        int length = array.length;
        int entriesNeeded = newLength - length;
        if (entriesNeeded < 0) {
            throw new IllegalArgumentException("ptolemy.math.FloatArrayMath.padMiddle() : newLength must be >= length of array.");
        }
        if (entriesNeeded == 0) {
            return FloatArrayMath.resize(array, newLength);
        }
        double halfLength = (double)length * 0.5;
        int halfLengthFloor = (int)Math.floor(halfLength);
        int halfLengthCeil = (int)Math.ceil(halfLength);
        float[] returnValue = new float[newLength];
        System.arraycopy(array, 0, returnValue, 0, halfLengthCeil);
        System.arraycopy(array, halfLengthFloor, returnValue, newLength - halfLengthCeil, halfLengthCeil);
        return returnValue;
    }

    public static final float[] resize(float[] array, int newLength) {
        return FloatArrayMath.resize(array, newLength, 0);
    }

    public static final float[] resize(float[] array, int newLength, int startIdx) {
        float[] returnValue = new float[newLength];
        int copySize = Math.min(newLength, array.length - startIdx);
        if (startIdx >= array.length && copySize > 0) {
            throw new IllegalArgumentException("resize():  the start index '" + startIdx + "' is greather than equal to the array length '" + array.length + "' and the number of items to be copied '" + copySize + "' is greater than zero.");
        }
        if (copySize > 0) {
            System.arraycopy(array, startIdx, returnValue, 0, copySize);
        }
        return returnValue;
    }

    public static final float[] scale(float[] array, float scaleFactor) {
        float[] returnValue = new float[array.length];
        int i = 0;
        while (i < array.length) {
            returnValue[i] = scaleFactor * array[i];
            ++i;
        }
        return returnValue;
    }

    public static final float[] subtract(float[] array1, float[] array2) {
        int length = FloatArrayMath._commonLength(array1, array2, "FloatArrayMath.subtract");
        float[] returnValue = new float[length];
        int i = 0;
        while (i < length) {
            returnValue[i] = array1[i] - array2[i];
            ++i;
        }
        return returnValue;
    }

    public static final float sumOfSquares(float[] array) {
        float sum = 0.0f;
        int i = 0;
        while (i < array.length) {
            sum += array[i] * array[i];
            ++i;
        }
        return sum;
    }

    public static final Complex[] toComplexArray(float[] array) {
        int length = array.length;
        Complex[] returnValue = new Complex[length];
        int i = 0;
        while (i < length) {
            returnValue[i] = new Complex(array[i], 0.0);
            ++i;
        }
        return returnValue;
    }

    public static final double[] toDoubleArray(float[] array) {
        int length = array.length;
        double[] returnValue = new double[length];
        int i = 0;
        while (i < length) {
            returnValue[i] = array[i];
            ++i;
        }
        return returnValue;
    }

    public static final int[] toIntegerArray(float[] array) {
        int length = array.length;
        int[] returnValue = new int[length];
        int i = 0;
        while (i < length) {
            returnValue[i] = (int)array[i];
            ++i;
        }
        return returnValue;
    }

    public static final long[] toLongArray(float[] array) {
        int length = array.length;
        long[] returnValue = new long[length];
        int i = 0;
        while (i < length) {
            returnValue[i] = (long)array[i];
            ++i;
        }
        return returnValue;
    }

    public static final String toString(float[] array) {
        return FloatArrayMath.toString(array, ", ", "{", "}");
    }

    public static final String toString(float[] array, String elementDelimiter, String vectorBegin, String vectorEnd) {
        int length = array.length;
        StringBuffer sb = new StringBuffer();
        sb.append(vectorBegin);
        int i = 0;
        while (i < length) {
            sb.append(Float.toString(array[i]));
            if (i < length - 1) {
                sb.append(elementDelimiter);
            }
            ++i;
        }
        sb.append(vectorEnd);
        return new String(sb);
    }

    public static final boolean within(float[] array1, float[] array2, float maxError) {
        int length = FloatArrayMath._commonLength(array1, array2, "FloatArrayMath.within");
        int i = 0;
        while (i < length) {
            if (array1[i] > array2[i] + maxError || array1[i] < array2[i] - maxError) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static final boolean within(float[] array1, float[] array2, float[] maxError) {
        int length = FloatArrayMath._commonLength(array1, array2, "FloatArrayMath.within");
        int i = 0;
        while (i < length) {
            if (array1[i] > array2[i] + maxError[i] || array1[i] < array2[i] - maxError[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected static final int _commonLength(float[] array1, float[] array2, String methodName) {
        if (array1 == null) {
            throw new IllegalArgumentException("ptolemy.math." + methodName + "() : first input array is null.");
        }
        if (array2 == null) {
            throw new IllegalArgumentException("ptolemy.math." + methodName + "() : second input array is null.");
        }
        if (array1.length != array2.length) {
            throw new IllegalArgumentException("ptolemy.math." + methodName + "() : input arrays must have the same length, " + "but the first array has length " + array1.length + " and the second array has length " + array2.length + ".");
        }
        return array1.length;
    }
}

