/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.math;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import ptolemy.math.FixPointQuantization;
import ptolemy.math.Overflow;
import ptolemy.math.Precision;
import ptolemy.math.Quantization;
import ptolemy.math.Rounding;

public class FixPoint
implements Cloneable,
Serializable {
    private BigInteger _value;
    private Precision _precision;
    private Error _error = new Error();

    public FixPoint(BigDecimal bigDecimal, Quantization quant) {
        this._initFromBigDecimal(bigDecimal, quant);
    }

    public FixPoint(FixPoint fix, Quantization quant) {
        this._initFromBigDecimal(fix.bigDecimalValue(), quant);
    }

    public FixPoint(double doubleValue, Quantization quant) {
        try {
            BigDecimal bigDecimal = new BigDecimal(doubleValue);
            this._initFromBigDecimal(bigDecimal, quant);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("NumberFormatException while converting \"" + doubleValue + "\" to a FixPoint.");
        }
    }

    public FixPoint(int intValue, Quantization quant) {
        BigInteger bigInt = new BigInteger(Integer.toString(intValue));
        this._initFromBigInteger(bigInt, quant);
    }

    public FixPoint(int intValue) {
        this(intValue, true);
    }

    public FixPoint(int intValue, boolean signed) {
        this(intValue, (Quantization)new FixPointQuantization(new Precision(signed ? 1 : 0, (signed ? 1 : 0) + 1, 0), Overflow.GROW, Rounding.HALF_EVEN));
    }

    public FixPoint(String string, Quantization quant) {
        try {
            BigDecimal bigDecimal = new BigDecimal(string);
            this._initFromBigDecimal(bigDecimal, quant);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("NumberFormatException while converting \"" + string + "\" to a FixPoint.");
        }
    }

    public static Precision addPrecision(Precision leftArgument, Precision rightArgument) {
        Precision union = Precision.union(leftArgument, rightArgument);
        Precision newPrecision = new Precision(union.getSign(), union.getNumberOfBits() + 1, union.getExponent());
        return newPrecision;
    }

    public static Precision subtractPrecision(Precision leftArgument, Precision rightArgument) {
        Precision union = Precision.union(leftArgument, rightArgument);
        int length = union.getNumberOfBits() + 1;
        Precision newPrecision = new Precision(1, length, union.getExponent());
        return newPrecision;
    }

    public static Precision multiplyPrecision(Precision leftArgument, Precision rightArgument) {
        int sign = leftArgument.getSign() == 1 || rightArgument.getSign() == 1 ? 1 : 0;
        int fractionBits = leftArgument.getFractionBitLength() + rightArgument.getFractionBitLength();
        int integerBits = leftArgument.getIntegerBitLength() + rightArgument.getIntegerBitLength();
        Precision newPrecision = new Precision(sign, fractionBits + integerBits, -fractionBits);
        return newPrecision;
    }

    public static Precision dividePrecision(Precision leftArgument, Precision rightArgument) {
        int sign = leftArgument.getSign() == 1 || rightArgument.getSign() == 1 ? 1 : 0;
        int integerBits = leftArgument.getIntegerBitLength() + rightArgument.getFractionBitLength() + sign;
        int fractionBits = leftArgument.getFractionBitLength() + rightArgument.getIntegerBitLength() + 1 - sign;
        Precision newPrecision = new Precision(sign, sign + fractionBits + integerBits, -fractionBits);
        return newPrecision;
    }

    public FixPoint abs() {
        return new FixPoint(this._value.abs(), this._precision);
    }

    public FixPoint add(FixPoint arg) {
        int minExponent = Math.min(this._precision.getExponent(), arg._precision.getExponent());
        BigInteger thisValue = this._alignToExponent(minExponent);
        BigInteger thatValue = arg._alignToExponent(minExponent);
        BigInteger newValue = thisValue.add(thatValue);
        Precision newPrecision = FixPoint.addPrecision(this._precision, arg._precision);
        return new FixPoint(newValue, newPrecision);
    }

    public FixPoint add(FixPoint arg, Quantization quant) {
        return this.add(arg).quantize(quant);
    }

    public BigDecimal bigDecimalValue() {
        return Precision.shiftBigDecimal(new BigDecimal(this._value), this._precision.getExponent());
    }

    public Object clone() {
        return this;
    }

    public FixPoint divide(FixPoint arg) throws IllegalArgumentException {
        Precision newPrecision = FixPoint.dividePrecision(this._precision, arg._precision);
        FixPointQuantization netQuantization = new FixPointQuantization(newPrecision, Overflow.TRAP, Rounding.NEAREST);
        return this.divide(arg, netQuantization);
    }

    public FixPoint divide(FixPoint arg, Quantization quant) throws IllegalArgumentException {
        try {
            BigDecimal numerator = new BigDecimal(this._value);
            BigDecimal denominator = new BigDecimal(arg._value);
            int resultExp = quant.getPrecision().getExponent();
            int scale = resultExp < 0 ? -resultExp : 0;
            BigDecimal result = numerator.divide(denominator, ++scale, 6);
            int result_shift = this._precision.getExponent() - arg.getPrecision().getExponent();
            result = Precision.shiftBigDecimal(result, result_shift);
            return new FixPoint(result, quant);
        }
        catch (ArithmeticException arithmeticException) {
            BigInteger infinity;
            Overflow anOverflow = quant.getOverflow();
            BigInteger bigInteger = infinity = this._value.signum() >= 0 ? anOverflow.plusInfinity(quant) : anOverflow.minusInfinity(quant);
            if (infinity != null) {
                return new FixPoint(infinity, quant.getPrecision());
            }
            throw new IllegalArgumentException("ArithmeticException while dividing " + this.toString() + " by " + arg.toString() + '.');
        }
    }

    public double doubleValue() {
        return this._value.doubleValue() * Math.pow(2.0, this._precision.getExponent());
    }

    public boolean equals(Object arg) {
        if (arg instanceof FixPoint) {
            int exponentBits = Math.min(this._precision.getExponent(), ((FixPoint)arg)._precision.getExponent());
            BigInteger thisValue = this._alignToExponent(exponentBits);
            BigInteger thatValue = ((FixPoint)arg)._alignToExponent(exponentBits);
            return thisValue.equals(thatValue);
        }
        return false;
    }

    public Error getError() {
        return this._error;
    }

    public Precision getPrecision() {
        return this._precision;
    }

    public BigInteger getUnscaledValue() {
        return this._value;
    }

    public int hashCode() {
        return this._value.intValue();
    }

    public FixPoint minimumQuantization() {
        int new_sign = this._precision.getSign();
        int shiftVal = this._value.getLowestSetBit();
        BigInteger newVal = this._value.shiftRight(shiftVal);
        int new_exponent = this._precision.getExponent() + shiftVal;
        int new_bitlength = newVal.bitLength() + new_sign;
        Precision newPrecision = new Precision(new_sign, new_bitlength, new_exponent);
        return new FixPoint(newVal, newPrecision);
    }

    public FixPoint multiply(FixPoint arg) {
        BigInteger newValue = this._value.multiply(arg._value);
        Precision newPrecision = FixPoint.multiplyPrecision(this._precision, arg._precision);
        FixPoint newVal = new FixPoint(newValue, newPrecision);
        FixPoint fp = new FixPoint(newVal, (Quantization)new FixPointQuantization(newPrecision, Overflow.GENERAL, Rounding.GENERAL));
        return fp;
    }

    public FixPoint multiply(FixPoint arg, Quantization quant) {
        return this.multiply(arg).quantize(quant);
    }

    public void printFix() {
        System.out.println(" unscale Value  (2) " + this._value.toString(2));
        System.out.println(" unscaled Value (10) " + this._value.toString(10));
        System.out.println(" scale Value (10) " + this.doubleValue() + " Precision: " + this.getPrecision().toString());
        System.out.println(" BitCount:   " + this._value.bitCount());
        System.out.println(" BitLength   " + this._value.bitLength());
        BigInteger j = this._value.abs();
        System.out.println(" ABS value   " + j.toString(2));
        System.out.println(" ABS bit count:  " + j.bitCount());
        System.out.println(" ABD bitLength:  " + j.bitLength());
        System.out.println(" Max value:  " + this.getPrecision().findMaximum().doubleValue());
        System.out.println(" Min value:  " + this.getPrecision().findMinimum().doubleValue());
    }

    public FixPoint quantize(Quantization quant) {
        return new FixPoint(this, quant);
    }

    public FixPoint subtract(FixPoint arg) {
        int minExponent = Math.min(this._precision.getExponent(), arg._precision.getExponent());
        BigInteger thisValue = this._alignToExponent(minExponent);
        BigInteger thatValue = arg._alignToExponent(minExponent);
        BigInteger newValue = thisValue.subtract(thatValue);
        Precision newPrecision = FixPoint.subtractPrecision(this._precision, arg._precision);
        return new FixPoint(newValue, newPrecision);
    }

    public FixPoint subtract(FixPoint arg, Quantization quant) {
        return this.subtract(arg).quantize(quant);
    }

    public String toBitString() {
        int _frac_bits = -this._precision.getExponent();
        BigInteger integerPart = this._value.shiftRight(_frac_bits);
        StringBuffer ln = new StringBuffer(integerPart.toString(2));
        if (_frac_bits > 0) {
            BigInteger fractionModulus = BigInteger.ZERO.setBit(_frac_bits);
            BigInteger fractionMask = fractionModulus.subtract(BigInteger.ONE);
            BigInteger fractionPart = this._value.and(fractionMask);
            int minFracBits = fractionPart.bitLength();
            int extraLeadingFracBits = _frac_bits - minFracBits;
            ln.append(".");
            int i = 0;
            while (i < extraLeadingFracBits) {
                ln.append("0");
                ++i;
            }
            if (minFracBits > 0) {
                ln.append(fractionPart.toString(2));
            }
        }
        return ln.toString();
    }

    public String toString() {
        BigDecimal decimal = this.bigDecimalValue();
        String bigString = decimal.toString();
        if (bigString.indexOf(46) < 0) {
            if (bigString.indexOf(69) < 0) {
                return bigString;
            }
            if (bigString.startsWith("0E-")) {
                return "0.0";
            }
            return bigString;
        }
        int i = bigString.length() - 1;
        while (bigString.charAt(i) == '0' && bigString.charAt(i - 1) != '.') {
            --i;
        }
        return bigString.substring(0, i + 1);
    }

    public String toStringPrecision() {
        return String.valueOf(this.toString()) + this._precision.toString();
    }

    public String toStringValuePrecision() {
        return String.valueOf(this.toString()) + " [" + this._precision.toString() + "=" + this._value + "]";
    }

    FixPoint(BigInteger unscaledIntegerValue, Precision precision) {
        if (Overflow.isOutOfRange(unscaledIntegerValue, precision)) {
            throw new ArithmeticException("Precision " + precision + " not sufficient to represent " + unscaledIntegerValue);
        }
        this._precision = precision;
        this._value = unscaledIntegerValue;
    }

    private BigInteger _alignToExponent(int exponent) {
        int exponentChange = exponent - this._precision.getExponent();
        if (exponentChange < 0) {
            return this._value.shiftLeft(-exponentChange);
        }
        return this._value;
    }

    private void _initFromBigDecimal(BigDecimal bigDecimal, Quantization quant) {
        if (!quant.getPrecision().isSigned() && bigDecimal.signum() < 0) {
            throw new ArithmeticException("Attempting to create a unsigned FixPoint from a negative double:" + bigDecimal);
        }
        BigDecimal shiftedDecimal = Precision.shiftBigDecimal(bigDecimal, -quant.getPrecision().getExponent());
        BigInteger roundedInteger = quant.getRounding().round(shiftedDecimal);
        FixPoint newFix = quant.getOverflow().quantize(roundedInteger, quant.getPrecision());
        this._value = newFix._value;
        this._precision = newFix._precision;
    }

    private void _initFromBigInteger(BigInteger bigInteger, Quantization quant) {
        if (!quant.getPrecision().isSigned() && bigInteger.signum() < 0) {
            throw new ArithmeticException("Attempting to create a unsigned FixPoint from a negative integer:" + bigInteger);
        }
        int desiredExponent = quant.getPrecision().getExponent();
        if (desiredExponent > 0) {
            this._initFromBigDecimal(new BigDecimal(bigInteger), quant);
            return;
        }
        if (desiredExponent < 0) {
            bigInteger = bigInteger.shiftLeft(-desiredExponent);
        }
        FixPoint newFix = quant.getOverflow().quantize(bigInteger, quant.getPrecision());
        this._value = newFix._value;
        this._precision = newFix._precision;
    }

    public static class Error {
        private Error() {
        }

        public String getDescription() {
            return " Overflow status is no longer tracked.";
        }
    }
}

