/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.math;

import java.util.Random;
import ptolemy.math.DoubleArrayMath;
import ptolemy.math.ExtendedMath;

public class DoubleArrayStat
extends DoubleArrayMath {
    private static Random _random;

    protected DoubleArrayStat() {
    }

    public static final double[] autoCorrelation(double[] x, int N, int startLag, int endLag) {
        int outputLength = endLag - startLag + 1;
        double[] returnValue = new double[outputLength];
        int lag = startLag;
        while (lag <= endLag) {
            int start = Math.max(0, -lag);
            int limit = Math.min(x.length, N);
            limit = Math.min(limit, x.length - lag);
            double sum = 0.0;
            int i = start;
            while (i < limit) {
                sum += x[i] * x[i + lag];
                ++i;
            }
            returnValue[lag - startLag] = sum;
            ++lag;
        }
        return returnValue;
    }

    public static double autoCorrelationAt(double[] x, int N, int lag) {
        int start = Math.max(0, -lag);
        int limit = Math.min(x.length, N);
        limit = Math.min(limit, x.length - lag);
        double sum = 0.0;
        int i = start;
        while (i < limit) {
            sum += x[i] * x[i + lag];
            ++i;
        }
        return sum;
    }

    public static final double[] crossCorrelation(double[] x, double[] y, int N, int startLag, int endLag) {
        int outputLength = endLag - startLag + 1;
        double[] returnValue = new double[outputLength];
        int lag = startLag;
        while (lag <= endLag) {
            int start = Math.max(0, -lag);
            int limit = Math.min(x.length, N);
            limit = Math.min(limit, y.length - lag);
            double sum = 0.0;
            int i = start;
            while (i < limit) {
                sum += x[i] * y[i + lag];
                ++i;
            }
            returnValue[lag - startLag] = sum;
            ++lag;
        }
        return returnValue;
    }

    public static double crossCorrelationAt(double[] x, double[] y, int N, int lag) {
        int start = Math.max(0, -lag);
        int limit = Math.min(x.length, N);
        limit = Math.min(limit, y.length - lag);
        double sum = 0.0;
        int i = start;
        while (i < limit) {
            sum += x[i] * y[i + lag];
            ++i;
        }
        return sum;
    }

    public static final double entropy(double[] p) {
        int length = DoubleArrayStat._nonZeroLength(p, "DoubleArrayStat.entropy");
        double h = 0.0;
        int i = 0;
        while (i < length) {
            if (p[i] < 0.0) {
                throw new IllegalArgumentException("ptolemy.math.DoubleArrayStat.entropy() : Negative probability encountered.");
            }
            if (p[i] != 0.0) {
                h -= p[i] * ExtendedMath.log2(p[i]);
            }
            ++i;
        }
        return h;
    }

    public static final double geometricMean(double[] array) {
        if (array.length < 1) {
            return 1.0;
        }
        return Math.pow(DoubleArrayStat.productOfElements(array), 1.0 / (double)array.length);
    }

    public static final double max(double[] array) {
        Object[] maxReturn = DoubleArrayStat.maxAndIndex(array);
        return (Double)maxReturn[0];
    }

    public static final Object[] maxAndIndex(double[] array) {
        int length = DoubleArrayStat._nonZeroLength(array, "DoubleArrayStat.maxAndIndex");
        int maxIndex = 0;
        double maxElement = array[0];
        int i = 1;
        while (i < length) {
            if (array[i] > maxElement) {
                maxElement = array[i];
                maxIndex = i;
            }
            ++i;
        }
        return new Object[]{maxElement, maxIndex};
    }

    public static final double mean(double[] array) {
        DoubleArrayStat._nonZeroLength(array, "DoubleArrayStat.mean");
        return DoubleArrayStat.sumOfElements(array) / (double)array.length;
    }

    public static final double min(double[] array) {
        Object[] minReturn = DoubleArrayStat.minAndIndex(array);
        return (Double)minReturn[0];
    }

    public static final Object[] minAndIndex(double[] array) {
        int length = DoubleArrayStat._nonZeroLength(array, "DoubleArrayStat.minAndIndex");
        int minIndex = 0;
        double minElement = array[0];
        int i = 1;
        while (i < length) {
            if (array[i] < minElement) {
                minElement = array[i];
                minIndex = i;
            }
            ++i;
        }
        return new Object[]{minElement, minIndex};
    }

    public static final double productOfElements(double[] array) {
        double product = 1.0;
        int i = 0;
        while (i < array.length) {
            product *= array[i];
            ++i;
        }
        return product;
    }

    public static final double[] randomBernoulli(double p, int N) {
        double[] returnValue = new double[N];
        if (_random == null) {
            _random = new Random();
        }
        int i = 0;
        while (i < N) {
            returnValue[i] = _random.nextDouble() < p ? 1.0 : 0.0;
            ++i;
        }
        return returnValue;
    }

    public static final double[] randomExponential(double lambda, int N) {
        double[] returnValue = new double[N];
        if (_random == null) {
            _random = new Random();
        }
        int i = 0;
        while (i < N) {
            double r;
            while ((r = _random.nextDouble()) == 0.0) {
            }
            returnValue[i] = -Math.log(r) / lambda;
            ++i;
        }
        return returnValue;
    }

    public static final double[] randomGaussian(double mean, double standardDeviation, int N) {
        double[] returnValue = new double[N];
        if (_random == null) {
            _random = new Random();
        }
        int i = 0;
        while (i < N) {
            returnValue[i] = mean + _random.nextGaussian() * standardDeviation;
            ++i;
        }
        return returnValue;
    }

    public static final double[] randomPoisson(double mean, int N) {
        double[] returnValue = new double[N];
        if (_random == null) {
            _random = new Random();
        }
        int i = 0;
        while (i < N) {
            double p;
            double j = 0.0;
            double f = p = Math.exp(-mean);
            double u = _random.nextDouble();
            while (f <= u) {
                f += (p *= mean / (j + 1.0));
                j += 1.0;
            }
            returnValue[i] = j;
            ++i;
        }
        return returnValue;
    }

    public static double[] randomUniform(double a, double b, int N) {
        double range = b - a;
        double[] returnValue = new double[N];
        if (_random == null) {
            _random = new Random();
        }
        int i = 0;
        while (i < N) {
            returnValue[i] = _random.nextDouble() * range + a;
            ++i;
        }
        return returnValue;
    }

    public static final double relativeEntropy(double[] p, double[] q) {
        DoubleArrayStat._nonZeroLength(p, "DoubleArrayStat.relativeEntropy");
        int length = DoubleArrayStat._commonLength(p, q, "DoubleArrayStat.relativeEntropy");
        double d = 0.0;
        int i = 0;
        while (i < length) {
            if (p[i] < 0.0 || q[i] < 0.0) {
                throw new IllegalArgumentException("ptolemy.math.DoubleArrayStat.relativeEntropy() : Negative probability encountered.");
            }
            if (p[i] != 0.0) {
                if (q[i] == 0.0) {
                    return Double.POSITIVE_INFINITY;
                }
                d += p[i] * ExtendedMath.log2(p[i] / q[i]);
            }
            ++i;
        }
        return d;
    }

    public static double standardDeviation(double[] array) {
        return Math.sqrt(DoubleArrayStat.variance(array, false));
    }

    public static double standardDeviation(double[] array, boolean sample) {
        return Math.sqrt(DoubleArrayStat.variance(array, sample));
    }

    public static final double sumOfElements(double[] array) {
        double sum = 0.0;
        int i = 0;
        while (i < array.length) {
            sum += array[i];
            ++i;
        }
        return sum;
    }

    public static double variance(double[] array) {
        return DoubleArrayStat.variance(array, false);
    }

    public static double variance(double[] array, boolean sample) {
        int length = DoubleArrayStat._nonZeroLength(array, "DoubleArrayStat.variance");
        if (sample && array.length < 2) {
            throw new IllegalArgumentException("ptolemy.math.DoubleArrayStat.variance() : sample variance and standard deviation of an array of length less than 2 are not defined.");
        }
        double ex2 = 0.0;
        double sum = 0.0;
        int i = 0;
        while (i < length) {
            ex2 += array[i] * array[i];
            sum += array[i];
            ++i;
        }
        double norm = sample ? length - 1 : length;
        double sumSquaredOverLength = sum * sum / (double)length;
        return (ex2 - sumSquaredOverLength) / norm;
    }

    protected static final int _nonZeroLength(double[] array, String methodName) {
        if (array == null) {
            throw new IllegalArgumentException("ptolemy.math." + methodName + "() : input array is null.");
        }
        if (array.length <= 0) {
            throw new IllegalArgumentException("ptolemy.math." + methodName + "() : input array has length 0.");
        }
        return array.length;
    }
}

