/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.math;

import ptolemy.math.Complex;
import ptolemy.math.DoubleBinaryOperation;
import ptolemy.math.DoubleUnaryOperation;

public class DoubleArrayMath {
    protected DoubleArrayMath() {
    }

    public static final double[] add(double[] array, double z) {
        int length = array.length;
        double[] returnValue = new double[length];
        int i = 0;
        while (i < length) {
            returnValue[i] = array[i] + z;
            ++i;
        }
        return returnValue;
    }

    public static final double[] add(double[] array1, double[] array2) {
        int length = DoubleArrayMath._commonLength(array1, array2, "DoubleArrayMath.add");
        double[] returnValue = new double[length];
        int i = 0;
        while (i < length) {
            returnValue[i] = array1[i] + array2[i];
            ++i;
        }
        return returnValue;
    }

    public static final double[] allocCopy(double[] array) {
        int elements = array.length;
        double[] newArray = new double[elements];
        System.arraycopy(array, 0, newArray, 0, elements);
        return newArray;
    }

    public static final double[] append(double[] array1, double[] array2) {
        return DoubleArrayMath.append(array1, 0, array1.length, array2, 0, array2.length);
    }

    public static final double[] append(double[] array1, int idx1, int length1, double[] array2, int idx2, int length2) {
        double[] returnValue = new double[length1 + length2];
        if (length1 > 0) {
            System.arraycopy(array1, idx1, returnValue, 0, length1);
        }
        if (length2 > 0) {
            System.arraycopy(array2, idx2, returnValue, length1, length2);
        }
        return returnValue;
    }

    public static final double[] applyBinaryOperation(DoubleBinaryOperation op, double[] array, double z) {
        int length = array.length;
        double[] returnValue = new double[length];
        int i = 0;
        while (i < length) {
            returnValue[i] = op.operate(array[i], z);
            ++i;
        }
        return returnValue;
    }

    public static final double[] applyBinaryOperation(DoubleBinaryOperation op, double z, double[] array) {
        int length = array.length;
        double[] returnValue = new double[length];
        int i = 0;
        while (i < length) {
            returnValue[i] = op.operate(array[i], z);
            ++i;
        }
        return returnValue;
    }

    public static final double[] applyBinaryOperation(DoubleBinaryOperation op, double[] array1, double[] array2) {
        int length = DoubleArrayMath._commonLength(array1, array2, "DoubleArrayMath.applyBinaryOperation");
        double[] returnValue = new double[length];
        int i = 0;
        while (i < length) {
            returnValue[i] = op.operate(array1[i], array2[i]);
            ++i;
        }
        return returnValue;
    }

    public static final double[] applyUnaryOperation(DoubleUnaryOperation op, double[] array) {
        int length = array.length;
        double[] returnValue = new double[length];
        int i = 0;
        while (i < length) {
            returnValue[i] = op.operate(array[i]);
            ++i;
        }
        return returnValue;
    }

    public static final double[] divideElements(double[] array1, double[] array2) {
        int length = DoubleArrayMath._commonLength(array1, array2, "DoubleArrayMath.divideElements");
        double[] returnValue = new double[length];
        int i = 0;
        while (i < length) {
            returnValue[i] = array1[i] / array2[i];
            ++i;
        }
        return returnValue;
    }

    public static final double[] divide(double[] array, double num) {
        double[] returnValue = new double[array.length];
        int i = 0;
        while (i < array.length) {
            returnValue[i] = array[i] / num;
            ++i;
        }
        return returnValue;
    }

    public static final double dotProduct(double[] array1, double[] array2) {
        int length = DoubleArrayMath._commonLength(array1, array2, "DoubleArrayMath.dotProduct");
        double sum = 0.0;
        int i = 0;
        while (i < length) {
            sum += array1[i] * array2[i];
            ++i;
        }
        return sum;
    }

    public static final double l2norm(double[] array) {
        return Math.sqrt(DoubleArrayMath.sumOfSquares(array));
    }

    public static final double[] limit(double[] array, double bottom, double top) {
        double[] returnValue = new double[array.length];
        int i = 0;
        while (i < array.length) {
            returnValue[i] = array[i] > top || array[i] == Double.POSITIVE_INFINITY ? top : (array[i] < bottom || array[i] == Double.NEGATIVE_INFINITY ? bottom : array[i]);
            ++i;
        }
        return returnValue;
    }

    public static final double[] modulo(double[] array, double z) {
        int length = array.length;
        double[] returnValue = new double[length];
        int i = 0;
        while (i < length) {
            returnValue[i] = array[i] % z;
            ++i;
        }
        return returnValue;
    }

    public static final double[] multiply(double[] array1, double[] array2) {
        int length = DoubleArrayMath._commonLength(array1, array2, "DoubleArrayMath.multiply");
        double[] returnValue = new double[length];
        int i = 0;
        while (i < length) {
            returnValue[i] = array1[i] * array2[i];
            ++i;
        }
        return returnValue;
    }

    public static final double[] multiply(double[] array, double factor) {
        int length = array.length;
        double[] returnValue = new double[length];
        int i = 0;
        while (i < length) {
            returnValue[i] = array[i] * factor;
            ++i;
        }
        return returnValue;
    }

    public static final double[] negative(double[] array) {
        int length = array.length;
        double[] returnValue = new double[length];
        int i = 0;
        while (i < length) {
            returnValue[i] = -array[i];
            ++i;
        }
        return returnValue;
    }

    public static final double[] normalize(double[] array) {
        return DoubleArrayMath.scale(array, 1.0 / DoubleArrayMath.l2norm(array));
    }

    public static final double[] padMiddle(double[] array, int newLength) {
        int length = array.length;
        int entriesNeeded = newLength - length;
        if (entriesNeeded < 0) {
            throw new IllegalArgumentException("ptolemy.math.DoubleArrayMath.padMiddle() : newLength must be >= length of array.");
        }
        if (entriesNeeded == 0) {
            return DoubleArrayMath.resize(array, newLength);
        }
        double halfLength = (double)length * 0.5;
        int halfLengthFloor = (int)Math.floor(halfLength);
        int halfLengthCeil = (int)Math.ceil(halfLength);
        double[] returnValue = new double[newLength];
        System.arraycopy(array, 0, returnValue, 0, halfLengthCeil);
        System.arraycopy(array, halfLengthFloor, returnValue, newLength - halfLengthCeil, halfLengthCeil);
        return returnValue;
    }

    public static final double[] resize(double[] array, int newLength) {
        return DoubleArrayMath.resize(array, newLength, 0);
    }

    public static final double[] resize(double[] array, int newLength, int startIdx) {
        double[] returnValue = new double[newLength];
        int copySize = Math.min(newLength, array.length - startIdx);
        if (startIdx >= array.length && copySize > 0) {
            throw new IllegalArgumentException("resize():  the start index '" + startIdx + "' is greather than equal to the array length '" + array.length + "' and the number of items to be copied '" + copySize + "' is greater than zero.");
        }
        if (copySize > 0) {
            System.arraycopy(array, startIdx, returnValue, 0, copySize);
        }
        return returnValue;
    }

    public static final double[] scale(double[] array, double scaleFactor) {
        double[] returnValue = new double[array.length];
        int i = 0;
        while (i < array.length) {
            returnValue[i] = scaleFactor * array[i];
            ++i;
        }
        return returnValue;
    }

    public static final double[] subtract(double[] array1, double[] array2) {
        int length = DoubleArrayMath._commonLength(array1, array2, "DoubleArrayMath.subtract");
        double[] returnValue = new double[length];
        int i = 0;
        while (i < length) {
            returnValue[i] = array1[i] - array2[i];
            ++i;
        }
        return returnValue;
    }

    public static final double sum(double[] array) {
        double sum = 0.0;
        int i = 0;
        while (i < array.length) {
            sum += array[i];
            ++i;
        }
        return sum;
    }

    public static final double sumOfSquares(double[] array) {
        double sum = 0.0;
        int i = 0;
        while (i < array.length) {
            sum += array[i] * array[i];
            ++i;
        }
        return sum;
    }

    public static final Complex[] toComplexArray(double[] array) {
        int length = array.length;
        Complex[] returnValue = new Complex[length];
        int i = 0;
        while (i < length) {
            returnValue[i] = new Complex(array[i], 0.0);
            ++i;
        }
        return returnValue;
    }

    public static final float[] toFloatArray(double[] array) {
        int length = array.length;
        float[] returnValue = new float[length];
        int i = 0;
        while (i < length) {
            returnValue[i] = (float)array[i];
            ++i;
        }
        return returnValue;
    }

    public static final int[] toIntegerArray(double[] array) {
        int length = array.length;
        int[] returnValue = new int[length];
        int i = 0;
        while (i < length) {
            returnValue[i] = (int)array[i];
            ++i;
        }
        return returnValue;
    }

    public static final long[] toLongArray(double[] array) {
        int length = array.length;
        long[] returnValue = new long[length];
        int i = 0;
        while (i < length) {
            returnValue[i] = (long)array[i];
            ++i;
        }
        return returnValue;
    }

    public static final String toString(double[] array) {
        return DoubleArrayMath.toString(array, ", ", "{", "}");
    }

    public static final String toString(double[] array, String elementDelimiter, String vectorBegin, String vectorEnd) {
        int length = array.length;
        StringBuffer sb = new StringBuffer();
        sb.append(vectorBegin);
        int i = 0;
        while (i < length) {
            sb.append(Double.toString(array[i]));
            if (i < length - 1) {
                sb.append(elementDelimiter);
            }
            ++i;
        }
        sb.append(vectorEnd);
        return new String(sb);
    }

    public static final boolean within(double[] array1, double[] array2, double maxError) {
        int length = DoubleArrayMath._commonLength(array1, array2, "DoubleArrayMath.within");
        int i = 0;
        while (i < length) {
            if (array1[i] > array2[i] + maxError || array1[i] < array2[i] - maxError) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static final boolean within(double[] array1, double[] array2, double[] maxError) {
        int length = DoubleArrayMath._commonLength(array1, array2, "DoubleArrayMath.within");
        int i = 0;
        while (i < length) {
            if (array1[i] > array2[i] + maxError[i] || array1[i] < array2[i] - maxError[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected static final int _commonLength(double[] array1, double[] array2, String methodName) {
        if (array1 == null) {
            throw new IllegalArgumentException("ptolemy.math." + methodName + "() : first input array is null.");
        }
        if (array2 == null) {
            throw new IllegalArgumentException("ptolemy.math." + methodName + "() : second input array is null.");
        }
        if (array1.length != array2.length) {
            throw new IllegalArgumentException("ptolemy.math." + methodName + "() : input arrays must have the same length, " + "but the first array has length " + array1.length + " and the second array has length " + array2.length + ".");
        }
        return array1.length;
    }
}

