/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.math;

import ptolemy.math.Complex;
import ptolemy.math.ComplexBinaryOperation;
import ptolemy.math.ComplexUnaryOperation;
import ptolemy.math.DoubleArrayMath;
import ptolemy.math.SignalProcessing;

public class ComplexArrayMath {
    protected ComplexArrayMath() {
    }

    public static final Complex[] add(Complex[] array, Complex z) {
        Complex[] result = new Complex[array.length];
        int i = 0;
        while (i < array.length) {
            result[i] = array[i].add(z);
            ++i;
        }
        return result;
    }

    public static final Complex[] add(Complex[] array1, Complex[] array2) {
        int length = ComplexArrayMath._commonLength(array1, array2, "ComplexArrayMath.add");
        Complex[] returnValue = new Complex[length];
        int i = 0;
        while (i < length) {
            returnValue[i] = array1[i].add(array2[i]);
            ++i;
        }
        return returnValue;
    }

    public static final Complex[] append(Complex[] array1, Complex[] array2) {
        return ComplexArrayMath.append(array1, 0, array1.length, array2, 0, array2.length);
    }

    public static final Complex[] append(Complex[] array1, int idx1, int length1, Complex[] array2, int idx2, int length2) {
        Complex[] returnValue = new Complex[length1 + length2];
        if (length1 > 0) {
            System.arraycopy(array1, idx1, returnValue, 0, length1);
        }
        if (length2 > 0) {
            System.arraycopy(array2, idx2, returnValue, length1, length2);
        }
        return returnValue;
    }

    public static final Complex[] applyBinaryOperation(ComplexBinaryOperation op, Complex z, Complex[] array) {
        int length = array.length;
        Complex[] returnValue = new Complex[length];
        int i = 0;
        while (i < length) {
            returnValue[i] = op.operate(z, array[i]);
            ++i;
        }
        return returnValue;
    }

    public static final Complex[] applyBinaryOperation(ComplexBinaryOperation op, Complex[] array, Complex z) {
        int length = array.length;
        Complex[] returnValue = new Complex[length];
        int i = 0;
        while (i < length) {
            returnValue[i] = op.operate(array[i], z);
            ++i;
        }
        return returnValue;
    }

    public static final Complex[] applyBinaryOperation(ComplexBinaryOperation op, Complex[] array1, Complex[] array2) {
        int length = ComplexArrayMath._commonLength(array1, array2, "ComplexArrayMath.applyBinaryOperation");
        Complex[] returnValue = new Complex[length];
        int i = 0;
        while (i < length) {
            returnValue[i] = op.operate(array1[i], array2[i]);
            ++i;
        }
        return returnValue;
    }

    public static final Complex[] applyUnaryOperation(ComplexUnaryOperation op, Complex[] array) {
        int length = array.length;
        Complex[] returnValue = new Complex[length];
        int i = 0;
        while (i < length) {
            returnValue[i] = op.operate(array[i]);
            ++i;
        }
        return returnValue;
    }

    public static final Complex[] conjugate(Complex[] array) {
        Complex[] result = new Complex[array.length];
        int i = array.length - 1;
        while (i >= 0) {
            result[i] = array[i].conjugate();
            --i;
        }
        return result;
    }

    public static final Complex[] divideElements(Complex[] array1, Complex[] array2) {
        int length = ComplexArrayMath._commonLength(array1, array2, "ComplexArrayMath.divideElements");
        Complex[] returnValue = new Complex[length];
        int i = 0;
        while (i < length) {
            returnValue[i] = array1[i].divide(array2[i]);
            ++i;
        }
        return returnValue;
    }

    public static final Complex[] divide(Complex[] array, Complex divisor) {
        int length = array.length;
        Complex[] returnValue = new Complex[length];
        int i = 0;
        while (i < length) {
            returnValue[i] = array[i].divide(divisor);
            ++i;
        }
        return returnValue;
    }

    public static final Complex dotProduct(Complex[] array1, Complex[] array2) {
        int length = ComplexArrayMath._commonLength(array1, array2, "ComplexArrayMath.dotProduct");
        Complex returnValue = Complex.ZERO;
        int i = 0;
        while (i < length) {
            returnValue = returnValue.add(array1[i].multiply(array2[i].conjugate()));
            ++i;
        }
        return returnValue;
    }

    public static final Complex[] formComplexArray(double[] realPart, double[] imagPart) {
        Complex[] returnValue;
        if (realPart != null && imagPart != null) {
            int size = DoubleArrayMath._commonLength(realPart, imagPart, "ComplexArrayMath.formComplexArray");
            returnValue = new Complex[size];
            int i = 0;
            while (i < size) {
                returnValue[i] = new Complex(realPart[i], imagPart[i]);
                ++i;
            }
        } else if (realPart == null) {
            int size = imagPart.length;
            returnValue = new Complex[size];
            int i = 0;
            while (i < size) {
                returnValue[i] = new Complex(0.0, imagPart[i]);
                ++i;
            }
        } else {
            int size = realPart.length;
            returnValue = new Complex[size];
            int i = 0;
            while (i < size) {
                returnValue[i] = new Complex(realPart[i], 0.0);
                ++i;
            }
        }
        return returnValue;
    }

    public static final double[] imagParts(Complex[] x) {
        int size = x.length;
        double[] returnValue = new double[size];
        int i = 0;
        while (i < size) {
            returnValue[i] = x[i].imag;
            ++i;
        }
        return returnValue;
    }

    public static final double l2norm(Complex[] array) {
        return Math.sqrt(ComplexArrayMath.l2normSquared(array));
    }

    public static final double l2normSquared(Complex[] array) {
        int length = array.length;
        if (length <= 0) {
            return 0.0;
        }
        double returnValue = 0.0;
        int i = 0;
        while (i < length) {
            returnValue += array[i].magnitudeSquared();
            ++i;
        }
        return returnValue;
    }

    public static final Complex[] limit(Complex[] array, Complex bottom, Complex top) throws IllegalArgumentException {
        Complex[] returnValue = new Complex[array.length];
        if (bottom.real > top.real || bottom.imag > top.imag) {
            throw new IllegalArgumentException("Complex.limit requires that bottom lie below and to the left of top.");
        }
        int i = 0;
        while (i < array.length) {
            double realPart = array[i].real > top.real ? top.real : (array[i].real < bottom.real ? bottom.real : array[i].real);
            double imagPart = array[i].imag > top.imag ? top.imag : (array[i].imag < bottom.imag ? bottom.imag : array[i].imag);
            returnValue[i] = new Complex(realPart, imagPart);
            ++i;
        }
        return returnValue;
    }

    public static final double[] magnitude(Complex[] array) {
        double[] mags = new double[array.length];
        int i = array.length - 1;
        while (i >= 0) {
            mags[i] = array[i].magnitude();
            --i;
        }
        return mags;
    }

    public static final Complex[] multiply(Complex[] array1, Complex[] array2) {
        int length = ComplexArrayMath._commonLength(array1, array2, "ComplexArrayMath.multiply");
        Complex[] returnValue = new Complex[length];
        int i = 0;
        while (i < length) {
            returnValue[i] = array1[i].multiply(array2[i]);
            ++i;
        }
        return returnValue;
    }

    public static final Complex[] multiply(Complex[] array, Complex factor) {
        int length = array.length;
        Complex[] returnValue = new Complex[length];
        int i = 0;
        while (i < length) {
            returnValue[i] = array[i].multiply(factor);
            ++i;
        }
        return returnValue;
    }

    public static final Complex[] negative(Complex[] array) {
        int length = array.length;
        Complex[] returnValue = new Complex[length];
        int i = 0;
        while (i < length) {
            returnValue[i] = new Complex(-array[i].real, -array[i].imag);
            ++i;
        }
        return returnValue;
    }

    public static final Complex[] padMiddle(Complex[] array, int newLength) {
        int length = array.length;
        int entriesNeeded = newLength - length;
        if (entriesNeeded < 0) {
            throw new IllegalArgumentException("ptolemy.math.ComplexArrayMath.padMiddle() : newLength must be >= length of array.");
        }
        if (entriesNeeded == 0) {
            return ComplexArrayMath.resize(array, newLength);
        }
        double halfLength = (double)length * 0.5;
        int halfLengthFloor = (int)Math.floor(halfLength);
        int halfLengthCeil = (int)Math.ceil(halfLength);
        Complex[] returnValue = new Complex[newLength];
        System.arraycopy(array, 0, returnValue, 0, halfLengthCeil);
        System.arraycopy(array, halfLengthFloor, returnValue, newLength - halfLengthCeil, halfLengthCeil);
        int i = halfLengthCeil;
        while (i < newLength - halfLengthCeil) {
            returnValue[i] = Complex.ZERO;
            ++i;
        }
        return returnValue;
    }

    public static final double[] phase(Complex[] array) {
        double[] angles = new double[array.length];
        int i = array.length - 1;
        while (i >= 0) {
            angles[i] = array[i].angle();
            --i;
        }
        return angles;
    }

    public static final Complex[] polynomial(Complex[] roots) {
        if (roots.length <= 1) {
            return new Complex[]{Complex.ONE};
        }
        Complex[] result = new Complex[2];
        result[0] = Complex.ONE;
        if (roots.length >= 1) {
            result[1] = roots[0].negate();
            if (roots.length > 1) {
                int i = 1;
                while (i < roots.length) {
                    Complex[] factor = new Complex[]{new Complex(1.0), roots[i].negate()};
                    result = SignalProcessing.convolve(result, factor);
                    ++i;
                }
            }
        }
        return result;
    }

    public static final Complex[] pow(Complex[] array, double exponent) {
        int length = array.length;
        Complex[] returnValue = new Complex[length];
        int i = 0;
        while (i < length) {
            returnValue[i] = array[i].pow(exponent);
            ++i;
        }
        return returnValue;
    }

    public static final Complex product(Complex[] array) {
        if (array.length == 0) {
            return Complex.ZERO;
        }
        double real = 1.0;
        double imag = 0.0;
        int i = 0;
        while (i < array.length) {
            double tmp = real * array[i].real - imag * array[i].imag;
            imag = real * array[i].imag + imag * array[i].real;
            real = tmp;
            ++i;
        }
        return new Complex(real, imag);
    }

    public static final double[] realParts(Complex[] x) {
        int size = x.length;
        double[] returnValue = new double[size];
        int i = 0;
        while (i < size) {
            returnValue[i] = x[i].real;
            ++i;
        }
        return returnValue;
    }

    public static final Complex[] resize(Complex[] array, int newLength) {
        return ComplexArrayMath.resize(array, newLength, 0);
    }

    public static final Complex[] resize(Complex[] array, int newLength, int startIdx) {
        Complex[] returnValue = new Complex[newLength];
        int copySize = Math.min(newLength, array.length - startIdx);
        if (startIdx >= array.length && copySize > 0) {
            throw new IllegalArgumentException("resize():  the start index '" + startIdx + "' is greather than equal to the array length '" + array.length + "' and the number of items to be copied '" + copySize + "' is greater than zero.");
        }
        if (copySize > 0) {
            System.arraycopy(array, startIdx, returnValue, 0, copySize);
        }
        int i = copySize;
        while (i < newLength) {
            returnValue[i] = Complex.ZERO;
            ++i;
        }
        return returnValue;
    }

    public static final Complex[] scale(Complex[] array, Complex factor) {
        int len = array.length;
        Complex[] returnValue = new Complex[len];
        int i = 0;
        while (i < len) {
            returnValue[i] = array[i].multiply(factor);
            ++i;
        }
        return returnValue;
    }

    public static final Complex[] scale(Complex[] array, double factor) {
        int len = array.length;
        Complex[] returnValue = new Complex[len];
        int i = 0;
        while (i < len) {
            returnValue[i] = array[i].scale(factor);
            ++i;
        }
        return returnValue;
    }

    public static final Complex[] subtract(Complex[] array, Complex z) {
        Complex[] result = new Complex[array.length];
        int i = array.length - 1;
        while (i >= 0) {
            result[i] = array[i].subtract(z);
            --i;
        }
        return result;
    }

    public static final Complex[] subtract(Complex[] array1, Complex[] array2) {
        int length = ComplexArrayMath._commonLength(array1, array2, "ComplexArrayMath.subtract");
        Complex[] result = new Complex[length];
        int i = 0;
        while (i < length) {
            result[i] = array1[i].subtract(array2[i]);
            ++i;
        }
        return result;
    }

    public static final String toString(Complex[] array) {
        return ComplexArrayMath.toString(array, ", ", "{", "}");
    }

    public static final String toString(Complex[] array, String elementDelimiter, String vectorBegin, String vectorEnd) {
        int length = array.length;
        StringBuffer sb = new StringBuffer();
        sb.append(vectorBegin);
        int i = 0;
        while (i < length) {
            sb.append(array[i].toString());
            if (i < length - 1) {
                sb.append(elementDelimiter);
            }
            ++i;
        }
        sb.append(vectorEnd);
        return sb.toString();
    }

    public static final boolean within(Complex[] array1, Complex[] array2, Complex maxError) {
        return ComplexArrayMath.within(array1, array2, maxError.magnitude());
    }

    public static final boolean within(Complex[] array1, Complex[] array2, double maxError) {
        int length = ComplexArrayMath._commonLength(array1, array2, "ComplexArrayMath.within");
        int i = 0;
        while (i < length) {
            if (!array1[i].isCloseTo(array2[i], maxError)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static final boolean within(Complex[] array1, Complex[] array2, double[] maxError) {
        int length = ComplexArrayMath._commonLength(array1, array2, "ComplexArrayMath.within");
        int i = 0;
        while (i < length) {
            if (!array1[i].isCloseTo(array2[i], maxError[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static final boolean within(Complex[] array1, Complex[] array2, Complex[] maxError) {
        int length = maxError.length;
        double[] doubleError = new double[length];
        int i = 0;
        while (i < length) {
            doubleError[i] = maxError[i].magnitude();
            ++i;
        }
        return ComplexArrayMath.within(array1, array2, doubleError);
    }

    protected static final int _commonLength(Complex[] array1, Complex[] array2, String methodName) {
        if (array1 == null) {
            throw new IllegalArgumentException("ptolemy.math." + methodName + "() : first input array is null.");
        }
        if (array2 == null) {
            throw new IllegalArgumentException("ptolemy.math." + methodName + "() : second input array is null.");
        }
        if (array1.length != array2.length) {
            throw new IllegalArgumentException("ptolemy.math." + methodName + "() : input arrays must have the same length, " + "but the first array has length " + array1.length + " and the second array has length " + array2.length + '.');
        }
        return array1.length;
    }
}

