/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.kernel.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.Configurable;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Settable;
import ptolemy.kernel.util.ValueListener;
import ptolemy.kernel.util.Workspace;

public class ConfigurableAttribute
extends Attribute
implements Configurable,
Settable {
    private URL _base;
    private String _configureSource;
    private String _configureText;
    private String _defaultText;
    private String _displayName;
    private List _valueListeners;
    private Settable.Visibility _visibility = Settable.NONE;

    public ConfigurableAttribute() {
    }

    public ConfigurableAttribute(Workspace workspace) {
        super(workspace);
    }

    public ConfigurableAttribute(NamedObj container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
    }

    public void addValueListener(ValueListener listener) {
        if (this._valueListeners == null) {
            this._valueListeners = new LinkedList();
        }
        if (!this._valueListeners.contains(listener)) {
            this._valueListeners.add(listener);
        }
    }

    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        ConfigurableAttribute newObject = (ConfigurableAttribute)super.clone(workspace);
        newObject._valueListeners = null;
        return newObject;
    }

    public void configure(URL base, String source, String text) throws Exception {
        if (this._defaultText == null) {
            this._defaultText = this._configureText;
        }
        this._base = base;
        this._configureSource = source;
        this._configureText = text;
    }

    public URL getBase() {
        return this._base;
    }

    public String getConfigureSource() {
        return this._configureSource;
    }

    public String getConfigureText() {
        return this._configureText;
    }

    public String getDefaultExpression() {
        try {
            List prototypeList = this.getPrototypeList();
            if (prototypeList.size() > 0) {
                return ((Settable)prototypeList.get(0)).getExpression();
            }
        }
        catch (IllegalActionException e) {
            throw new InternalErrorException(e);
        }
        return this._defaultText;
    }

    public String getDisplayName() {
        if (this._displayName != null) {
            return this._displayName;
        }
        return this.getName();
    }

    public String getExpression() {
        try {
            return this.value();
        }
        catch (Exception ex) {
            return ex.toString();
        }
    }

    public String getValueAsString() {
        return this.getExpression();
    }

    public Settable.Visibility getVisibility() {
        return this._visibility;
    }

    public void removeValueListener(ValueListener listener) {
        if (this._valueListeners != null) {
            this._valueListeners.remove(listener);
        }
    }

    public void setDisplayName(String name) {
        this._displayName = name;
    }

    public void setExpression(String expression) throws IllegalActionException {
        try {
            this.configure(null, null, expression);
            this.validate();
        }
        catch (IllegalActionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new InternalErrorException("Unexpected exception: " + ex);
        }
    }

    public void setVisibility(Settable.Visibility visibility) {
        this._visibility = visibility;
    }

    public Collection validate() throws IllegalActionException {
        try {
            this.value();
        }
        catch (IOException ex) {
            throw new IllegalActionException((Nameable)this, ex, "Failed to read configuration at: " + this._configureSource);
        }
        NamedObj container = this.getContainer();
        if (container != null) {
            container.attributeChanged(this);
        }
        HashSet<ValueListener> result = new HashSet<ValueListener>();
        if (this._valueListeners != null) {
            for (ValueListener listener : this._valueListeners) {
                if (listener instanceof Settable) {
                    Collection validated = ((Settable)((Object)listener)).validate();
                    if (validated != null) {
                        result.addAll(validated);
                    }
                    result.add(listener);
                    continue;
                }
                listener.valueChanged(this);
            }
        }
        return result;
    }

    public String value() throws IOException {
        StringBuffer value = new StringBuffer();
        if (this._configureSource != null && !this._configureSource.trim().equals("")) {
            URL textFile = new URL(this._configureSource);
            InputStream stream = textFile.openStream();
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new InputStreamReader(stream));
                String line = reader.readLine();
                while (line != null) {
                    value.append(line);
                    value.append("\n");
                    line = reader.readLine();
                }
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
            stream.close();
        }
        if (this._configureText != null) {
            value.append(this._configureText);
        }
        return value.toString();
    }

    protected void _exportMoMLContents(Writer output, int depth) throws IOException {
        super._exportMoMLContents(output, depth);
        String sourceSpec = "";
        if (this._configureSource != null && !this._configureSource.trim().equals("")) {
            sourceSpec = " source=\"" + this._configureSource + "\"";
            if (this._configureText == null) {
                output.write(String.valueOf(ConfigurableAttribute._getIndentPrefix(depth)) + "<configure" + sourceSpec + "/>\n");
            }
        }
        if (this._configureText != null) {
            output.write(String.valueOf(ConfigurableAttribute._getIndentPrefix(depth)) + "<configure" + sourceSpec + ">" + this._configureText + "</configure>\n");
        }
    }

    protected void _propagateValue(NamedObj destination) throws IllegalActionException {
        try {
            ((Configurable)((Object)destination)).configure(this._base, this._configureSource, this._configureText);
        }
        catch (Exception ex) {
            throw new IllegalActionException((Nameable)this, ex, "Propagation failed.");
        }
    }
}

