/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.kernel.undo;

import java.util.List;
import java.util.Stack;
import ptolemy.kernel.undo.UndoAction;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.KernelException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.SingletonAttribute;

public class UndoStackAttribute
extends SingletonAttribute {
    private int _inRedo = 0;
    private int _inUndo = 0;
    private Stack _redoEntries = new Stack();
    private Stack _undoEntries = new Stack();

    public UndoStackAttribute(NamedObj container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.setPersistent(false);
    }

    public static UndoStackAttribute getUndoInfo(NamedObj object) {
        try {
            object.workspace().getReadAccess();
            NamedObj topLevel = object.toplevel();
            NamedObj container = object;
            while (container != null) {
                List attrList = container.attributeList(UndoStackAttribute.class);
                if (attrList.size() > 0) {
                    UndoStackAttribute undoStackAttribute = (UndoStackAttribute)attrList.get(0);
                    return undoStackAttribute;
                }
                container = container.getContainer();
            }
            try {
                UndoStackAttribute undoStackAttribute = new UndoStackAttribute(topLevel, "_undoInfo");
                return undoStackAttribute;
            }
            catch (KernelException e) {
                throw new InternalErrorException(e);
            }
        }
        finally {
            object.workspace().doneReading();
        }
    }

    public void mergeTopTwo() {
        try {
            this.workspace().getWriteAccess();
            if (this._inUndo == 0 && this._inRedo == 0 && this._undoEntries.size() > 1) {
                UndoAction lastUndo = (UndoAction)this._undoEntries.pop();
                UndoAction firstUndo = (UndoAction)this._undoEntries.pop();
                MergeUndoActions mergedAction = new MergeUndoActions(lastUndo, firstUndo);
                this._undoEntries.push(mergedAction);
                if (this._debugging) {
                    this._debug("=======> Merging top two on undo stack:\n" + mergedAction);
                }
            }
        }
        finally {
            this.workspace().doneWriting();
        }
    }

    public void push(UndoAction action) {
        try {
            this.workspace().getWriteAccess();
            if (this._inUndo > 1) {
                UndoAction previousRedo = (UndoAction)this._redoEntries.pop();
                MergeUndoActions mergedAction = new MergeUndoActions(action, previousRedo);
                this._redoEntries.push(mergedAction);
                if (this._debugging) {
                    this._debug("=======> Merging action onto redo stack to get:\n" + mergedAction);
                }
                ++this._inUndo;
            } else if (this._inUndo == 1) {
                if (this._debugging) {
                    this._debug("=======> Pushing action onto redo stack:\n" + action);
                }
                this._redoEntries.push(action);
                ++this._inUndo;
            } else if (this._inRedo > 1) {
                UndoAction previousUndo = (UndoAction)this._undoEntries.pop();
                MergeUndoActions mergedAction = new MergeUndoActions(action, previousUndo);
                if (this._debugging) {
                    this._debug("=======> Merging redo action onto undo stack to get:\n" + mergedAction);
                }
                this._undoEntries.push(mergedAction);
                ++this._inRedo;
            } else if (this._inRedo == 1) {
                if (this._debugging) {
                    this._debug("=======> Pushing redo action onto undo stack:\n" + action);
                }
                this._undoEntries.push(action);
                ++this._inRedo;
            } else {
                if (this._debugging) {
                    this._debug("=======> Pushing action onto undo stack:\n" + action);
                }
                this._undoEntries.push(action);
                if (this._debugging) {
                    this._debug("======= Clearing redo stack.\n");
                }
                this._redoEntries.clear();
            }
        }
        finally {
            this.workspace().doneWriting();
        }
    }

    public void redo() throws Exception {
        if (this._redoEntries.size() > 0) {
            try {
                this.workspace().getWriteAccess();
                UndoAction action = (UndoAction)this._redoEntries.pop();
                if (this._debugging) {
                    this._debug("<====== Executing redo action:\n" + action);
                }
                try {
                    this._inRedo = 1;
                    action.execute();
                }
                finally {
                    this._inRedo = 0;
                }
            }
            finally {
                this.workspace().doneWriting();
            }
        }
    }

    public void undo() throws Exception {
        block7: {
            try {
                this.workspace().getWriteAccess();
                if (this._undoEntries.size() <= 0) break block7;
                UndoAction action = (UndoAction)this._undoEntries.pop();
                if (this._debugging) {
                    this._debug("<====== Executing undo action:\n" + action);
                }
                try {
                    this._inUndo = 1;
                    action.execute();
                }
                finally {
                    this._inUndo = 0;
                }
            }
            finally {
                this.workspace().doneWriting();
            }
        }
    }

    private static class MergeUndoActions
    implements UndoAction {
        private UndoAction _firstAction;
        private UndoAction _secondAction;

        public MergeUndoActions(UndoAction firstAction, UndoAction secondAction) {
            this._firstAction = firstAction;
            this._secondAction = secondAction;
        }

        public void execute() throws Exception {
            this._firstAction.execute();
            this._secondAction.execute();
        }

        public String toString() {
            return "Merged action.\nFirst part:\n" + this._firstAction + "\n\nSecond part:\n" + this._secondAction;
        }
    }
}

