/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.kernel.attributes;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import ptolemy.kernel.attributes.FileOrURLAccessor;
import ptolemy.kernel.attributes.URIAttribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.StringAttribute;
import ptolemy.kernel.util.Workspace;
import ptolemy.util.FileUtilities;
import ptolemy.util.StringUtilities;

public class FileAttribute
extends StringAttribute
implements FileOrURLAccessor {
    private URI _baseDirectory;
    private BufferedReader _reader;
    private Writer _writer;

    public FileAttribute(NamedObj container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
    }

    public File asFile() throws IllegalActionException {
        String name = FileAttribute._substituteSpecialStrings(this.getExpression());
        try {
            return FileUtilities.nameToFile(name, this.getBaseDirectory());
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalActionException((Nameable)this, ex, "Failed to create a file with name '" + name + "'.");
        }
    }

    public URL asURL() throws IllegalActionException {
        String name = FileAttribute._substituteSpecialStrings(this.getExpression());
        if (name == null || name.trim().equals("")) {
            return null;
        }
        if (name.startsWith("$CLASSPATH")) {
            String trimmedName = name.substring(11);
            URL result = this.getClass().getClassLoader().getResource(trimmedName);
            if (result == null) {
                throw new IllegalActionException((Nameable)this, "Cannot find file in classpath: " + name);
            }
            return result;
        }
        File file = new File(name);
        if (file.isAbsolute()) {
            if (!file.canRead()) {
                throw new IllegalActionException((Nameable)this, "Cannot read file: " + name);
            }
            try {
                return file.toURL();
            }
            catch (MalformedURLException ex) {
                throw new IllegalActionException((Nameable)this, "Cannot open file: " + ex.toString());
            }
        }
        URI modelURI = this.getBaseDirectory();
        if (modelURI != null) {
            try {
                URI newURI = modelURI.resolve(name);
                return newURI.toURL();
            }
            catch (MalformedURLException malformedURLException) {
                throw new IllegalActionException((Nameable)this, "Unable to open as a file or URL: " + name);
            }
        }
        try {
            return new URL(name);
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalActionException((Nameable)this, "Unable to open as a file or URL: " + name);
        }
    }

    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        FileAttribute newObject = (FileAttribute)super.clone(workspace);
        newObject._baseDirectory = null;
        newObject._reader = null;
        newObject._writer = null;
        return newObject;
    }

    public void close() throws IllegalActionException {
        if (this._reader != null && this._reader != FileUtilities.STD_IN) {
            try {
                this._reader.close();
            }
            catch (IOException iOException) {}
        }
        if (this._writer != null) {
            try {
                this._writer.flush();
                if (this._writer != FileUtilities.STD_OUT) {
                    this._writer.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public URI getBaseDirectory() {
        if (this._baseDirectory != null) {
            return this._baseDirectory;
        }
        return URIAttribute.getModelURI(this);
    }

    public BufferedReader openForReading() throws IllegalActionException {
        try {
            this._reader = FileUtilities.openForReading(this.getExpression(), this.getBaseDirectory(), this.getClass().getClassLoader());
            return this._reader;
        }
        catch (IOException ex) {
            throw new IllegalActionException((Nameable)this, ex, "Cannot open file or URL");
        }
    }

    public Writer openForWriting() throws IllegalActionException {
        return this.openForWriting(false);
    }

    public Writer openForWriting(boolean append) throws IllegalActionException {
        try {
            this._writer = FileUtilities.openForWriting(this.getExpression(), this.getBaseDirectory(), append);
            return this._writer;
        }
        catch (IOException ex) {
            throw new IllegalActionException((Nameable)this, ex, "Cannot open file for writing");
        }
    }

    public void setBaseDirectory(URI directory) {
        this._baseDirectory = directory;
    }

    private static String _substituteSpecialStrings(String string) {
        String result = string;
        if (result.indexOf("$CWD") >= 0) {
            result = StringUtilities.substitute(result, "$CWD", StringUtilities.getProperty("user.dir"));
        }
        if (result.indexOf("$HOME") >= 0) {
            result = StringUtilities.substitute(result, "$HOME", StringUtilities.getProperty("user.home"));
        }
        if (result.indexOf("$PTII") >= 0) {
            result = StringUtilities.substitute(result, "$PTII", StringUtilities.getProperty("ptolemy.ptII.dir"));
        }
        if (result.indexOf("$TMPDIR") >= 0) {
            result = StringUtilities.substitute(result, "$TMPDIR", StringUtilities.getProperty("java.io.tmpdir"));
        }
        return result;
    }
}

